@foreach ($menus = DashboardMenu::getAll() as $menu)
    @php $menu = apply_filters(BASE_FILTER_DASHBOARD_MENU, $menu); @endphp
    <li
        class="nav-item @if ($menu['active']) active @endif"
        id="{{ $menu['id'] }}"
    >
        <a
            class="nav-link nav-toggle"
            href="{{ $menu['url'] }}"
        >
            <i class="{{ $menu['icon'] }}"></i>
            <span class="title">
                {{ !is_array(trans($menu['name'])) ? trans($menu['name']) : null }}
                {!! apply_filters(BASE_FILTER_APPEND_MENU_NAME, null, $menu['id']) !!}</span>
            @if (isset($menu['children']) && count($menu['children']))
                <span class="arrow @if ($menu['active']) open @endif"></span>
            @endif
        </a>
        @if (isset($menu['children']) && count($menu['children']))
            <ul class="sub-menu @if (!$menu['active']) hidden-ul @endif">
                @foreach ($menu['children'] as $item)
                    <li
                        class="nav-item @if ($item['active']) active @endif"
                        id="{{ $item['id'] }}"
                    >
                        <a
                            class="nav-link"
                            href="{{ $item['url'] }}"
                        >
                            <i class="{{ $item['icon'] }}"></i>
                            {{ trans($item['name']) }}
                            {!! apply_filters(BASE_FILTER_APPEND_MENU_NAME, null, $item['id']) !!}
                        </a>
                    </li>
                @endforeach
            </ul>
        @endif
    </li>
@endforeach
