<?php
/**
 * Team Widget
 */
namespace Elementor;
class Kiedo_Team_Two extends Widget_Base{
    public function get_name(){
        return "Kiedo_Team_Two";
    }
    public function get_title(){
        return "Team Two";
    }
    public function get_icon(){
        return "eicon-gallery-group";
    }
    public function get_categories(){
        return ['kiedo-elements'];
    }
    protected function register_controls(){

    $this->start_controls_section(
        'Kiedo_Team_Two',
        [
            'label' => __( 'Kiedo Team', 'kiedo-toolkit' ),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]
    );

        $repeater = new Repeater();

        $repeater->add_control(
            'member_img',
            [
                'label' => esc_html__( 'Image', 'kiedo-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Member Name', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__( 'Designation', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'icon1',
            [
                'label' => esc_html__( 'Social Icon One', 'kiedo-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => kiedo_icons(),
            ]
        );
        $repeater->add_control(
            'url1',
            [
                'label' => esc_html__( 'Social Link One', 'kiedo-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon2',
            [
                'label' => esc_html__( 'Social Icon Two', 'kiedo-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => kiedo_icons(),
            ]
        );
        $repeater->add_control(
            'url2',
            [
                'label' => esc_html__( 'Social Link Two', 'kiedo-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon3',
            [
                'label' => esc_html__( 'Social Icon Three', 'kiedo-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => kiedo_icons(),
            ]
        );
        $repeater->add_control(
            'url3',
            [
                'label' => esc_html__( 'Social Link Three', 'kiedo-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon4',
            [
                'label' => esc_html__( 'Social Icon Four', 'kiedo-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => kiedo_icons(),
            ]
        );
        $repeater->add_control(
            'url4',
            [
                'label' => esc_html__( 'Social Link Four', 'kiedo-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon5',
            [
                'label' => esc_html__( 'Social Icon Five', 'kiedo-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => kiedo_icons(),
            ]
        );
        $repeater->add_control(
            'url5',
            [
                'label' => esc_html__( 'Social Link Five', 'kiedo-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'teams',
            [
                'label' => esc_html__( 'Add Member', 'kiedo-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

		$this->add_control(
			'link_title',
			[
				'label'		=> esc_html__('Link Title', 'kiedo-toolkit'),
				'type'		=> Controls_Manager:: TEXT,
			]
		);

		$this->add_control(
			'link',
			[
				'label'		=> esc_html__('Link', 'kiedo-toolkit'),
				'type'		=> Controls_Manager:: TEXT,
			]
		);

    $this-> end_controls_section();

    // Start Style content controls
    $this-> start_controls_section(
        'style',
        [
            'label'=>esc_html__('Style', 'kiedo-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Member Name Color', 'kiedo-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-member .content h3' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_size',
				'label' => __( 'Name Typography', 'kiedo-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-member .content h3',
			]
		);

        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__( 'Member Designation Color', 'kiedo-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-member .content span' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_size',
				'label' => __( 'Designation Typography', 'kiedo-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-member .content span',
			]
		);
    $this-> end_controls_section();
}
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <div class="container">
			<div class="row">
                <?php foreach( $settings['teams'] as $item ): ?>
					<div class="col-lg-3 col-md-6">
						<div class="single-team-member">
							<div class="image">
								<?php if( $item['member_img']['url'] != '' ): ?>
									<img src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
								<?php endif; ?>
							</div>

							<div class="content">
                            	<h3><?php echo esc_html( $item['name'] ); ?></h3>
								<span><?php echo esc_html( $item['designation'] ); ?></span>
							</div>

                            <ul class="social-links">
                                <?php if( $item['icon1'] != '' && $item['url1']['url'] != '' ): ?>
                                    <li><a class="d-block" href="<?php echo esc_url( $item['url1']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon1'] ); ?>"></i></a></li>
                                <?php endif; ?>

                                <?php if( $item['icon2'] != '' && $item['url2']['url'] != '' ): ?>
                                    <li><a class="d-block" href="<?php echo esc_url( $item['url2']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon2'] ); ?>"></i></a></li>
                                <?php endif; ?>

                                <?php if( $item['icon3'] != '' && $item['url3']['url'] != '' ): ?>
                                    <li><a class="d-block" href="<?php echo esc_url( $item['url3']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon3'] ); ?>"></i></a></li>
                                <?php endif; ?>

                                <?php if( $item['icon4'] != '' && $item['url4']['url'] != '' ): ?>
                                    <li><a class="d-block" href="<?php echo esc_url( $item['url4']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon4'] ); ?>"></i></a></li>
                                <?php endif; ?>
                                <?php if( $item['icon5']
                                    != '' && $item['url5']['url'] != '' ): ?>
                                    <li><a class="d-block" href="<?php echo esc_url( $item['url5']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon5'] ); ?>"></i></a></li>
                                <?php endif; ?>
                            </ul>
						</div>
					</div>
                <?php endforeach; ?>
			</div>
		</div>

		<?php if($settings['link_title'] != ''): ?>
			<div class="default-btn">
				<a href="<?php echo esc_url($settings['link']); ?>" class="see-btn"><?php echo esc_html($settings['link_title']) ?></a>
			</div>
		<?php endif; ?>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Kiedo_Team_Two );