<?php
/**
 * Subscribe Widget
 */

namespace Elementor;
class Kiedo_Subscribe extends Widget_Base {

	public function get_name() {
        return 'Subscribe';
    }

	public function get_title() {
        return __( 'Subscribe', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-handle';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Subscribe',
			[
				'label' => __( 'Kiedo Subscribe', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                        '5'         => esc_html__( 'Style 5', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => __( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('FREE TRIAL', 'kiedo-toolkit'),
                ]
            );
            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Start Your 14 Days Free Trials Today!', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'kiedo-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/kiedo-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Placeholder Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter Your Email Address' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Get Started' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'sec_image',
                [
                    'label' => __( 'Section Image', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['3','4','5'],
                    ]
                ]
            );
            $this->add_control(
                'shape1',
                [
                    'label' => __( 'Shape 1', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape2',
                [
                    'label' => __( 'Shape 2', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style!' => ['4','5'],
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .free-trial-content .sub-title, .new-free-trial-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .free-trial-content .sub-title, .new-free-trial-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .free-trial-content h2, .free-trial-content h1, .free-trial-content h3, .free-trial-content h4, .free-trial-content h5, .free-trial-content h6, .new-free-trial-content h2, .new-free-trial-content h1, .new-free-trial-content h3, .new-free-trial-content h4, .new-free-trial-content h5, .new-free-trial-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .free-trial-content h2, .free-trial-content h1, .free-trial-content h3, .free-trial-content h4, .free-trial-content h5, .free-trial-content h6, .new-free-trial-content h2, .new-free-trial-content h1, .new-free-trial-content h3, .new-free-trial-content h4, .new-free-trial-content h5, .new-free-trial-content h6',
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'  => 'background',
                    'label' => esc_html__( 'Background', 'kiedo-toolkit' ),
                    'types' => [ 'gradient' ],
                    'selector' => '{{WRAPPER}} .new-free-trial-inner-box',
                    'condition' => [
                        'style' => ['4','5'],
                    ]
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        if($settings['style'] == '1'):
            $divclass = "free-trial-area pb-100";
            $contentclass = "free-trial-content";
        elseif($settings['style'] == '2'):
            $divclass = "free-trial-area";
            $contentclass = "free-trial-content bg-color";
        endif;
        ?>

        <?php if($settings['style'] == '1' || $settings['style'] == '2') : ?>
            <div class="<?php echo esc_attr($divclass); ?>">
                <div class="container">
                    <div class="<?php echo esc_attr($contentclass); ?>">
                        <?php if( $settings['top_title'] != '' ): ?>
                            <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                        <?php endif; ?>
                        <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                        <form class="mailchimp2 free-trial-form" method="post">
                            <div class="form-group subcribes">
                                <input type="email" class="input-newsletter memail2" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                                <span class="label-title"><i class='bx bx-envelope'></i></span>
                            </div>
                            <?php if( $settings['button_text'] != '' ): ?>
                                <button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
                            <?php endif; ?>
                            <p class="mchimp-errmessage2 alert alert-danger mt-1" style="display: none;"></p>
                            <p class="mchimp-sucmessage2 alert alert-primary mt-1" style="display: none;"></p>
                        </form>

                        <script>
                            ;(function($){
                                "use strict";
                                $(document).ready(function () {
                                    // MAILCHIMP
                                    if ($(".mailchimp2").length > 0) {
                                        $(".mailchimp2").ajaxChimp({
                                            callback: mailchimpCallback2,
                                            url: "<?php echo esc_js($settings['action_url']) ?>"
                                        });
                                    }

                                    $(".memail2").on("focus", function () {
                                        $(".mchimp-errmessage2").fadeOut();
                                        $(".mchimp-sucmessage2").fadeOut();
                                    });
                                    $(".memail2").on("keydown", function () {
                                        $(".mchimp-errmessage2").fadeOut();
                                        $(".mchimp-sucmessage2").fadeOut();
                                    });
                                    $(".memail2").on("click", function () {
                                        $(".memail2").val("");
                                    });

                                    function mailchimpCallback2(resp) {
                                        if (resp.result === "success") {
                                            $(".mchimp-sucmessage2").html(resp.msg).fadeIn(1000);
                                            $(".mchimp-sucmessage2").fadeOut(500);
                                        } else if (resp.result === "error") {
                                            $(".mchimp-errmessage2").html(resp.msg).fadeIn(1000);
                                        }
                                    }
                                });
                            })(jQuery)
                        </script>

                        <?php if( $settings['shape1']['url'] != '' ): ?>
                            <div class="shape8"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>

                        <?php if( $settings['shape2']['url'] != '' ): ?>
                            <div class="shape9"><img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>

                        <div class="lines">
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3') : ?>
            <div class="free-trial-area">
                <div class="container">
                    <div class="free-trial-inner">
                        <div class="row">
                            <div class="col-lg-6 col-md-12">
                                <div class="content">
                                    <?php if( $settings['top_title'] != '' ): ?>
                                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                    <?php endif; ?>
                                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                                    <form class="mailchimp2 free-trial-form" method="post">
                                        <div class="form-group subcribes">
                                            <input type="email" class="input-newsletter memail2" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                                            <span class="label-title"><i class='bx bx-envelope'></i></span>
                                        </div>
                                        <?php if( $settings['button_text'] != '' ): ?>
                                            <button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
                                        <?php endif; ?>
                                        <p class="mchimp-errmessage2 alert alert-danger mt-1" style="display: none;"></p>
                                        <p class="mchimp-sucmessage2 alert alert-primary mt-1" style="display: none;"></p>
                                    </form>

                                    <script>
                                        ;(function($){
                                            "use strict";
                                            $(document).ready(function () {
                                                // MAILCHIMP
                                                if ($(".mailchimp2").length > 0) {
                                                    $(".mailchimp2").ajaxChimp({
                                                        callback: mailchimpCallback2,
                                                        url: "<?php echo esc_js($settings['action_url']) ?>"
                                                    });
                                                }

                                                $(".memail2").on("focus", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("keydown", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("click", function () {
                                                    $(".memail2").val("");
                                                });

                                                function mailchimpCallback2(resp) {
                                                    if (resp.result === "success") {
                                                        $(".mchimp-sucmessage2").html(resp.msg).fadeIn(1000);
                                                        $(".mchimp-sucmessage2").fadeOut(500);
                                                    } else if (resp.result === "error") {
                                                        $(".mchimp-errmessage2").html(resp.msg).fadeIn(1000);
                                                    }
                                                }
                                            });
                                        })(jQuery)
                                    </script>

                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <?php if( $settings['sec_image']['url'] != '' ): ?>
                                    <div class="image"><img src="<?php echo esc_url( $settings['sec_image']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if( $settings['shape1']['url'] != '' ): ?>
                            <div class="shape8"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>

                        <?php if( $settings['shape2']['url'] != '' ): ?>
                            <div class="shape9"><img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>
                        <div class="lines">
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '4') : ?>
            <div class="new-free-trial-area">
                <div class="container">
                    <div class="new-free-trial-inner-box">
                        <div class="row align-items-center">
                            <div class="col-lg-9 col-md-9">
                                <div class="new-free-trial-content">
                                    <?php if( $settings['top_title'] != '' ): ?>
                                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                    <?php endif; ?>
                                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                                    <form class="mailchimp2 free-trial-form" method="post">
                                        <input type="email" class="input-newsletter memail2" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                                        <?php if( $settings['button_text'] != '' ): ?>
                                            <button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
                                        <?php endif; ?>
                                        <p class="mchimp-errmessage2 alert alert-danger mt-1" style="display: none;"></p>
                                        <p class="mchimp-sucmessage2 alert alert-primary mt-1" style="display: none;"></p>
                                    </form>

                                    <script>
                                        ;(function($){
                                            "use strict";
                                            $(document).ready(function () {
                                                // MAILCHIMP
                                                if ($(".mailchimp2").length > 0) {
                                                    $(".mailchimp2").ajaxChimp({
                                                        callback: mailchimpCallback2,
                                                        url: "<?php echo esc_js($settings['action_url']) ?>"
                                                    });
                                                }

                                                $(".memail2").on("focus", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("keydown", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("click", function () {
                                                    $(".memail2").val("");
                                                });

                                                function mailchimpCallback2(resp) {
                                                    if (resp.result === "success") {
                                                        $(".mchimp-sucmessage2").html(resp.msg).fadeIn(1000);
                                                        $(".mchimp-sucmessage2").fadeOut(500);
                                                    } else if (resp.result === "error") {
                                                        $(".mchimp-errmessage2").html(resp.msg).fadeIn(1000);
                                                    }
                                                }
                                            });
                                        })(jQuery)
                                    </script>
                                </div>
                            </div>

                            <?php if( $settings['sec_image']['url'] != '' ): ?>
                            <div class="col-lg-3 col-md-3">
                                <div class="new-free-trial-image"><img src="<?php echo esc_url( $settings['sec_image']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if( $settings['shape1']['url'] != '' ): ?>
                            <div class="new-free-trial-shape"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '5') : ?>
            <div class="new-free-trial-area pb-100">
                <div class="container">
                    <div class="new-free-trial-inner-box wrap-with-gradient">
                        <div class="row align-items-center">
                            <div class="col-lg-9 col-md-9">
                                <div class="new-free-trial-content">
                                    <?php if( $settings['top_title'] != '' ): ?>
                                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                    <?php endif; ?>
                                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>

                                    <form class="mailchimp2 free-trial-form" method="post">
                                        <input type="email" class="input-newsletter memail2" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                                        <?php if( $settings['button_text'] != '' ): ?>
                                            <button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
                                        <?php endif; ?>
                                        <p class="mchimp-errmessage2 alert alert-danger mt-1" style="display: none;"></p>
                                        <p class="mchimp-sucmessage2 alert alert-primary mt-1" style="display: none;"></p>
                                    </form>

                                    <script>
                                        ;(function($){
                                            "use strict";
                                            $(document).ready(function () {
                                                // MAILCHIMP
                                                if ($(".mailchimp2").length > 0) {
                                                    $(".mailchimp2").ajaxChimp({
                                                        callback: mailchimpCallback2,
                                                        url: "<?php echo esc_js($settings['action_url']) ?>"
                                                    });
                                                }

                                                $(".memail2").on("focus", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("keydown", function () {
                                                    $(".mchimp-errmessage2").fadeOut();
                                                    $(".mchimp-sucmessage2").fadeOut();
                                                });
                                                $(".memail2").on("click", function () {
                                                    $(".memail2").val("");
                                                });

                                                function mailchimpCallback2(resp) {
                                                    if (resp.result === "success") {
                                                        $(".mchimp-sucmessage2").html(resp.msg).fadeIn(1000);
                                                        $(".mchimp-sucmessage2").fadeOut(500);
                                                    } else if (resp.result === "error") {
                                                        $(".mchimp-errmessage2").html(resp.msg).fadeIn(1000);
                                                    }
                                                }
                                            });
                                        })(jQuery)
                                    </script>
                                </div>
                            </div>

                            <?php if( $settings['sec_image']['url'] != '' ): ?>
                            <div class="col-lg-3 col-md-3">
                                <div class="new-free-trial-image"><img src="<?php echo esc_url( $settings['sec_image']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if( $settings['shape1']['url'] != '' ): ?>
                            <div class="new-free-trial-shape"><img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__( 'shape image', 'kiedo-toolkit' ); ?>"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Subscribe );