<?php
/**
 * Screenshots Sliders Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Screenshots_Sliders extends Widget_Base {

	public function get_name() {
        return 'Screenshots_Sliders';
    }

	public function get_title() {
        return __( 'Screenshots Sliders', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-post-slider';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'partner_section',
			[
				'label' => __( 'Screenshots Sliders Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
				'images',
				[
					'label' => __( 'Slider Images', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::GALLERY,

				]
			);

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="container">
            <div class="screenshots-slides owl-carousel owl-theme">
                <?php foreach ( $settings['images'] as $image ) { ?>
                    <div class="single-screenshot-item">
                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr__('Slider Image', 'kiedo-toolkit') ?>">
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Screenshots_Sliders );