<?php
/**
 * Button Widget
 */

namespace Elementor;
class Kiedo_Button extends Widget_Base {

	public function get_name() {
        return 'KiedoButton';
    }

	public function get_title() {
        return __( 'Kiedo Button', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-button';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Button',
			[
				'label' => __( 'Kiedo Button', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'button_text',
                [
                    'label'   => __( 'Button Text', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::TEXT,
                    'default' => __('Get In Touch', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'button_link',
                [
                    'label'   => __( 'Button Link', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::URL,
                ]
            );

            $this->add_control(
                'button_alignment',
                [
                    'label'   => __( 'Button Alignment', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'button-left'                => __( 'Left', 'kiedo-toolkit' ),
                        'button-center'              => __( 'Center', 'kiedo-toolkit' ),
                        'button-right'               => __( 'Right', 'kiedo-toolkit' ),
                        'align-justify'              => __( 'Justify', 'kiedo-toolkit' ),
                    ],
                    'default' => 'button-left',
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'Button_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'heading',
				[
					'label'     => __( 'Button Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::HEADING,
				]
			);

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'label' => __( 'Button Background Color', 'kiedo-toolkit' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .default-btn::before',
                ]
            );

            $this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_hover_text_color',
				[
					'label'     => __( 'Button Hover Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

            $this->add_responsive_control(
                'border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'text_padding',
                [
                    'label' => esc_html__( 'Padding', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        if ( ! empty( $settings['button_link']['url'] ) ) {
			$this->add_link_attributes( 'button_link', $settings['button_link'] );
		}

        ?>
        <div class="container">
            <div class="kiedo-button-title <?php echo esc_attr($settings['button_alignment']); ?>">
                <?php if( $settings['button_text']): ?>
                    <a <?php echo $this->get_render_attribute_string( 'button_link' ); ?>  class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Button );