<?php
/**
 * Funfacts Widget
 */

namespace Elementor;
class Kiedo_Funfacts extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Funfacts';
    }

	public function get_title() {
        return __( 'Funfacts', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'funfacts_section',
			[
				'label' => __( 'Funfacts Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $list_items = new Repeater();

            $list_items->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $list_items->add_control(
                'number',
                [
                    'type'    => Controls_Manager::NUMBER,
                    'label'   => __( 'Ending Number', 'kiedo-toolkit' ),
                    'default' => 324,
                ]
            );
            $list_items->add_control(
                'suffix',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Number Suffix', 'kiedo-toolkit' ),
                    'default' => __('+', 'kiedo-toolkit'),
                ]
            );
            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'kiedo-toolkit' ),
                    'default' => __('Project Completed', 'kiedo-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add Counter Item', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'counter_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'sec_bg_head',
                [
                    'label'     => esc_html__( 'Section Background Color', 'cyarb-toolkit' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'sec_bg_color',
                    'types'    => ['gradient' ],
                    'selector' => '{{WRAPPER}} .gradient-funfacts-area',
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'counter_color',
                [
                    'label' => __( 'Number Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .funfacts-box h3, .single-funfacts-card h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'num_typography',
                    'label' => __( 'Number Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .funfacts-box h3, .single-funfacts-card h3',
                ]
            );

            $this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .funfacts-boxs p, .single-funfacts-card p' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .funfacts-boxs p, .single-funfacts-card p',
                ]
            );

            $this->add_control(
				'icon_color',
				[
					'label' => __( 'Icon Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .funfacts-boxs i, .single-funfacts-card i' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '1',
                    ]
				]
			);
            $this->add_control(
				'icon_head',
				[
					'label'     => esc_html__( 'Icon Color', 'cyarb-toolkit' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
                    'condition' => [
                        'style' => '2',
                    ]
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'icon_title_color',
					'types'    => ['gradient' ],
					'selector' => '{{WRAPPER}} .single-funfacts-card .icon i',
                    'condition' => [
                        'style' => '2',
                    ]
				]
			);

            $this->add_control(
				'icon_bgcolor',
				[
					'label' => __( 'Icon Background Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  .single-funfacts-card .icon' => 'background-color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '2',
                    ]
				]
			);

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if($settings['style'] == '1'): ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="funfacts-box bg<?php echo $i; ?>">
                            <div class="icon">
                                <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                            </div>
                            <p><?php echo esc_html( $item['title'] ); ?></p>
                            <h3><span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span><span class="sign"><?php echo esc_html( $item['suffix'] ); ?></span></h3>
                        </div>
                    </div>
                <?php $i++; endforeach; ?>
            </div>
        </div>
        <?php else: ?>
        <div class="gradient-funfacts-area pt-100 pb-75">
            <div class="container">
                <div class="row justify-content-center">
                    <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                        <div class="col-lg-3 col-sm-6 col-md-6">
                            <div class="single-funfacts-card">
                                <div class="icon">
                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                </div>
                                <p><?php echo esc_html( $item['title'] ); ?></p>
                                <h3><span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span><span class="sign"><?php echo esc_html( $item['suffix'] ); ?></span></h3>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Funfacts );