<?php
/**
 * Features Post Area Widget
 */

namespace Elementor;
class Kiedo_Features_Area extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Features_Area';
    }

	public function get_title() {
        return __( 'Features Post', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-posts-justified';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'features_section',
			[
				'label' => __( 'Features Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label'   => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                        '5'         => esc_html__( 'Style 5', 'kiedo-toolkit' ),
                        '6'         => esc_html__( 'Style 6', 'kiedo-toolkit' ),
                        '7'         => esc_html__( 'Style 7', 'kiedo-toolkit' ),
                        '8'         => esc_html__( 'Style 8', 'kiedo-toolkit' ),
                        '9'         => esc_html__( 'Style 9', 'kiedo-toolkit' ),
                        '10'        => esc_html__( 'Style 10', 'kiedo-toolkit' ),
                        '11'        => esc_html__( 'Style 11', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'bg_text',
                [
                    'label'   => __( 'Background Text', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __('Features', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '10',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label' => __( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('KEY FEATURES', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['3','7','10','11'],
                    ]
                ]
            );
            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => __('Our Featured Services', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['3','7','10','11'],
                    ]
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                    'condition' => [
                        'style' => ['3','7','10','11'],
                    ]
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'condition' => [
                        'style' => ['3','7', '11'],
                    ]
                ]
            );

            $this->add_control(
				'left_button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['3','7','11'],
                    ]
				]
            );

            $this->add_control(
                'left_link',
                [
                    'label'		=> esc_html__('Left Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => ['3','7','11'],
                    ]
                ]
            );

            $this->add_control(
				'right_button_text',
				[
					'label' 	=> esc_html__( 'Right Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('See All Features', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => ['3','7','11'],
                    ]
				]
            );

            $this->add_control(
                'right_link',
                [
                    'label'		=> esc_html__('Right Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => ['3','7','11'],
                    ]
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label'   => __( 'Choose Category', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => kiedo_toolkit_get_page_features_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Features Order By', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'kiedo-toolkit' ),
                        'ASC'       => __( 'ASC', 'kiedo-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 4,
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '2',
                    ]
				]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'shape1',
                [
                    'label'		=> esc_html__('Shape Image One', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => '10',
                    ]
                ]
			);
			$this->add_control(
                'shape2',
                [
                    'label'		=> esc_html__('Shape Image Two', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => '10',
                    ]
                ]
			);
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Features Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'features',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'features_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'features',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $features_array = new \WP_Query( $args );
        ?>
        <?php if($settings['style'] == '1' || $settings['style'] == '2' || $settings['style'] == '4'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php if($settings['style'] == '1' || $settings['style'] == '4'): ?>
                        <?php
                        $i = 1;
                        while ($features_array->have_posts()): $features_array->the_post();
                            $idd = get_the_ID();
                            $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                            $output = array();

                            if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('icon');
                        ?>
                            <div class="<?php if($settings['style'] == '1'): echo 'col-xl-3 col-lg-4 col-sm-6 col-md-6'; else: echo 'col-lg-4 col-sm-6 col-md-6'; endif; ?>">
                                <div class="<?php if($settings['style'] == '1'): echo 'single-features-box'; else: echo 'features-item'; endif; ?>">
                                    <?php if($icon): ?>
                                        <div class="icon bg<?php echo $i; ?>">
                                            <i class="<?php echo esc_attr($icon) ?>"></i>
                                        </div>
                                    <?php endif; ?>

                                    <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                    <?php the_excerpt(); ?>
                                </div>
                            </div>
                        <?php $i++; endwhile; ?>
                        <?php wp_reset_query(); ?>
                    <?php elseif($settings['style'] == '2'): ?>
                        <?php
                        $i = 1;
                        while ($features_array->have_posts()): $features_array->the_post();
                            $idd = get_the_ID();
                            $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                            $output = array();

                            if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('icon');
                        ?>
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-md-6">
                                <div class="single-features-item">
                                    <?php if($icon): ?>
                                        <div class="icon bg<?php echo $i; ?>">
                                            <i class="<?php echo esc_attr($icon) ?>"></i>
                                        </div>
                                    <?php endif; ?>

                                    <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                    <?php the_excerpt(); ?>
                                </div>
                            </div>
                        <?php $i++; endwhile; ?>
                        <?php wp_reset_query(); ?>

                        <?php if($settings['button_text']): ?>
                            <div class="col-xl-12 col-lg-12 col-sm-12 col-md-12">
                                <div class="view-more-box">
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="features-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="features-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <<?php echo $settings['title_tag']?>><?php echo esc_html( $settings['title'] ); ?></<?php echo $settings['title_tag']?>>
                                <?php if( $settings['content'] != '' ): ?>
                                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <div class="btn-box">

                                <?php if($settings['left_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['left_link']); ?>" class="default-btn"><?php echo esc_html($settings['left_button_text']); ?></a>
                                <?php endif; ?>

                                <?php if($settings['right_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="list-of-features">
                                <div class="row justify-content-center">
                                    <?php
                                    $i = 1;
                                    while ($features_array->have_posts()): $features_array->the_post();
                                        $idd = get_the_ID();
                                        $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                                        $output = array();

                                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                            $post_link = get_the_permalink();
                                        } else {
                                            $post_link = get_field('external_link');
                                        }
                                        $icon = get_field('icon');
                                    ?>
                                        <div class="col-lg-6 col-sm-6 col-md-6">
                                            <div class="features-item with-border">
                                                <?php if($icon): ?>
                                                    <div class="icon bg<?php echo $i; ?>">
                                                        <i class="<?php echo esc_attr($icon) ?>"></i>
                                                    </div>
                                                <?php endif; ?>

                                                <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                                <?php the_excerpt(); ?>
                                            </div>
                                        </div>
                                    <?php $i++; endwhile; ?>
                                    <?php wp_reset_query(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '5'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                    $i = 1;
                    while ($features_array->have_posts()): $features_array->the_post();
                        $idd = get_the_ID();
                        $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                        $output = array();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('icon');
                    ?>
                        <div class="col-lg-4 col-sm-6 col-md-6">
                            <div class="features-item with-border">
                                <?php if($icon): ?>
                                    <div class="icon bg<?php echo $i; ?>">
                                        <i class="<?php echo esc_attr($icon) ?>"></i>
                                    </div>
                                <?php endif; ?>

                                <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                    <?php the_excerpt(); ?>
                            </div>
                        </div>
                    <?php $i++; endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '6'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                    $i = 1;
                    while ($features_array->have_posts()): $features_array->the_post();
                        $idd = get_the_ID();
                        $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                        $output = array();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('icon');
                    ?>
                        <div class="col-xl-3 col-lg-3 col-sm-3 col-md-3 col-6">
                            <div class="features-box">
                                <?php if($icon): ?>
                                    <div class="icon bg<?php echo $i; ?>">
                                        <i class="<?php echo esc_attr($icon) ?>"></i>
                                    </div>
                                <?php endif; ?>

                                <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                            </div>
                        </div>
                    <?php $i++; endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '7'): ?>
            <div class="features-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="features-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <<?php echo $settings['title_tag']?>><?php echo esc_html( $settings['title'] ); ?></<?php echo $settings['title_tag']?>>
                                <?php if( $settings['content'] != '' ): ?>
                                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <div class="btn-box">

                                <?php if($settings['left_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['left_link']); ?>" class="default-btn"><?php echo esc_html($settings['left_button_text']); ?></a>
                                <?php endif; ?>

                                <?php if($settings['right_button_text']): ?>
                                    <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="features-lists">
                                <ul>
                                    <?php
                                    $i = 1;
                                    while ($features_array->have_posts()): $features_array->the_post();
                                        $idd = get_the_ID();
                                        $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                                        $output = array();

                                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                            $post_link = get_the_permalink();
                                        } else {
                                            $post_link = get_field('external_link');
                                        }
                                        $icon = get_field('icon');
                                    ?>
                                        <li>
                                            <?php if($icon): ?>
                                                <div class="icon bg<?php echo $i; ?>">
                                                    <i class="<?php echo esc_attr($icon) ?>"></i>
                                                </div>
                                            <?php endif; ?>

                                            <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                            <?php the_excerpt(); ?>
                                        </li>
                                    <?php $i++; endwhile; ?>
                                    <?php wp_reset_query(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '8'): ?>
            <div class="features-area pb-100">
                <div class="container">
                    <div class="features-inner">
                        <div class="row align-items-center">
                            <?php
                            $i = 1;
                            while ($features_array->have_posts()): $features_array->the_post();
                                $idd = get_the_ID();
                                $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                                $output = array();

                                if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                    $post_link = get_the_permalink();
                                } else {
                                    $post_link = get_field('external_link');
                                }
                                $icon = get_field('icon');
                            ?>
                                <div class="col-xl-3 col-lg-3 col-sm-6 col-md-3 col-6">
                                    <div class="features-box">
                                        <?php if($icon): ?>
                                            <div class="icon bg<?php echo $i; ?>">
                                                <i class="<?php echo esc_attr($icon) ?>"></i>
                                            </div>
                                        <?php endif; ?>

                                        <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                    </div>
                                </div>
                            <?php $i++; endwhile; ?>
                            <?php wp_reset_query(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '9'): ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                    $i = 1;
                    while ($features_array->have_posts()): $features_array->the_post();
                        $idd = get_the_ID();
                        $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                        $output = array();

                        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                            $post_link = get_the_permalink();
                        } else {
                            $post_link = get_field('external_link');
                        }
                        $icon = get_field('icon');
                    ?>
                    <div class="col-xl-3 col-lg-4 col-sm-6 col-md-6">
                        <div class="features-card">
                            <?php if($icon): ?>
                                <div class="icon">
                                    <i class="<?php echo esc_attr($icon) ?>"></i>
                                    <div class="number"> <?php echo $i; ?></div>
                                </div>
                            <?php endif; ?>
                            <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                            <?php the_excerpt(); ?>
                        </div>
                    </div>
                    <?php $i++; endwhile; ?>
                    <?php wp_reset_query(); ?>
                </div>
            </div>
        <?php elseif($settings['style'] == '10') : ?>
            <div class="key-features-area pt-100 pb-75">
                <div class="container">
                    <?php if( $settings['bg_text'] != '' || $settings['top_title'] != '' ||  $settings['title'] != '' ): ?>
                        <div class="section-title title-with-bg-text">
                            <?php if( $settings['bg_text'] != '' ): ?>
                                <div class="big-title"><?php echo wp_kses_post( $settings['bg_text'] ); ?></div>
                            <?php endif; ?>
                            <?php if( $settings['top_title'] != '' ): ?>
                                <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>
                            <<?php echo $settings['title_tag']?>><?php echo esc_html( $settings['title'] ); ?></<?php echo $settings['title_tag']?>>
                        </div>
                    <?php endif; ?>

                    <div class="row justify-content-center">
                        <?php
                        $i = 1;
                        while ($features_array->have_posts()): $features_array->the_post();
                            $idd = get_the_ID();
                            $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                            $output = array();

                            if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                $post_link = get_the_permalink();
                            } else {
                                $post_link = get_field('external_link');
                            }
                            $icon = get_field('icon');
                        ?>
                        <div class="col-xl-4 col-lg-6 col-sm-6 col-md-6">
                            <div class="key-features-card">

                                <?php if($icon): ?>
                                    <div class="icon <?php if( $i % 2 == 0): ?>bg2<?php endif; ?>">
                                        <i class="<?php echo esc_attr($icon) ?>"></i>
                                    </div>
                                <?php endif; ?>

                                <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                <?php the_excerpt(); ?>
                            </div>
                        </div>
                        <?php $i++; endwhile; ?>
                        <?php wp_reset_query(); ?>
                    </div>
                </div>

                <?php if($settings['shape1']['url'] != ''): ?>
                    <div class="key-features-shape-1">
                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
                <?php if($settings['shape2']['url'] != ''): ?>
                    <div class="key-features-shape-2">
                        <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '11'): ?>
            <div class="features-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="features-inner-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>
                                <<?php echo $settings['title_tag']?>><?php echo esc_html( $settings['title'] ); ?></<?php echo $settings['title_tag']?>>
                                <?php if( $settings['content'] != '' ): ?>
                                    <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <div class="btn-box">
                                    <?php if($settings['left_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['left_link']); ?>" class="default-btn"><?php echo esc_html($settings['left_button_text']); ?></a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 features-inner-list">
                            <div class="row justify-content-center">
                            <?php $i = 1;
                            while ($features_array->have_posts()): $features_array->the_post();
                                $idd = get_the_ID();
                                $terms = wp_get_post_terms(get_the_ID(), 'features_cat');

                                $output = array();

                                if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                                    $post_link = get_the_permalink();
                                } else {
                                    $post_link = get_field('external_link');
                                }
                                $icon = get_field('icon');
                            ?>
                                <div class="col-lg-6 col-sm-6">
                                    <div class="features-inner-card <?php if($i == 2 || $i == 3 ): ?>with-box-shadow<?php endif; ?>">
                                        <div class="icon">
                                            <?php if($icon): ?>
                                                <i class="<?php echo esc_attr($icon) ?>"></i>
                                            <?php endif; ?>

                                            <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                        </div>
                                        <?php the_excerpt(); ?>
                                    </div>
                                </div>

                                <?php $i++; endwhile; ?>
                                <?php wp_reset_query(); ?>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Features_Area );