<?php
/**
 * Features Info Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Features_Info extends Widget_Base {

	public function get_name() {
        return 'Features_Info';
    }

	public function get_title() {
        return esc_html__( 'Features Info', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Features_Info',
			[
				'label' => esc_html__( 'Kiedo Features Info', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'container_wid',
                [
                    'label' => esc_html__( 'Section Width', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Container', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Container Fluid', 'kiedo-toolkit' ),
                    ],
                    'default' => '2',
                    'condition' => [
                        'style' => '4',
                    ]
                ]
            );


            $this->add_control(
                'bg_title',
                [
                    'label'   => esc_html__( 'Background Text', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('About Us', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label'   => esc_html__( 'Top Title', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Most Probably You Are Getting Best App Ever', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Most Probably You Are Getting Best App Ever', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. Never missyour chance its just began.', 'kiedo-toolkit'),
                ]
            );

			$repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'default' => 'Free Download App'
                ]
            );
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'default' => 'Just log in with your mail account from play store and using whatever you want for your business purpose.'
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Image', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Left Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

            $this->add_control(
				'right_button_text',
				[
					'label' 	=> esc_html__( 'Right Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('See All Features', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'right_link',
                [
                    'label'		=> esc_html__('Right Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'fimage',
                [
                    'label' => esc_html__( 'Features Info Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape1',
                [
                    'label'		=> esc_html__('Shape Image One', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => ['1','3','4'],
                    ]
                ]
			);
			$this->add_control(
                'shape2',
                [
                    'label'		=> esc_html__('Shape Image Two', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => ['1','3'],
                    ]
                ]
			);
			$this->add_control(
                'shape3',
                [
                    'label'		=> esc_html__('Shape Image Three', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
			);

			$this->add_control(
                'bg_shape',
                [
                    'label'		=> esc_html__('Section Background Shape', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: MEDIA,
                    'condition' => [
                        'style' => '1',
                    ]
                ]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'bgtext_typography',
                    'label' => __( 'Background Text Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .app-about-content .big-text',
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-about-content .sub-title' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'toptitle_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .app-about-content .sub-title',
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-content  h2, .features-content  h3, .features-content  h4, .features-content  h5, .features-content  h5, .features-content  h6, .features-content  h1, .overview-content h2, .overview-content h1, .overview-content h3, .overview-content h4, .overview-content h5, .overview-content h6, .app-about-content h2, .app-about-content h1, .app-about-content h3, .app-about-content h4, .app-about-content h5, .app-about-content h6, .app-ever-content h2, .app-ever-content h1, .app-ever-content h3, .app-ever-content h4, .app-ever-content h5, .app-ever-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-content  h2, .features-content  h3, .features-content  h4, .features-content  h5, .features-content  h5, .features-content  h6, .features-content  h1, .overview-content h2, .overview-content h1, .overview-content h3, .overview-content h4, .overview-content h5, .overview-content h6, .app-about-content h2, .app-about-content h1, .app-about-content h3, .app-about-content h4, .app-about-content h5, .app-about-content h6, .app-ever-content h2, .app-ever-content h1, .app-ever-content h3, .app-ever-content h4, .app-ever-content h5, .app-ever-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-content  p, .overview-content p,  .app-about-content p, .app-ever-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .features-content  p, .overview-content p,  .app-about-content p, .app-ever-content p',
                ]

            );

            $this->add_control(
                'list_title_color',
                [
                    'label' => esc_html__( 'List Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-content .features-list li h3, .overview-content .features-list li h3, .app-about-content .list li h3, .app-ever-content .list li h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_title_typography',
                    'label' => __( 'List Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-content .features-list li h3, .overview-content .features-list li h3, .app-about-content .list li h3, .app-ever-content .list li h3',
                ]
            );
            $this->add_control(
                'list_con_color',
                [
                    'label' => esc_html__( 'List Description Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-content .features-list li p, .overview-content .features-list li p, .app-about-content .list li p, .app-ever-content .list li p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_desc_typography',
                    'label' => __( 'List Description Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .features-content .features-list li p, .overview-content .features-list li p, .app-about-content .list li p, .app-ever-content .list li p',
                ]
            );
            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_bgcolor',
                [
                    'label' => esc_html__( 'Button Background Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn::before' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .default-btn',
                ]
            );
            $this->add_control(
                'btn_2color',
                [
                    'label' => esc_html__( 'Button Two Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-about-content .btn-box .link-btn, .app-ever-content .btn-box .link-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style' => ['3','4'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn2_typography',
                    'label' => __( 'Button Two Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .app-about-content .btn-box .link-btn, .app-ever-content .btn-box .link-btn',
                    'condition' => [
                        'style' => ['3','4'],
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');
        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="features-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="features-content">
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>


                                <ul class="features-list">
                                    <?php $i= 1; foreach($settings['items'] as $item): ?>
                                        <li>
                                            <?php if($item['icon']): ?>
                                                <div class="icon bg<?php echo$i; ?>">
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>
                                            <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['content'] ); ?></p>
                                        </li>
                                    <?php $i++; endforeach; ?>
                                </ul>
                                <div class="btn-box">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="features-image text-center">
                                <?php if($settings['fimage']['url']): ?>
                                    <img src="<?php echo esc_url( $settings['fimage']['url'] ); ?>" alt="<?php echo esc_attr__('app-img', 'kiedo-toolkit'); ?>" data-aos="fade-up">
                                <?php endif; ?>

                                <div class="shape">
                                    <?php if($settings['shape1']['url'] != ''): ?>
                                        <div class="shape3">
                                            <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                                        </div>
                                    <?php endif; ?>

                                    <?php if($settings['shape2']['url'] != ''): ?>
                                        <div class="shape4">
                                            <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($settings['bg_shape']['url'] != ''): ?>
                    <div class="bg-shape1"><img src="<?php echo esc_url( $settings['bg_shape']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>"></div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="overview-area">
                <div class="container-fluid">
                    <div class="row m-0">
                        <div class="col-xl-6 col-lg-12 col-md-12 p-0">
                            <div class="overview-content">
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                                <ul class="features-list">
                                    <?php $i= 1; foreach($settings['items'] as $item): ?>
                                        <li>
                                            <?php if($item['icon']): ?>
                                                <div class="icon bg<?php echo$i; ?>">
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>
                                            <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['content'] ); ?></p>
                                        </li>
                                    <?php $i++; endforeach; ?>
                                </ul>

                                <div class="btn-box">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-xl-6 col-lg-12 col-md-12 p-0">
                                <div class="overview-image bg1" style="background-image:url(<?php echo esc_url( $settings['fimage']['url'] ); ?>);">
                                    <img src="<?php echo esc_url( $settings['fimage']['url'] ); ?>" alt="<?php echo esc_attr__('app-img', 'kiedo-toolkit'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="app-about-area pb-100">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <?php if($settings['fimage']['url']): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="app-about-image">
                                <img src="<?php echo esc_url( $settings['fimage']['url'] ); ?>" alt="<?php echo esc_attr__('app-img', 'kiedo-toolkit'); ?>">
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="app-about-content">
                                <?php if(  $settings['bg_title'] != '' ) : ?>
                                <div class="big-text"><?php echo esc_html( $settings['bg_title'] ); ?></div>
                                <?php endif; ?>

                                <?php if(  $settings['top_title'] != '' ) : ?>
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                                <ul class="list">
                                    <?php $i= 1; foreach($settings['items'] as $item): ?>
                                        <li>
                                            <?php if($item['icon']): ?>
                                                <div class="icon <?php if( $i % 2 == 0 ) : ?> bg2 <?php endif; ?>">
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>
                                            <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['content'] ); ?></p>
                                        </li>
                                    <?php $i++; endforeach; ?>
                                </ul>

                                <div class="btn-box">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                    <?php endif; ?>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <?php if($settings['shape1']['url'] != ''): ?>
                    <div class="app-about-shape-1">
                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
                <?php if($settings['shape2']['url'] != ''): ?>
                    <div class="app-about-shape-2">
                        <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
                <?php if($settings['shape3']['url'] != ''): ?>
                    <div class="app-about-shape-3">
                        <img src="<?php echo esc_url( $settings['shape3']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '4'): ?>
            <div class="app-ever-area ptb-100">
                <?php if( $settings['container_wid'] == '1' ): ?>
                <div class="container">
                <?php else: ?>
                <div class="container-fluid">
                <?php endif; ?>

                    <div class="row align-items-center">
                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="app-ever-image">
                                    <img src="<?php echo esc_url( $settings['fimage']['url'] ); ?>" alt="<?php echo esc_attr__('app-img', 'kiedo-toolkit'); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="app-ever-content">
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                                <ul class="list">
                                    <?php $i= 1; foreach($settings['items'] as $item): ?>
                                        <li>
                                            <?php if($item['icon']): ?>
                                                <div class="icon <?php if( $i % 2 == 0 ) : ?> bg2 <?php endif; ?>">
                                                    <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                                </div>
                                            <?php endif; ?>
                                            <h3><?php echo wp_kses_post( $item['title'] ); ?></h3>
                                            <p><?php echo wp_kses_post( $item['content'] ); ?></p>
                                        </li>
                                    <?php $i++; endforeach; ?>
                                </ul>
                                <div class="btn-box">
                                    <?php if($settings['button_text']): ?>
                                        <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                    <?php endif; ?>

                                    <?php if($settings['right_button_text']): ?>
                                        <a href="<?php echo esc_url($settings['right_link']); ?>" class="link-btn"><?php echo esc_html($settings['right_button_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php if($settings['shape1']['url'] != ''): ?>
                    <div class="app-ever-shape-1">
                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php endif;
	}
}
Plugin::instance()->widgets_manager->register( new Kiedo_Features_Info );