<?php
/**
 * Features Details Widget
 */

namespace Elementor;
class Kiedo_Features_Details extends Widget_Base {

	public function get_name() {
        return 'Features_Details';
    }

	public function get_title() {
        return __( 'Features Details', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Features_Details',
			[
				'label' => __( 'Kiedo Section', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Web Design and Development', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => __('Best Strategic planning dolor sit amet consectetur adipiscing elit. Scelerisque amet odio velit auctor nam elit nulla eget sodales dui pulvina', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'contact_title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Contact Info Title', 'kiedo-toolkit' ),
                    'default' => __('Lets Make Something Amazing Together!', 'kiedo-toolkit'),
                ]
            );

            $list_items = new Repeater();

            $list_items->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'kiedo-toolkit' ),
                    'default' => __('(312) 895-9800', 'kiedo-toolkit'),
                ]
            );
            $list_items->add_control(
                'title_link',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title Link', 'kiedo-toolkit' ),
                    'default' => __('tel:895-9800', 'kiedo-toolkit'),
                ]
            );
            $list_items->add_control(
                'bg_color',
                [
                    'type'    => Controls_Manager::COLOR,
                    'label'   => __( 'Card Color', 'kiedo-toolkit' ),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add Counter Item', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'image_shape1',
                [
                    'label' => __( 'Shape Image 1', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'image_shape2',
                [
                    'label' => __( 'Shape Image 2', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'image_shape3',
                [
                    'label' => __( 'Shape Image 3', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $link = get_the_permalink();
        ?>
        <div class="features-details-area ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-12">
                        <div class="features-details-information">
                            <ul class="features-list">
                            <?php
                                $args = array(
                                    'post_type'         => 'features',
                                    'posts_per_page'    => -1,
                                );
                                $features_array = new \WP_Query( $args );
                                while($features_array->have_posts()): $features_array->the_post();  ?>
                                    <li><a <?php if($link == get_the_permalink()): ?>class="active" <?php endif; ?> href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                            <?php endwhile; ?>
                            <?php wp_reset_query(); ?>
                            </ul>

                            <?php if($settings['contact_title'] != ''): ?>
                                <div class="features-contact-info">
                                    <h3><?php echo esc_html($settings['contact_title']); ?></h3>
                                    <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                                        <style>.info-box-one.color<?php echo esc_attr($i); ?> {background-color: <?php echo $item['bg_color'] ?> !important;}</style>

                                        <div class="info-box-one color<?php echo esc_attr($i); ?>">
                                            <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                            <a href="<?php echo esc_url($item['title_link']) ?>"><?php echo esc_html($item['title']) ?></a>
                                        </div>
                                    <?php $i++; endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-9 col-md-12">
                        <div class="features-details-overview-content">
                            <h3><?php echo esc_html($settings['title']); ?></h3>
                            <?php echo wp_kses_post( $settings['content'] ); ?>

                            <div class="feature-overview-image" style="background-image:url(<?php echo esc_url($settings['image']['url']); ?>);">
                                <?php if($settings['image']['url'] != ''): ?>
                                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Features_Details );