<?php
/**
 * FAQ Widget
 */

namespace Elementor;
class Kiedo_Faq extends Widget_Base {

	public function get_name() {
        return 'FAQ';
    }

	public function get_title() {
        return __( 'Kiedo FAQ', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-help-o';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Faq',
			[
				'label' => __( 'Faq Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'title',
            [
                'label' => __( 'Title', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Why Are Consultants Important?', 'kiedo-toolkit' ),
            ]
        );
        $list_items->add_control(
            'content',
            [
                'label' => __( 'Description', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'The IT industry offers a sea of options, from platforms, programming languages, methodologies, technologies, tools, and more. IT consulting services are important because they play a vital role in businesses by covering the management, implementation, deployment, and maintenance of an IT infrastructure. IT industry offers a sea of options, from platforms, programming languages, methodologies, technologies, tools, and more.', 'kiedo-toolkit' ),
            ]
        );
        $this->add_control(
            'faq_item',
            [
                'label' => esc_html__('Faq Item', 'kiedo-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list_items->get_controls(),
            ]
        );

        $this->add_control(
            'contact_title',
            [
                'type'    => Controls_Manager::TEXT,
                'label'   => __( 'Contact Info Title', 'kiedo-toolkit' ),
                'default' => __('Lets Make Something Amazing Together!', 'kiedo-toolkit'),
            ]
        );
            $card_list_items = new Repeater();

            $card_list_items->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label' => __( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $card_list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'kiedo-toolkit' ),
                    'default' => __('(312) 895-9800', 'kiedo-toolkit'),
                ]
            );
            $card_list_items->add_control(
                'title_link',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title Link', 'kiedo-toolkit' ),
                    'default' => __('tel:895-9800', 'kiedo-toolkit'),
                ]
            );
            $this->add_control(
                'card_list_items',
                [
                    'label'   => __( 'Add Counter Item', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $card_list_items->get_controls(),
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $faq_item = $settings['faq_item'];
        ?>

        <div class="faq-area ptb-100">
            <div class="container">
                <div class="faq-accordion accordion" id="faqAccordion">
                    <?php $i = 1;  foreach( $faq_item as $item ): ?>
                        <div class="accordion-item">
                            <button class="accordion-button <?php if($i != 1): ?>collapsed<?php endif; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="<?php if($i == 1): ?>true<?php else: echo 'false'; endif; ?>" aria-controls="collapse<?php echo $i; ?>"><?php echo esc_html( $item['title'] ); ?></button>

                            <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    <?php echo wp_kses_post($item['content'] ); ?>
                                </div>
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>

        <?php if($settings['contact_title'] != ''): ?>
            <div class="contact-info-area pb-100">
                <div class="container">
                    <div class="contact-info-inner">
                        <h2><?php echo esc_html($settings['contact_title']); ?></h2>
                        <div class="row justify-content-center">
                            <?php $i = 1; foreach( $settings['card_list_items'] as $item ): ?>
                                <div class="col-lg-4 col-md-6 col-sm-6">
                                    <div class="single-contact-info-box">
                                        <div class="icon bg<?php echo esc_attr($i); ?>">
                                            <i class="<?php echo esc_attr($item['icon']) ?>"></i>
                                        </div>
                                        <h3><a href="<?php echo esc_url($item['title_link']) ?>"><?php echo esc_html($item['title']) ?></a></h3>
                                    </div>
                                </div>
                            <?php $i++; endforeach; ?>
                        </div>
                        <div class="lines">
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Faq );