<?php
/**
 * Coming Soon Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Coming_Soon extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Coming_Soon';
    }

	public function get_title() {
        return __( 'Coming Soon', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-number-field';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Coming_Soon_Area',
			[
				'label' => __( 'Coming Soon Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );


            $this->add_control(
                'due_date',
                [
                    'label' => __( 'Due Date', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::DATE_TIME,
                ]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('We Are Launching Soon', 'kiedo-toolkit'),
				]
			);

            $this->add_control(
                'date', [
                    'label' => __( 'Day Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Days' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'hours', [
                    'label' => __( 'Hours Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Hours' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'minutes', [
                    'label' => __( 'Minutes Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Minutes' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'seconds', [
                    'label' => __( 'Seconds Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Seconds' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'kiedo-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/kiedo-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Placeholder Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter your email' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Subscribe' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        global $kiedo_opt;

        // Main site logo
        if( isset( $kiedo_opt['main_logo']['url'] ) ):
            $kiedo_logo 	= $kiedo_opt['main_logo']['url'];
        else:
            $kiedo_logo	= '';
        endif;

		?>

        <div class="coming-soon-area">
            <div class="container-fluid p-0">
                <div class="row m-0">
                    <div class="col-lg-6 col-md-12 p-0">
                        <div class="coming-soon-content">
                            <div class="d-table">
                                <div class="d-table-cell">
                                    <a class="logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                        <?php if( $kiedo_logo != '' ): ?>
                                            <img src="<?php echo esc_url( $kiedo_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                        <?php else: ?>
                                            <h1><?php bloginfo( 'name' ); ?></h1>
                                        <?php endif; ?>
                                    </a>

						            <h2><?php echo esc_html( $settings['title'] ); ?></h2>

                                    <div id="timer" class="flex-wrap d-flex justify-content-center">
                                        <div id="days" class="align-items-center flex-column d-flex justify-content-center"></div>
                                        <div id="hours" class="align-items-center flex-column d-flex justify-content-center"></div>
                                        <div id="minutes" class="align-items-center flex-column d-flex justify-content-center"></div>
                                        <div id="seconds" class="align-items-center flex-column d-flex justify-content-center"></div>
                                    </div>
                                    <form class="mailchimp newsletter-form" method="post">
                                        <div class="form-group subcribes">
                                            <input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
                                            <span class="label-title"><i class='bx bx-envelope'></i></span>
                                        </div>
                                        <?php if( $settings['button_text'] != '' ): ?>
                                            <button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
                                        <?php endif; ?>
                                        <p class="mchimp-errmessage alert alert-danger" style="display: none;"></p>
                                        <p class="mchimp-sucmessage alert alert-primary" style="display: none;"></p>
                                    </form>
                                    <script>
                                        ;(function($){
                                            "use strict";
                                            $(document).ready(function () {
                                                // MAILCHIMP
                                                if ($(".mailchimp").length > 0) {
                                                    $(".mailchimp").ajaxChimp({
                                                        callback: mailchimpCallback,
                                                        url: "<?php echo esc_js($settings['action_url']) ?>"
                                                    });
                                                }
                                                if ($(".mailchimp_two").length > 0) {
                                                    $(".mailchimp_two").ajaxChimp({
                                                        callback: mailchimpCallback,
                                                        url: "<?php echo esc_js($settings['action_url']) ?>"
                                                    });
                                                }
                                                $(".memail").on("focus", function () {
                                                    $(".mchimp-errmessage").fadeOut();
                                                    $(".mchimp-sucmessage").fadeOut();
                                                });
                                                $(".memail").on("keydown", function () {
                                                    $(".mchimp-errmessage").fadeOut();
                                                    $(".mchimp-sucmessage").fadeOut();
                                                });
                                                $(".memail").on("click", function () {
                                                    $(".memail").val("");
                                                });

                                                function mailchimpCallback(resp) {
                                                    if (resp.result === "success") {
                                                        $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                                                        $(".mchimp-sucmessage").fadeOut(500);
                                                    } else if (resp.result === "error") {
                                                        $(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
                                                    }
                                                }
                                            });
                                        })(jQuery)
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if( $settings['image']['url'] != '' ): ?>
                        <div class="col-lg-6 col-md-12 p-0">
                            <div class="coming-soon-image" style="background-image:url(<?php echo esc_url( $settings['image']['url'] ); ?>);">
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" data-aos="fade-up" alt="<?php echo esc_attr__( 'CM image', 'kiedo-toolkit' ); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <script>
            (function($){
            "use strict";
                $( window ).on( 'elementor/frontend/init', function() {
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Kiedo_Coming_Soon.default', function($scope, $){
                        // Count Time
                        function makeTimer() {
                            var endTime = new Date("<?php echo $settings['due_date']; ?>");
                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400);
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimer(); }, 1000);
                        });

                });

                if( typeof elementorFrontend !== 'undefined'  ){
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Kiedo_Coming_Soon.default', function($scope, $){
                        // Count Time
                        function makeTimerLive() {
                            var endTime = new Date("<?php echo $settings['due_date']; ?>");
                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400);
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }

                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimerLive(); }, 1000);
                    });
                }

            }(jQuery));
        </script>

        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Coming_Soon );