<?php
/**
 * Career Post Area Widget
 */

namespace Elementor;
class Kiedo_Career_Area extends Widget_Base {

	public function get_name() {
        return 'Kiedo_CareerArea';
    }

	public function get_title() {
        return __( 'Career Post', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-posts-justified';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'features_section',
			[
				'label' => __( 'Career Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Career Order By', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'kiedo-toolkit' ),
                        'ASC'       => __( 'ASC', 'kiedo-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => __( 'Post Per Page', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Career Query
        $args = array(
            'post_type'         => 'career',
            'posts_per_page'    => $settings['count'],
            'order'             => $settings['order']
        );
        $career_array = new \WP_Query( $args );
        ?>

        <div class="container">
            <div class="row justify-content-center">
                <?php
                $i = 1;
                while ($career_array->have_posts()): $career_array->the_post();
                    $idd = get_the_ID();

                    if ( class_exists('ACF') ) {
                        $job_location    = get_field('job_location_label');
                        $career_job_type = get_field('career_job_type');
                    } else {
                        $job_location    = '';
                        $career_job_type = '';
                    }
                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="career-box">
                            <div class="content">
                                <a href="<?php echo esc_url(get_the_permalink()); ?>" class="location"> <i class="fa fa-map-marker"></i> <?php echo esc_html( $job_location  ); ?></a>
                                <a href="<?php echo esc_url(get_the_permalink()); ?>" class="job-type bg<?php if( $i % 2 != 0 ): ?>-1 <?php endif; ?>"> <?php echo esc_html( $career_job_type  ); ?></a>
                            </div>

                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                        </div>
                    </div>
                <?php $i++; endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>
  
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Career_Area );