<?php
/**
 * Banner Nine Widget
 */

namespace Elementor;
class Kiedo_Banner_nine extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Bannernine';
    }

	public function get_title() {
        return __( 'Banner Nine', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('#Get your 14 days free trail', 'kiedo-toolkit'),
				]
			);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('The Revolutionary App That Makes Your Life Easier Than Others Apps', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
				'desc',
				[
					'label' => __( 'Description', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Id tincidunt eifend odio viverra diam aliquet donec again.', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
				'button_text',
				[
					'label' => __( 'Button Text', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Start Free Trial', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
			$this->add_control(
				'bg_image',
				[
					'label' => __( 'Background Image', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'image',
				[
					'label' => __( 'Section Image', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'top_title_color',
				[
					'label' => __( 'Top Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-gradient-content .sub-title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'top_title_bgcolor',
				[
					'label' => __( 'Top Title Background Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-gradient-content .sub-title' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-gradient-content .sub-title',
                ]
            );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-gradient-content h1, .new-app-main-banner-gradient-content h2, .new-app-main-banner-gradient-content h3, .new-app-main-banner-gradient-content h4, .new-app-main-banner-gradient-content h5, .new-app-main-banner-gradient-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-gradient-content h1, .new-app-main-banner-gradient-content h2, .new-app-main-banner-gradient-content h3, .new-app-main-banner-gradient-content h4, .new-app-main-banner-gradient-content h5, .new-app-main-banner-gradient-content h6',
                ]
            );

			$this->add_control(
				'content_color',
				[
					'label' => __( 'Content Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-gradient-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-gradient-content p',
                ]
            );

			$this->add_control(
				'btn_color',
				[
					'label' => __( 'Button Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bgcolor',
				[
					'label' => __( 'Button Background Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  .default-btn::before' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_hover_bg_color',
				[
					'label' => __( 'Button Hover Background Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		// Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>
		<div class="new-app-main-banner-gradient-area"  style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="new-app-main-banner-gradient-content">
							<?php if($settings['top_title']): ?>
								<span class="sub-title"><?php echo esc_html($settings['top_title']); ?></span>
							<?php endif; ?>
							<<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
								<?php echo esc_html( $settings['title'] ); ?>
							</<?php echo esc_attr( $settings['title_tag'] ); ?>>

							<p><?php echo wp_kses_post( $settings['desc'] ); ?></p>

							<?php if( $settings['button_text'] ): ?>
							<div class="banner-btn">
								<a href="<?php echo esc_url( $link ); ?>" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
							</div>
							<?php endif; ?>
                        </div>
                    </div> 

					<?php if($settings['image']['url']): ?>
						<div class="col-lg-6 col-md-12">
							<div class="new-app-main-banner-gradient-image" data-aos="fade-left" data-aos-duration="2000">
								<img src="<?php echo esc_url( $settings['image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
							</div>
						</div>
					<?php endif; ?>
                </div>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Banner_nine );