<?php
/**
 * App Progress Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_App_Progress extends Widget_Base {

	public function get_name() {
        return 'App_Progress';
    }

	public function get_title() {
        return esc_html__( 'App Progress', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-form-vertical';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_App_Progress',
			[
				'label' => esc_html__( 'Kiedo App Progress', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'kiedo-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'bg_title',
                [
                    'label' => esc_html__( 'Background Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Progress', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('APP PROGRESS', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Set Up The Challenges and Track Your Progress', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. never missyour chance its just began. backup just log in with your mail account from.', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'kiedo-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Start Free Trial', 'kiedo-toolkit'),
				]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'fimage',
                [
                    'label' => esc_html__( 'App Progress Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'bg_image',
                [
                    'label' => esc_html__( 'Background Image', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => '4',
                    ]
                ]
            );
            $this->add_control(
                'shape',
                [
                    'label' => esc_html__( 'Shape', 'kiedo-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'secbg_color',
                [
                    'label'     => esc_html__( 'Section Background Color', 'kiedo-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-progress-area.bg-black' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'toptitle_color',
                [
                    'label'     => esc_html__( 'Top Title Color', 'kiedo-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .new-app-progress-content .sub-title, .new-app-progress-wrap-area .new-app-progress-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'toptitle_typography',
                    'label'    => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-progress-content .sub-title, .new-app-progress-wrap-area .new-app-progress-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-progress-content h2, .app-progress-content h3, .app-progress-content h4, .app-progress-content h5, .app-progress-content h5, .app-progress-content h6, .app-progress-content h1, .app-progress-content.text-white h2, .app-progress-content.text-white h3, .app-progress-content.text-white h4, .app-progress-content.text-white h5, .app-progress-content.text-white h5, .app-progress-content.text-white h6, .app-progress-content.text-white h1, .new-app-progress-content h2, .new-app-progress-content h1, .new-app-progress-content h3, .new-app-progress-content h4, .new-app-progress-content h5, .new-app-progress-content h6, .new-app-progress-wrap-area .new-app-progress-content h2, .new-app-progress-wrap-area .new-app-progress-content h1, .new-app-progress-wrap-area .new-app-progress-content h3, .new-app-progress-wrap-area .new-app-progress-content h4, .new-app-progress-wrap-area .new-app-progress-content h5, .new-app-progress-wrap-area .new-app-progress-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .app-progress-content h2, .app-progress-content h3, .app-progress-content h4, .app-progress-content h5, .app-progress-content h5, .app-progress-content h6, .app-progress-content h1, .app-progress-content.text-white h2, .app-progress-content.text-white h3, .app-progress-content.text-white h4, .app-progress-content.text-white h5, .app-progress-content.text-white h5, .app-progress-content.text-white h6, .app-progress-content.text-white h1, .new-app-progress-content h2, .new-app-progress-content h1, .new-app-progress-content h3, .new-app-progress-content h4, .new-app-progress-content h5, .new-app-progress-content h6, .new-app-progress-wrap-area .new-app-progress-content h2, .new-app-progress-wrap-area .new-app-progress-content h1, .new-app-progress-wrap-area .new-app-progress-content h3, .new-app-progress-wrap-area .new-app-progress-content h4, .new-app-progress-wrap-area .new-app-progress-content h5, .new-app-progress-wrap-area .new-app-progress-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .app-progress-content p, .app-progress-content.text-white p, .new-app-progress-content p, .new-app-progress-wrap-area .new-app-progress-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .app-progress-content p, .app-progress-content.text-white p, .new-app-progress-content p, .new-app-progress-wrap-area .new-app-progress-content p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');
        ?>

        <?php if($settings['style'] == '1'): ?>
            <div class="app-progress-area ">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="app-progress-image text-center">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="app-progress-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="app-progress-area bg-black ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="app-progress-image text-center">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="app-progress-animation-image">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/app-progress/app-progress1.png" alt="<?php echo esc_attr($settings['title']); ?>" data-aos="fade-down" data-aos-duration="1000">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/app-progress/app-progress2.png" alt="<?php echo esc_attr($settings['title']); ?>" data-aos="fade-right" data-aos-duration="1000">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/app-progress/app-progress3.png" alt="<?php echo esc_attr($settings['title']); ?>" data-aos="fade-left" data-aos-duration="1000">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/app-progress/app-progress4.png" alt="<?php echo esc_attr($settings['title']); ?>" data-aos="fade-up" data-aos-duration="1000">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/app-progress/progress-main.png" class="main-image" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="app-progress-content text-white">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3'): ?>
            <div class="new-app-progress-area">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="new-app-progress-content">
                                <?php if(  $settings['bg_title'] != '') : ?>
                                <div class="big-text"><?php echo esc_html( $settings['bg_title'] ); ?></div>
                                <?php endif; ?>
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="new-app-progress-image text-center">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if($settings['shape']['url']): ?>
                    <div class="new-app-progress-shape">
                        <img src="<?php echo esc_url($settings['shape']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '4'): ?>
            <div class="new-app-progress-wrap-area ptb-100" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="new-app-progress-image text-center">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="new-app-progress-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php if($settings['button_text']): ?>
                                    <a href="<?php echo esc_url($settings['ex_link']); ?>" class="default-btn"><?php echo esc_html($settings['button_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_App_Progress );