<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = KIEDO_FRAMEWORK_VAR;

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    // Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {
        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();
            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {
                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    // All the possible arguments for Redux.
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'kiedo-toolkit' ),
        'page_title'           => __( 'Theme Options', 'kiedo-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 90,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'opt_nameion',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'kiedo-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'kiedo-toolkit' );
    }
    Redux::setArgs( $opt_name, $args );

// General Options
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'General Options', 'kiedo-toolkit' ),
    'id'                => 'general_options',
    'customizer'        => false,
    'icon'              => ' el el-home',
    'fields'     => array(
        array(
            'id'       => 'main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Site Logo', 'kiedo-toolkit' ),
            'desc'     => esc_html__( 'Recommended sizes - width: 140px, height: 45px', 'kiedo-toolkit' ),
        ),
        array(
            'title'     => __( 'Site Logo Dimensions', 'kiedo-toolkit' ),
            'id'        => 'main_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.navbar-brand .black-logo, .navbar-brand img'
        ),
        array(
            'id'       => 'mobile_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Logo For Mobile (optional)', 'kiedo-toolkit' ),
            'desc'     => esc_html__( 'Recommended sizes - width: 120px, height: 35px', 'kiedo-toolkit' ),
        ),

        array(
            'title'     => __( 'Mobile Logo Dimensions', 'kiedo-toolkit' ),
            'id'        => 'mobile_logo_dimensions',
            'type'      => 'dimensions',
            'units'     => array( 'em','px','%' ),
            'output'    => '.logo img'
        ),

        array(
            'id'        => 'enable_sticky_header',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Sticky Header', 'kiedo-toolkit'),
            'desc'      => esc_html__('', 'kiedo-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => esc_html__('Enable back-to-top Button', 'kiedo-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'      => 'kiedo_enable_rtl',
            'type'    => 'select',
            'options' => array(
                'enable'        => 'Enable',
                'disable'       => 'Disable',
            ),
            'title'     => esc_html__( 'RTL', 'kiedo-toolkit' ),
            'default'   => 'disable',
        ),
    ),
) );

// Preloader Options
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Preloader', 'kiedo-toolkit' ),
    'id'               => 'preloader_opt',
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(

        array(
            'id'      => 'enable_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'Pre-loader', 'kiedo-toolkit' ),
            'on'      => esc_html__( 'Enable', 'kiedo-toolkit' ),
            'off'     => esc_html__( 'Disable', 'kiedo-toolkit' ),
            'default' => true,
        ),

        array(
            'required' => array( 'enable_preloader', '=', '1' ),
            'id'       => 'preloader_style',
            'type'     => 'select',
            'title'    => esc_html__( 'Pre-loader Style', 'kiedo-toolkit' ),
            'default'   => 'circle-spin',
            'options'  => array(
                'circle-spin'   => esc_html__( 'Spin Preloader', 'kiedo-toolkit' ),
                'text'          => esc_html__( 'Text Preloader', 'kiedo-toolkit' ),
                'image'         => esc_html__( 'Image Preloader', 'kiedo-toolkit' )
            )
        ),

        /**
         * Text Preloader
         */
        array(
            'title'     => esc_html__( 'Background Color', 'kiedo-toolkit' ),
            'id'        => 'preloader_color_spin',
            'type'      => 'background',
            'background-image'      => false,
            'background-repeat'     => false,
            'background-size'       => false,
            'background-attachment' => false,
            'background-position'   => false,
            'transparent'           => false,
            'output'    => array( '.preloader-area' ),
        ),
        array(
            'title'     => esc_html__( 'Color', 'kiedo-toolkit' ),
            'id'        => 'preloader_color',
            'type'      => 'color',
            'output'    => array( '.preloader-area p' ),
            'required'  => array( 'preloader_style', '=', 'text' ),
        ),
        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Text', 'kiedo-toolkit' ),
            'default'  => esc_html__( 'Loading', 'kiedo-toolkit' ),
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        array(
            'title'         => esc_html__( 'Loading Text Typography', 'kiedo-toolkit' ),
            'id'            => 'preloader_small_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'output'        => '.preloader-area p',
            'required' => array( 'preloader_style', '=', 'text' ),
        ),

        /**
         * Image Preloader
         */
        array(
            'required' => array( 'preloader_style', '=', 'image' ),
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Pre-loader image', 'kiedo-toolkit' ),
            'compiler' => true,
        ),
    )
));

// Header Option
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Header', 'kiedo-toolkit'),
	'icon'  => 'el el-caret-up',
	'customizer' => false,
	'fields' => array(
        array(
			'id'    => 'header_btn',
            'type'  => 'text',
			'title' => esc_html__('Header Button Text', 'kiedo-toolkit'),
        ),
        array(
			'id'    => 'header_btn_link',
            'type'  => 'text',
			'title' => esc_html__('Header Button Link', 'kiedo-toolkit'),
        ),
        array(
            'id'        => 'enable_cart_icon',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Cart Icon', 'kiedo-toolkit'),
            'default'   => '1'
        ),
	)
) );

// Banner
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Banner', 'kiedo-toolkit' ),
    'id'                => 'banner_options',
    'customizer'        => false,
    'icon'              => 'el el-website',
    'fields'     => array(
        array(
            'id'        => 'page_title_tag',
            'type'      => 'select',
            'title'     => esc_html__( 'Banner Title Tag', 'kiedo-toolkit' ),
            'options' => array(
                'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
            ),
            'default' => 'h2',
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_title_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Title Typography', 'kiedo-toolkit' ),
            'output'    => '.page-title-content h1, .page-title-content h2, .page-title-content h3, .page-title-content h4, .page-title-content h5, .page-title-content h6'
        ),
        array(
            'id'        => 'titlebar_desc_typo',
            'type'      => 'typography',
            'text-align'    => false,
            'title'     => esc_html__( 'Breadcumb Typography', 'kiedo-toolkit' ),
            'output'    => '.page-title-content ul li a, .page-title-content ul li'
        ),
        array(
            'title'     => esc_html__( 'Banner Padding', 'kiedo-toolkit' ),
            'subtitle'  => esc_html__( 'Padding around the Banner', 'kiedo-toolkit' ),
            'id'        => 'banner_padding',
            'type'      => 'spacing',
            'output'    => array( '.page-title-area' ),
            'mode'      => 'padding',
            'units'     => array( 'em', 'px', '%' ),
            'units_extended' => 'true',
        ),
        array(
            'id'       => 'banner_img1',
            'type'     => 'media',
            'title'    => esc_html__( 'Banner Shape Image', 'kiedo-toolkit' ),
            'compiler' => true,
        ),
    ),
) );

// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Social Profiles', 'kiedo-toolkit'),
	'desc'  => 'Social profiles are used in different places inside the theme',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'kiedo_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
                '_parent'   => 'Load in the parent frameset. ( _parent )',
                '_top'      => 'Load in the full body of the window ( _top )',
            ),
            'title'     => esc_html__( 'Social Link Target', 'kiedo-toolkit' ),
            'default'   => '_blank',
        ),

        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
			'title' => esc_html__('Twitter URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('Facebook URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
			'title' => esc_html__('Instagram URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('Linkedin URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' =>esc_html__('Pinterest URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' =>esc_html__('Dribbble URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' =>esc_html__('Tumblr URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' =>  esc_html__('Youtube URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' =>  esc_html__('Flickr URL', 'kiedo-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' =>  esc_html__('Behance URL', 'kiedo-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' =>  esc_html__('Github URL', 'kiedo-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' =>  esc_html__('Skype URL', 'kiedo-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' =>  esc_html__('RSS URL', 'kiedo-toolkit')
		),
	)
) );

// Footer Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( 'Footer', 'kiedo-toolkit' ),
    'id'                => 'footer',
    'customizer'        => false,
    'icon'              => 'el el-edit',
    'fields' => array(
        array(
            'id'        => 'copyright_text',
            'type'      => 'editor',
            'title'     => esc_html__('Footer Copyright Text (optional)', 'kiedo-toolkit'),
            'subtitle'  => esc_html__('HTML and Shortcodes are allowed', 'kiedo-toolkit'),
            'desc'      => '',
            'args' => array(
                'teeny'         => true,
                'media_buttons' => false
            ),
        ),
        array(
            'id'            => 'footer_bg',
            'type'          => 'color',
            'title'         => esc_html__('Footer Background Color', 'kiedo-toolkit'),
            'default'       => '#F4F8FC',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'title'     => esc_html__( 'Footer Column', 'kiedo-toolkit' ),
            'id'        => 'footer_column',
            'type'      => 'select',
            'default'   => '4',
            'options'   => array(
                '-lg-12'    => esc_html__( 'One Column', 'kiedo-toolkit' ),
                '-lg-6'     => esc_html__( 'Two Column', 'kiedo-toolkit' ),
                '-lg-4'     => esc_html__( 'Three Column', 'kiedo-toolkit' ),
                '-lg-3'     => esc_html__( 'Four Column', 'kiedo-toolkit' ),
                '  auto'    => esc_html__( 'Auto Column', 'kiedo-toolkit' ),
                'footer-default-column'    => esc_html__( 'Theme Default(use four widget in footer sidebar)', 'kiedo-toolkit' ),
            ),
        ),

        array(
            'id'       => 'footer_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer Shape(for style 2)', 'kiedo-toolkit' ),
        ),
    )
));

// Styling
Redux::setSection( $opt_name, array(
    'title'        => esc_html__( 'Styling Options', 'kiedo-toolkit' ),
    'id'           => 'styling_options',
    'customizer'   => false,
    'icon'         => ' el el-magic',
    'fields'     => array(
        array(
            'id'            => 'primary_color',
            'type'          => 'color',
            'title'         => esc_html__('Primary Color', 'kiedo-toolkit'),
            'default'       => '#0064FB',
            'validate'      => 'color',
            'transparent'   => false,
        ),

        array(
            'id'            => 'secondary_color',
            'type'          => 'color',
            'title'         => esc_html__('Secondary Color', 'kiedo-toolkit'),
            'default'       => '#FF414B',
            'validate'      => 'color',
            'transparent'   => false,
        ),

        array(
            'id'       => 'theme_gradient_color',
            'type'     => 'color_gradient',
            'title'    => __('Theme Gradient Color Option', 'kiedo-toolkit'),
            'validate' => 'color',
            'default'  => array(
                'from' => '#ED2775',
                'to'   => '#FF7448',
            ),
        ),

        array(
            'id'            => 'nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Item Color', 'kiedo-toolkit'),
            'default'       => '#494A60',
            'validate'      => 'color',
            'transparent'   => false
        ),

        array(
            'id'            => 'mob_nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('Mobile Navbar Item Color', 'kiedo-toolkit'),
            'default'       => '#494A60',
            'validate'      => 'color',
            'transparent'   => false
        ),

    ),
) );

// Blog Area
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Blog Settings', 'kiedo-toolkit' ),
    'id'            => 'kiedo_blog',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => 'Manage your blog settings',
    'fields' => array(
        array(
            'id' => 'kiedo_blog_style',
            'type' => 'select',
            'options' => array(
                '1'        => 'Style One',
                '2'       => 'Style Two',
            ),
            'title'     => esc_html__( 'Blog Style', 'kiedo-toolkit' ),
            'default'   => '1',
        ),
        array(
			'id'    => 'kiedo_search_page',
            'type'  => 'switch',
            'title' => esc_html__('Enable Pages on Search Result Page', 'kiedo-toolkit'),
        ),
        array(
			'id'    => 'hide_blog_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Blog Banner', 'kiedo-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Blog Breadcrumb', 'kiedo-toolkit'),
            'default'   => '0',
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'blog_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Page Title', 'kiedo-toolkit' ),
            'required'      => array('hide_blog_banner','equals','0'),
        ),
        array(
            'id' => 'kiedo_blog_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'kiedo-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'kiedo-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Width', 'kiedo-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'kiedo_blog_single_layout',
            'type' => 'select',
            'options' => array(
                'container'                 => esc_html__( 'Container', 'kiedo-toolkit' ),
                'container-fluid'           => esc_html__( 'Container Fluid', 'kiedo-toolkit' ),
            ),
            'title'     => esc_html__( 'Single Blog Width', 'kiedo-toolkit' ),
            'default'   => 'container',
        ),
        array(
            'id' => 'kiedo_blog_grid',
            'type' => 'select',
            'options' => array(
                'col-lg-12 col-md-12'       => esc_html__( 'One Column', 'kiedo-toolkit' ),
                'col-lg-6 col-md-6'         => esc_html__( 'Two Column', 'kiedo-toolkit' ),
                'col-lg-4 col-md-6'         => esc_html__( 'Three Column', 'kiedo-toolkit' ),
                'col-lg-3 col-md-6'         => esc_html__( 'Four Column', 'kiedo-toolkit' ),
            ),
            'title'     => esc_html__( 'Blog Grid System', 'kiedo-toolkit' ),
            'default'   => 'col-lg-12 col-md-12',
        ),
        array(
            'id' => 'kiedo_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'kiedo_with_sidebar'              => 'With Sidebar',
                'kiedo_without_sidebar'           => 'Without Sidebar ( full width )',
                'kiedo_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => esc_html__( 'Blog Sidebar', 'kiedo-toolkit' ),
            'default'   => 'kiedo_with_sidebar',
        ),
        array(
            'id' => 'kiedo_single_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'kiedo_with_sidebar'              => 'With Sidebar',
                'kiedo_without_sidebar'           => 'Without Sidebar ( full width )',
                'kiedo_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => esc_html__( 'Single Blog Sidebar', 'kiedo-toolkit' ),
            'default'   => 'kiedo_with_sidebar',
        ),
        array(
            'title'     => esc_html__( 'Read More', 'kiedo-toolkit' ),
            'subtitle'  => esc_html__( 'Change the Read More link text', 'kiedo-toolkit' ),
            'id'        => 'read_more',
            'type'      => 'text',
            'default'   => esc_html__( 'Read More', 'kiedo-toolkit' )
        ),
        array(
			'title'     => esc_html__( 'Post Meta', 'kiedo-toolkit' ),
			'subtitle'  => esc_html__( 'Show/hide post meta', 'kiedo-toolkit' ),
			'id'        => 'is_post_meta',
			'type'      => 'switch',
            'on'        => esc_html__( 'Show', 'kiedo-toolkit' ),
            'off'       => esc_html__( 'Hide', 'kiedo-toolkit' ),
            'default'   => '1',
        ),
    )
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'WooCommerce', 'kiedo-toolkit' ),
    'desc'  => esc_html__( 'Manage product page settings.', 'kiedo-toolkit' ),
    'icon'  => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        array(
            'title'     => esc_html__( 'Page title', 'kiedo-toolkit' ),
            'subtitle'  => esc_html__( 'Give here the shop page title', 'kiedo-toolkit' ),
            'desc'      => esc_html__( 'This text will show on the shop page banner', 'kiedo-toolkit' ),
            'id'        => 'shop_title',
            'type'      => 'text',
            'default'   => esc_html__( 'Shop', 'kiedo-toolkit' ),
        ),

        array(
            'id'    => 'enable_auto_complete',
            'type'  => 'select',
            'options' => array(
                'yes'       => 'Yes',
                'no'        => 'No',
            ),
            'title' => esc_html__('Enable Woocommerce Automatically Complete Orders', 'kiedo-toolkit'),
            'default'   => 'yes',
        ),
        array(
            'id'    => 'product_columns',
            'type'  => 'select',
            'options' => array(
                ''         => 'Default',
                '2'        => '2',
                '3'        => '3',
                '4'        => '4',
            ),
            'title' => esc_html__('Select Product Columns', 'kiedo-toolkit'),
            'default'   => '',
        ),
        array(
            'id'        => 'products_page_count',
            'desc'      => esc_html__( 'Number of products per page on product pages.', 'kiedo-toolkit' ),
            'type'      => 'text',
            'title'     => esc_html__( 'Products per page', 'kiedo-toolkit' ),
            'default'   => '6',
        ),
        array(
            'id'    => 'kiedo_product_sidebar',
            'type'  => 'select',
            'options' => array(
                'kiedo_product_no_sidebar'       => 'None',
                'kiedo_product_left_sidebar'     => 'Sidebar on the left',
                'kiedo_product_right_sidebar'    => 'Sidebar on the right',
            ),
            'title'     => esc_html__( 'Product Sidebar Position', 'kiedo-toolkit' ),
            'default'   => 'kiedo_product_no_sidebar',
        ),
        array(
            'id'    => 'kiedo_related_product_count',
            'type'  => 'text',
            'title' => esc_html__( 'Product Details Related Product Count', 'kiedo-toolkit' ),
            'desc'  => esc_html__( 'e.g. 3', 'kiedo-toolkit' ),
            'default' => '3',
        ),
        array(
            'id'        => 'enable_product_share',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Product Social share', 'kiedo-toolkit'),
            'default'   => '0'
        ),

        array(
            'id'        => 'enable_social_share_title',
            'type'      => 'text',
            'title'     => esc_html__('Share Title', 'kiedo-toolkit'),
            'default'   => 'Share:',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_fb',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Facebook', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),

        array(
            'id'        => 'enable_product_tw',
            'type'      => 'switch',
            'title'     => esc_html__('Share on Twitter', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_ld',
            'type'      => 'switch',
            'title'     => esc_html__('Share on LinkedIn', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_wp',
            'type'      => 'switch',
            'title'     => esc_html__('Share on WhatsApp', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_email',
            'type'      => 'switch',
            'title'     => esc_html__('Share by Email', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
        array(
            'id'        => 'enable_product_cp',
            'type'      => 'switch',
            'title'     => esc_html__('Copy link', 'kiedo-toolkit'),
            'default'   => '0',
            'required'  => array('enable_product_share','equals','1'),
        ),
    ),
));

// Typography
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'Typography', 'kiedo-toolkit' ),
    'desc' => esc_html__( 'Manage your fonts and typefaces', 'kiedo-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'opt-typography-body',
            'type'          => 'typography',
            'title'         => esc_html__( 'Body font', 'kiedo-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body, .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6, p',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-family' => 'Overpass',
                'google' => true,
            ),
        ),
    ),
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => esc_html__('Advanced Settings', 'kiedo-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'css_code',
			'type' => 'ace_editor',
			'title' => esc_html__('Custom CSS Code', 'kiedo-toolkit'),
			'desc' => esc_html__('e.g. .btn-primary{ background: #000; } Don\'t use &lt;style&gt; tags', 'kiedo-toolkit'),
			'subtitle' => esc_html__('Paste your CSS code here', 'kiedo-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'js_code',
			'type'      => 'ace_editor',
			'title'     => esc_html__('Custom JS Code', 'kiedo-toolkit'),
			'desc'      => esc_html__('e.g. alert("Hello World!"); Don\'t use&lt;script&gt;tags', 'kiedo-toolkit'),
			'subtitle'  => esc_html__('Paste your JS code here', 'kiedo-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );


// Custom Post
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Custom Posts Settings', 'gloci-toolkit' ),
    'id'            => 'gloci_custom_posts',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => 'Manage your settings',
    'fields' => array(

        array(
			'id'    => 'hide_features_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Features Banner', 'gloci-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_features_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Features Breadcrumb', 'gloci-toolkit'),
            'default'   => '0',
            'required'    => array('hide_features_banner','equals','0'),
        ),
        array(
            'id'       => 'features_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Features Permalink', 'gloci-toolkit' ),
            'default'  => esc_html__('feature-post', 'gloci-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),

        // Career
        array(
			'id'    => 'hide_career_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Single Career Banner', 'gloci-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_career_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide Single Career Breadcrumb', 'gloci-toolkit'),
            'default'   => '0',
            'required'    => array('hide_career_banner','equals','0'),
        ),
        array(
            'id'       => 'career_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Career Permalink', 'gloci-toolkit' ),
            'default'  => esc_html__('career-post', 'gloci-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
    )
));

// 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404 Settings', 'kiedo-toolkit' ),
    'id'                => 'kiedo_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
            'id'    => 'banner_title_not_found',
            'type'  => 'text',
            'title' => esc_html__('Banner 404 Title', 'kiedo-toolkit'),
        ),
        array(
            'id'       => 'not_found_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( '404 Image', 'kiedo-toolkit' ),
        ),
        array(
            'id'    => 'title_not_found',
            'type'  => 'text',
            'title' => esc_html__('404 Title', 'kiedo-toolkit'),
        ),
        array(
            'id'       => 'content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content', 'kiedo-toolkit' ),
        ),
        array(
            'id'       => 'button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'Back to Home Button Text', 'kiedo-toolkit' ),
        ),
    )
));

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    // Custom function for the callback validation referenced above
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    // Custom function for the callback referenced above
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'kiedo-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'kiedo-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    // Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    // Filter hook for filtering the default value of any given field. Very useful in development mode.
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    // Removes the demo link and the notice of integrated demo from the redux-framework plugin
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

// Add this on bottom of the file
if( !function_exists('kiedo_toolkit_js_code') ){
    trigger_error("Hey! Are you trying to heck this theme! Please register Kiedo theme!", E_USER_ERROR);
}