<?php
/**
 * Include the TGM_Plugin_Activation class.
 */

require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'kiedo_register_required_plugins' );

if ( ! function_exists( 'kiedo_register_required_plugins' ) ) {
	function kiedo_register_required_plugins() {

		$plugins = array(

			array(
				'name'               => esc_html__('Kiedo Toolkit', 'kiedo'),
				'slug'               => 'kiedo-toolkit',
				'source'             => get_template_directory() . '/lib/plugins/kiedo-toolkit.zip',
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Page Builder', 'kiedo'),
				'slug'               => 'elementor',
				'required'           => true,
			),

			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'kiedo'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             => 'https://themes.hibootstrap.com/tools/advanced-custom-fields-pro.zip',
				'required'           => true,
			),

			array(
				'name'      => esc_html__('WooCommerce', 'kiedo'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('BuddyPress', 'kiedo'),
				'slug'      => 'buddypress',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Contact Form 7', 'kiedo'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
               'name'       => esc_html__( 'HiBo Demo Importer', 'kiedo' ),
               'slug'       => 'hibo-demo-importer',
               'source'     => 'https://themes.hibootstrap.com/tools/hibo-demo-importer.zip',
               'required'   => false,
           	),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		);
		tgmpa( $plugins, $config );
	}
}