<?php
/**
 * Register Theme Widget
 * @package Kiedo
 */


// Register sidebar
if ( ! function_exists( 'kiedo_widgets_init' ) ) {
    function kiedo_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'kiedo' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'kiedo' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

         // Footer Sidebar
         global $kiedo_opt;
         $footer_column = !empty($kiedo_opt['footer_column']) ? $kiedo_opt['footer_column'] : '-4';
         register_sidebar( array(
             'name'          => esc_html__( 'Footer Widgets', 'kiedo' ),
             'id'            => 'footer_widgets',
             'description'   => esc_html__( 'Add widgets here.', 'kiedo' ),
             'before_widget' => '<div class="single-footer-widget col'.$footer_column.' %2$s">',
             'after_widget'  => '</div>',
             'before_title'  => '<h3>',
             'after_title'   => '</h3>',
         ) );

         // Shop Sidebar
		if ( class_exists( 'WooCommerce' ) ):
            register_sidebar( array(
                'name'          => esc_html__( 'Shop Sidebar', 'kiedo' ),
                'id'            => 'shop',
                'description'   => esc_html__( 'Add widgets here.', 'kiedo' ),
                'before_widget' => '<div class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3>',
                'after_title'   => '</h3>',
            ) );
        endif;

        // BuddyPress Sidebar
        if ( class_exists( 'BuddyPress' ) ) {
            register_sidebar( array(
                'name' => esc_html__( 'Activity Directory Top Sidebar', 'kiedo' ),
                'id' => 'activity_top_sidebar',
                'class' => '',
                'description' => esc_html__( 'Widgets in this area will shown on News feed page.', 'kiedo' ),
                'before_widget' => '<div id="%1$s" class="widget blog_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h5 class="widget-title"><span>',
                'after_title' => '</span></h5>',
            ) );
            register_sidebar( array(
                'name' => esc_html__( 'Activity Directory Sidebar', 'kiedo' ),
                'id' => 'activity_sidebar',
                'class' => '',
                'description' => esc_html__( 'Widgets in this area will shown on News feed page.', 'kiedo' ),
                'before_widget' => '<div id="%1$s" class="widget blog_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h5 class="widget-title"><span>',
                'after_title' => '</span></h5>',
            ) );
            register_sidebar( array(
                'name' => esc_html__( 'Groups Directory Sidebar', 'kiedo' ),
                'id' => 'groups_sidebar',
                'class' => '',
                'description' => esc_html__( 'Widgets in this area will shown on Groups page.', 'kiedo' ),
                'before_widget' => '<div id="%1$s" class="widget blog_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h5 class="widget-title"><span>',
                'after_title' => '</span></h5>',
            ) );
            register_sidebar( array(
                'name' => esc_html__( 'Members Single Profile Sidebar', 'kiedo' ),
                'id' => 'member_single_sidebar',
                'class' => '',
                'description' => esc_html__( 'Widgets in this area will shown on individual member profiles.', 'kiedo' ),
                'before_widget' => '<div id="%1$s" class="widget blog_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h5 class="widget-title"><span>',
                'after_title' => '</span></h5>',
            ) );
        }
    }
}
add_action( 'widgets_init', 'kiedo_widgets_init' );