<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 * @package Kiedo
 */

/**
 * Adds custom classes to the array of body classes.
 */
if ( ! function_exists( 'kiedo_body_classes' ) ) {
	function kiedo_body_classes( $classes ) {
		// Adds a class of hfeed to non-singular pages.
		if ( ! is_singular() ) {
			$classes[] = 'hfeed';
		}

		// Adds a class of no-sidebar when there is no sidebar present.
		if ( ! is_active_sidebar( 'sidebar-1' ) ) {
			$classes[] = 'no-sidebar';
		}

		return $classes;
	}
}
add_filter( 'body_class', 'kiedo_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
if ( ! function_exists( 'kiedo_pingback_header' ) ) {
	function kiedo_pingback_header() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}
}
add_action( 'wp_head', 'kiedo_pingback_header' );

/**
 * Kiedo Preloader
*/

if ( ! function_exists( 'kiedo_preloader' ) ) :
	function kiedo_preloader() {
		global $kiedo_opt;

		if( isset( $kiedo_opt['enable_preloader'] ) ):
			$is_preloader = $kiedo_opt['enable_preloader'];
		else:
			$is_preloader = true;
		endif;

		$is_preloader       = !empty($kiedo_opt['enable_preloader']) ? $kiedo_opt['enable_preloader'] : '';

        $preloader_style    = !empty($kiedo_opt['preloader_style']) ? $kiedo_opt['preloader_style'] : 'circle-spin';

        if( $is_preloader == true ):
            if ( defined( 'ELEMENTOR_VERSION' ) ) :
                if (\Elementor\Plugin::$instance->preview->is_preview_mode()) :
                    echo '';
                else:
                    if ( $preloader_style == 'text' ) :
                        if (!empty( $kiedo_opt['loading_text'] ) ) : ?>
                            <div class="preloader-area ">
                                <div class="loader">
                                    <p class="text-center"> <?php echo esc_html( $kiedo_opt['loading_text'] ) ?> </p>
                                </div>
                            </div>
                        <?php endif;
                    elseif( $preloader_style == 'circle-spin' ) : ?>
                        <div class="preloader-area">
							<div class="spinner">
								<div class="inner">
									<div class="disc"></div>
									<div class="disc"></div>
									<div class="disc"></div>
								</div>
							</div>
						</div>
                    <?php else: ?>
                        <div class="preloader-area preloader-img">
                            <div class="loader">
                            </div>
                        </div>
                    <?php endif;
                endif;
            else:
                if ( $preloader_style == 'text' ) :
                    if (!empty( $kiedo_opt['loading_text'] ) ) : ?>
                        <div class="preloader-area ">
                            <div class="loader">
                                <p class="text-center"> <?php echo esc_html( $kiedo_opt['loading_text'] ) ?> </p>
                            </div>
                        </div>
                    <?php endif;
                elseif( $preloader_style == 'circle-spin' ) :
                    ?>
                    <div class="preloader-area">
						<div class="spinner">
							<div class="inner">
								<div class="disc"></div>
								<div class="disc"></div>
								<div class="disc"></div>
							</div>
						</div>
					</div>
                <?php else : ?>
                    <div class="preloader-area preloader-img">
                        <div class="loader">
                        </div>
                    </div>
                    <?php
                endif;
            endif;
        endif;
	}
endif;

/**
 * Kiedo Page Shape Images
 */
if ( ! function_exists( 'kiedo_page_shape_images' ) ) {
	function kiedo_page_shape_images() {
		global $kiedo_opt;
        if(isset($kiedo_opt['banner_img1']['url'])):
            ?>
                <div class="divider"></div>
                <div class="lines">
                    <div class="line"></div>
                    <div class="line"></div>
                    <div class="line"></div>
                    <div class="line"></div>
                    <div class="line"></div>
                </div>
                <?php if( $kiedo_opt['banner_img1']['url'] != ''  ): ?>
                    <div class="banner-shape1">
                        <img src="<?php echo esc_url( $kiedo_opt['banner_img1']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image ', 'kiedo' ); ?>">
                    </div>
                <?php endif; ?>
            <?php
        endif;
	}
}


/**
 * Kiedo RTL
*/
if( ! function_exists( 'kiedo_rtl' ) ):
	function kiedo_rtl() {
		global $kiedo_opt;

		if(	isset( $kiedo_opt['kiedo_enable_rtl'])  ):
			$kiedo_rtl_opt = $kiedo_opt['kiedo_enable_rtl'];
		else:
			$kiedo_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$kiedo_rtl_opt = $_GET['rtl'];
		}

		if ( $kiedo_rtl_opt == 'enable' ) :
			$kiedo_rtl = true;
		else:
			$kiedo_rtl = false;
		endif;

		return $kiedo_rtl;
	}
endif;


/**
 * kiedo Allowed HTML
 */
if ( ! function_exists( 'kiedo_kses_allowed_html' ) ) :
	function kiedo_kses_allowed_html($tags, $context) {
		$allowed_atts = array(
			'align'      => array(),
			'class'      => array(),
			'type'       => array(),
			'id'         => array(),
			'dir'        => array(),
			'lang'       => array(),
			'style'      => array(),
			'xml:lang'   => array(),
			'src'        => array(),
			'alt'        => array(),
			'href'       => array(),
			'rel'        => array(),
			'rev'        => array(),
			'target'     => array(),
			'novalidate' => array(),
			'type'       => array(),
			'value'      => array(),
			'name'       => array(),
			'tabindex'   => array(),
			'action'     => array(),
			'method'     => array(),
			'for'        => array(),
			'width'      => array(),
			'height'     => array(),
			'data'       => array(),
			'title'      => array(),
		);
		switch($context) {
		case 'kiedoallowedhtml':
			$tags = array(
				'form'    => $allowed_atts,
				'label'   => $allowed_atts,
				'input'   => $allowed_atts,
				'textarea'=> $allowed_atts,
				'iframe'  => $allowed_atts,
				'script'  => $allowed_atts,
				'style'   => $allowed_atts,
				'strong'  => $allowed_atts,
				'small'   => $allowed_atts,
				'table'   => $allowed_atts,
				'span'    => $allowed_atts,
				'abbr'    => $allowed_atts,
				'code'    => $allowed_atts,
				'pre'     => $allowed_atts,
				'div'     => $allowed_atts,
				'img'     => $allowed_atts,
				'h1'      => $allowed_atts,
				'h2'      => $allowed_atts,
				'h3'      => $allowed_atts,
				'h4'      => $allowed_atts,
				'h5'      => $allowed_atts,
				'h6'      => $allowed_atts,
				'ol'      => $allowed_atts,
				'ul'      => $allowed_atts,
				'li'      => $allowed_atts,
				'em'      => $allowed_atts,
				'hr'      => $allowed_atts,
				'br'      => $allowed_atts,
				'tr'      => $allowed_atts,
				'td'      => $allowed_atts,
				'p'       => $allowed_atts,
				'a'       => $allowed_atts,
				'b'       => $allowed_atts,
				'i'       => $allowed_atts,
			);
			return $tags;
		default:
			return $tags;
		}
	}
endif;

add_filter( 'wp_kses_allowed_html', 'kiedo_kses_allowed_html', 10, 2);