<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'kiedo_custom_style' ) ) {
    function kiedo_custom_style(){

        $custom_style ='';
            global $kiedo_opt;

            if( isset( $kiedo_opt['primary_color'] ) ):
                $primary_color              = $kiedo_opt['primary_color'];
                if(isset($kiedo_opt['theme_gradient_color']['from'])):
                    $gradient_from              = $kiedo_opt['theme_gradient_color']['from'];
                    $gradient_to                = $kiedo_opt['theme_gradient_color']['to'];
                else:
                    $gradient_from = '';
                    $gradient_to = '';
                endif;
                $secondary_color            = $kiedo_opt['secondary_color'];
                $footer_bg                  = $kiedo_opt['footer_bg'];
                $nav_item_color             = $kiedo_opt['nav_item_color'];
                $mob_nav_item_color 	    = $kiedo_opt['mob_nav_item_color'];
                $hide_blog_banner           = $kiedo_opt['hide_blog_banner'];
            else:
                $primary_color              = '#0064FB';
                $secondary_color            = '#FF414B';
                $footer_bg                  = '#F4F8FC';
                $nav_item_color             = '#494A60';
                $mob_nav_item_color         = '#494A60';
                $gradient_from              = '#ED2775';
                $gradient_to                = '#FF7448';
                $hide_blog_banner           = false;
            endif;

            $custom_style .='

            :root {
                --mainColor: '.esc_attr($primary_color).';
                --optionalColor: '.esc_attr($secondary_color).';
                ';
                
                if($gradient_from):
                    $custom_style .='
                    --gradientColor: linear-gradient(44.44deg, '.esc_attr($gradient_from).' 7.79%, '.esc_attr($gradient_to).' 94.18%);';
                endif;
                $custom_style .='
            } ';
            if($gradient_from):
                $custom_style .='
                .app-download-inner::before, .pricing-area.bg-gradient-color::before, .free-trial-content::before, .features-box .icon, .features-box .icon.bg3, .features-box .icon.bg4, .features-lists ul li .icon, .features-lists ul li .icon.bg2, .features-lists ul li .icon.bg4, .software-integrations-area.bg-gradient-color::before, .features-item .icon, .features-item .icon.bg3, .features-item .icon.bg4, .features-item .icon.bg5, .features-item .icon.bg6, .feedback-slides.owl-theme .owl-dots .owl-dot span::after, .single-blog .image .tag, .main-banner, .single-features-item .icon, .single-features-item .icon.bg2, .single-features-item .icon.bg4, .single-features-item .icon.bg5, .single-features-item .icon.bg6, .software-integrations-inner.bg-gradient-color::before, .feedback-area.bg-gradient-color::before, .feedback-slides-two.owl-theme .owl-dots .owl-dot span::after, .gradient-banner-area, .about-image::before, .pricing-area.gradient-color, .free-trial-inner::before, .funfacts-box.bg1, .funfacts-box.bg2, .funfacts-box.bg3, .features-card, .app-about-content .list li .icon.bg2, .key-features-card .icon i, .app-screenshots-area.bg-color::before, .new-free-trial-inner-box, .features-inner-card .icon i, .app-ever-content .list li .icon.bg2, .features-content .features-list li .icon, .features-content .features-list li .icon.bg2, .features-content .features-list li:hover .icon.bg3, .features-content .features-list li:hover .icon.bg2, .features-content .features-list li:hover .icon, .single-features-box .icon, .single-features-box .icon.bg3, .single-features-box .icon.bg4, .new-app-progress-wrap-area .new-app-progress-content .default-btn::before, .new-feedback-wrap-slides.owl-theme .owl-nav [class*=owl-], .app-pricing-gradient-area .single-app-pricing-box::before, .new-free-trial-inner-box.wrap-with-gradient, .new-free-trial-inner-box.wrap-with-gradient .new-free-trial-content form .default-btn::before, .contact-info-inner .single-contact-info-box .icon.bg1, .contact-info-inner .single-contact-info-box .icon.bg2 {
                    background: linear-gradient(44.44deg, '.esc_attr($gradient_from).' 7.79%, '.esc_attr($gradient_to).' 94.18%);
                }';
            endif;
            
            $custom_style .='

            .widget_rss ul li a:hover { color: '.esc_attr($secondary_color).' !important; }

            theme_gradient_color { color: '.esc_attr($secondary_color).' !important; }

            .post-password-form input[type="submit"]:hover, .faq-accordion .accordion .accordion-content, .video-box .video-btn::after, .video-box .video-btn::before, .footer-area .tagcloud a:hover { border-color: '.esc_attr($secondary_color).'; }

            .main-navbar .navbar .navbar-nav .nav-item a, .main-navbar .navbar .navbar-nav .nav-item .dropdown-menu li a { color: '.esc_attr( $nav_item_color  ).'; }

            .mean-container .mean-nav ul li a { color: '.esc_attr( $mob_nav_item_color  ).'; }';

            $custom_style .='
            .single-products .sale-btn, .single-products .products-image ul li a:hover,
            .shop-sidebar .widget_product_search form button, .shop-sidebar a.button, .shop-sidebar .woocommerce-widget-layered-nav-dropdown__submit, .shop-sidebar .woocommerce button.button, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .products_details div.product .woocommerce-tabs .panel #respond input#submit, .products_details div.product .product_title::before, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .btn-primary:hover, .woocommerce #respond input#submit, .woocommerce button.button, .woocommerce input.button, .woocommerce .woocommerce-MyAccount-navigation ul .is-active a, .woocommerce .woocommerce-MyAccount-navigation ul li a:hover, .products_details div.product span.sale-btn, .products_details div.product .woocommerce-tabs ul#tabs .nav-item .nav-link::before, a.button.wc-forward  { background-color: '.esc_attr($secondary_color).'; }
            .btn-primary, .btn-primary.disabled, .btn-primary:disabled{ background-color: '.esc_attr($secondary_color).'; }
            .woocommerce ul.products li.product h3 a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .products_details div.product .woocommerce-tabs ul.tabs li a:hover, .products_details div.product .woocommerce-tabs ul.tabs li.active, .products_details div.product .woocommerce-tabs ul.tabs li.active a:hover, .products_details div.product .product_meta span.posted_in a:hover, .products_details div.product .product_meta span.tagged_as a:hover, .products_details div.product span.price, .cart-table table tbody tr td.product-name a, .woocommerce-message::before, .woocommerce-info::before { color: '.esc_attr ($secondary_color).'; }
            .woocommerce-info, .woocommerce-message { border-top-color: '.esc_attr ($secondary_color).'; }
            .shop-sidebar .widget_shopping_cart .cart_list li a:hover, .shop-sidebar ul li a:hover { color: '.esc_attr ($secondary_color).' !important; }
            .woocommerce ul.products li.product:hover .add-to-cart-btn, .form-control:focus, .woocommerce .form-control:focus { border-color: '.esc_attr ($secondary_color).'; } ';


            // Hide Sticky Header
            if(isset($kiedo_opt['enable_sticky_header']) && $kiedo_opt['enable_sticky_header'] == false){ $custom_style .='
                .navbar-area.is-sticky{
                    display:none !important;
                }';
            }

            // Custom Css
            if( isset($kiedo_opt['css_code'] ) && !empty($kiedo_opt['css_code']) ):
                $custom_style .= $kiedo_opt['css_code'];
            endif;

            if( is_user_logged_in() ){
                $custom_style .=' .comments-area .comment-respond .form-submit {
                    margin-top: 20px;
                }';
            }

            // Pre-loader image
            $is_preloader       = !empty($kiedo_opt['enable_preloader']) ? $kiedo_opt['enable_preloader'] : '';
            $preloader_image = isset( $kiedo_opt['preloader_image']['url'] ) ? $kiedo_opt['preloader_image']['url'] : KIEDO_IMG .'/status.gif';
            $preloader_style = !empty( $kiedo_opt['preloader_style'] ) ? $kiedo_opt['preloader_style'] : 'text';
            if ( $preloader_style == 'image' && $is_preloader == '1' ) {
                $custom_style .= "
                .preloader:after,  .preloader:before {
                    display: none;
                }
                .preloader {
                    background: #fff;
                }
                .preloader-img {
                    background-image: url(" . esc_url( $preloader_image ) . ");
                    background-repeat: no-repeat;
                    background-position: center;
                }";
            }

            wp_add_inline_style('kiedo-main-style', $custom_style);

            // Custom Js
            $custom_script ='';
            if( isset($kiedo_opt['js_code'] )){
                $custom_script .= $kiedo_opt['js_code'];
            }

            wp_add_inline_script( 'kiedo-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'kiedo_custom_style' );