<?php
/**
 * ACF
 */

if( function_exists('acf_add_local_field_group') ):

    acf_add_local_field_group(array(
        'key' => 'group_5e0c6851b0a0b',
        'title' => 'Page Option',
        'fields' => array(
            array(
                'key' => 'field_5e0c685e71de2',
                'label' => esc_html__('Hide Page Banner', 'kiedo'),
                'name' => 'enable_page_banner',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_5e0c689071de3',
                'label' => esc_html__('Hide Breadcrumb', 'kiedo'),
                'name' => 'hide_breadcrumb',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5e0c685e71de2',
                            'operator' => '!=',
                            'value' => '1',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_5e0c6gs89071de3',
                'label' => esc_html__('Header Style Two?', 'kiedo'),
                'name' => 'header_style_two',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_5c4fea89283cc',
                'label' => esc_html__( 'Header Layout', 'kiedo'),
                'name' => 'header_layout',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    'container-fluid' => esc_html__( 'Full Width', 'kiedo' ),
                    'container' => esc_html__( 'Container', 'kiedo' ),
                ),
                'default_value' => 'container',
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'default',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89b10ass134f4',
        'title' => esc_html__('Single Post', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5e89b1ss1b50ccf',
                'label' => esc_html__('Banner Background Image', 'kiedo'),
                'name' => 'post_banner_background_image',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89dsb10ass1ss34fg44',
        'title' => esc_html__('Services Meta', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5e89b1ssss1bs50cssc4',
                'label' => esc_html__('Services Icon(For Services Style Two)', 'kiedo'),
                'name' => 'service_icon',
                'type' => 'text',
                'instructions' => 'ri-quill-pen-line, You can use icon class name from https://remixicon.com/',
            ),
            array(
                'key' => 'field_60ef39bef8923',
                'label' => 'Service Icon Primary Color',
                'name' => 'service_icon_primary_color',
                'type' => 'color_picker',
                'instructions' => 'This Option for Services Widget Style 2',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
            ),
            array(
                'key' => 'field_60ef39f0f8924',
                'label' => 'Service Icon Secondary Color',
                'name' => 'service_icon_secondary_color',
                'type' => 'color_picker',
                'instructions' => 'This Option for Services Widget Style 2',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5ea463adda67f',
        'title' => esc_html__('Post Meta Info', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5ea463bb57214',
                'label' => esc_html__('Choose Post Style', 'kiedo'),
                'name' => 'choose_style_type',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Style One',
                    2 => 'Style Two',
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5ee06d3c580d8',
        'title' => esc_html__('Custom Posts Custom Link', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5ee06e1c55813',
                'label' => esc_html__('Choose Link Type', 'kiedo'),
                'name' => 'choose_link_type',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Post Details Page',
                    2 => 'External Link',
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
            array(
                'key' => 'field_5ee06ec78bf72',
                'label' => esc_html__('External Link', 'kiedo'),
                'name' => 'external_link',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5ee06e1c55813',
                            'operator' => '==',
                            'value' => '2',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5esse06ec78bf72',
                'label' => esc_html__('Icon Class Name', 'kiedo'),
                'name' => 'icon',
                'type' => 'text',
                'instructions' => esc_html__('You can use remixicon/font-awesome icon class name', 'kiedo'),
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'ri-vip-diamond-line',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'features',
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    // Career Meta
    acf_add_local_field_group(array(
        'key' => 'group_5e3ac008538f6',
        'title' => esc_html__('Career Meta', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5e3ac01683f33',
                'label' => esc_html__('Location Label', 'kiedo'),
                'name' => 'job_location_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' =>  esc_html__('Anywhere', 'kiedo'),
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e3ac01683f34',
                'label' => esc_html__('Job Time', 'kiedo'),
                'name' => 'career_job_type',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' =>  esc_html__('Full-Time', 'kiedo'),
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'career',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        
    ));


    // Footer Style
    acf_add_local_field_group(array(
        'key' => 'group_5ec50fbea1206',
        'title' => esc_html__('Footer Style', 'kiedo'),
        'fields' => array(
            array(
                'key' => 'field_5ec50fc77bef9',
                'label' => esc_html__('Choose Footer Style', 'kiedo'),
                'name' => 'choose_footer_style',
                'type' => 'radio',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Footer Style One',
                    2 => 'Footer Style Two',
                ),
                'allow_null' => 0,
                'other_choice' => 0,
                'default_value' => '',
                'layout' => 'vertical',
                'return_format' => 'value',
                'save_other_choice' => 0,
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'features',
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
endif;