<?php
/**
 * The template for displaying the footer
 * @package Kiedo
 */

	/**
	 * Footer optional data
	 */
	global $kiedo_opt;
	if( isset( $kiedo_opt['copyright_text'] )):
		$copyright_text 		= $kiedo_opt['copyright_text'];
		$enable_back_to_top 	= $kiedo_opt['enable_back_to_top'];
	else:
		$copyright_text 		= '';
		$enable_back_to_top 	= true;
	endif;

	// Footer Class
	if ( is_active_sidebar( 'footer_widgets' ) ):
		$footer_class = 'footer-area footer-style-two pt-100';
	else:
		$footer_class = 'blank-footer';
	endif;

	if( function_exists('acf_add_options_page') ){
		$footer_style = get_field('choose_footer_style');
		if( is_home() ) {
			$post_page_id  = get_option( 'page_for_posts' );
			$footer_style  = get_field( 'choose_footer_style', $post_page_id);
		}
	} else {
		$footer_style = 1;
	}
?>
	<!-- Start Footer Area -->

	<?php if($footer_style == 2){ ?>
		<div class="footer-area-style-with-black-color">
            <div class="container">
                <div class="row">
					<?php if ( is_active_sidebar( 'footer_widgets') ) :
						dynamic_sidebar( 'footer_widgets' );
					endif; ?>
                </div>

				<?php if( $copyright_text != '' ){ ?>
					<div class="copyright-area">
						<p><?php echo wp_kses_post( $copyright_text ); ?></p>
					</div>
				<?php } ?>
            </div>
			<?php if ( isset( $kiedo_opt['footer_image']['url'] ) && $kiedo_opt['footer_image']['url'] !='' ) { ?>
				<div class="footer-white-shape">
					<img src="<?php echo esc_url( $kiedo_opt['footer_image']['url'] ); ?> " alt="<?php esc_attr_e( 'Shape', 'kiedo' ); ?>">
				</div>
			<?php } ?>
        </div>
	<?php } else  { ?>
		<?php if( $footer_class != 'blank-footer' ): ?>
			<footer class="<?php echo esc_attr( $footer_class ); ?>">
				<div class="container">
					<div class="row justify-content-cente">
						<?php if ( is_active_sidebar( 'footer_widgets') ) : ?>
							<?php dynamic_sidebar( 'footer_widgets' ); ?>
						<?php endif; ?>
					</div>

					<?php if( $copyright_text != '' ){ ?>
						<div class="copyright-area">
							<p><?php echo wp_kses_post( $copyright_text ); ?></p>
						</div>
					<?php } ?>
				</div>
			</footer>
		<?php endif; ?>
	<?php } ?>

	<?php if( $enable_back_to_top == true ):?>
		<div class="go-top">
            <i class="ri-arrow-up-s-line"></i>
        </div>
	<?php endif; ?>

	<?php
    $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ( strpos($actual_link, 'themes.hibootstrap.com/kiedo') != false ): ?>
		<div class="et-demo-options-toolbar">
			<?php
			global $wp;
			$current_url = home_url(add_query_arg(array(), $wp->request));
			$home_url = home_url();

			?>
			<?php if( kiedo_rtl() == true ): ?>
				<a href="<?php echo esc_url( $current_url ); ?>" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="LTR Demo">
					<i class="ri-layout-left-line"></i>
				</a>
			<?php else: ?>
				<a href="<?php echo esc_url( $current_url ); ?>/?rtl=enable" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="RTL Demo">
					<i class="ri-layout-right-line"></i>
				</a>
			<?php endif; ?>

			<a href="https://support.hibootstrap.com/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Reach Us">
				<i class="ri-customer-service-line"></i>
			</a>
			<a href="https://docs.hibootstrap.com/docs/kiedo-theme-documentation/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Documentation">
				<i class="ri-book-2-line"></i>
			</a>
			<a href="https://1.envato.market/GjZOAk" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Purchase Kiedo">
				<i class="ri-shopping-cart-line"></i>
			</a>
		</div>
	<?php endif; ?>

<?php wp_footer(); ?>

</body>
</html>