<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Kiedo
 */
get_header();

/**
 * Page Control
 */
if( function_exists('acf_add_options_page') ) {
	$hide_banner 		= get_field( 'enable_page_banner' );
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
}else {
	$hide_banner 		= false;
	$hide_breadcrumb 	= false;
}

// Page Title
if( isset($kiedo_opt['page_title_tag']) ):
    $tag = $kiedo_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;
?>
<?php if( $hide_banner == false ) { ?><!-- Start Page Title Area -->
	<div class="page-title-area">
		<div class="container">
			<div class="page-title-content">
				<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

				<?php if( $hide_breadcrumb == false ): ?>
					<?php
						if ( function_exists('yoast_breadcrumb') ) {
							yoast_breadcrumb( '<p class="kiedo-seo-breadcrumbs" id="breadcrumbs">','</p>' );
						} else { ?>
							<ul>
								<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'kiedo' ); ?></a></li>
								<li><?php the_title(); ?></li>
							</ul>
							<?php
						}
				endif; ?>
			</div>
		</div>

		<?php kiedo_page_shape_images(); ?>
	</div>
<?php }

if ( bp_is_user() ) {
	get_template_part( 'buddypress/members/content-single' );
} elseif ( bp_is_group_single() ) {
	 get_template_part( 'buddypress/groups/content-single' );
} elseif ( bp_is_activity_directory() ) {
	get_template_part( 'buddypress/activity/content-directory' );
} else {
	get_template_part( 'buddypress/content', 'page' );
}

get_footer();