jQuery(function ($) {
    'use strict';
	jQuery(document).on('ready', function () {

		// Mean Menu
		$('.mean-menu').meanmenu({
			meanScreenWidth: "991"
		});

		// Header Sticky
		$(window).on('scroll',function() {
			if ($(this).scrollTop() > 120){
				$('.navbar-area').addClass("is-sticky");
			}
			else{
				$('.navbar-area').removeClass("is-sticky");
			}
		});

		$('.colfooter-default-column:nth-child(1)').addClass('col-lg-3 col-md-6 col-sm-6');
		$('.colfooter-default-column:nth-child(2)').addClass('col-lg-2 col-md-6 col-sm-6');
		$('.colfooter-default-column:nth-child(3)').addClass('col-lg-2 col-md-3 col-sm-6');
		$('.colfooter-default-column:nth-child(4)').addClass('col-lg-2 col-md-3 col-sm-6');
		$('.colfooter-default-column:nth-child(5)').addClass('col-lg-3 col-md-6 col-sm-6');

		// Odometer JS
		$('.odometer').appear(function(e) {
			var odo = $(".odometer");
			odo.each(function() {
				var countNumber = $(this).attr("data-count");
				$(this).html(countNumber);
			});
		});

		// On Hover
		$('.single-gallery-item').hover(
			function(){ $(".single-gallery-item").addClass('hover') },
			function(){ $(".single-gallery-item").removeClass('hover') }
		);

		// On Hover
		$('.software-integrations-list ul li').hover(
			function(){ $(".software-integrations-list ul li").addClass('hover') },
			function(){ $(".software-integrations-list ul li").removeClass('hover') }
		);

		// Popup Image
		$('.popup-image').magnificPopup({
			type: 'image',
			gallery:{
				enabled:true
			}
		});

		// Popup Video
		$('.popup-video').magnificPopup({
			disableOn: 320,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
		});

		// Input Plus & Minus Number JS
		$('.input-counter').each(function() {
			var spinner = jQuery(this),
			input = spinner.find('input[type="text"]'),
			btnUp = spinner.find('.plus-btn'),
			btnDown = spinner.find('.minus-btn'),
			min = input.attr('min'),
			max = input.attr('max');
			btnUp.on('click', function() {
				var oldValue = parseFloat(input.val());
				if (oldValue >= max) {
					var newVal = oldValue;
				} else {
					var newVal = oldValue + 1;
				}
				spinner.find("input").val(newVal);
				spinner.find("input").trigger("change");
			});
			btnDown.on('click', function() {
				var oldValue = parseFloat(input.val());
				if (oldValue <= min) {
					var newVal = oldValue;
				} else {
					var newVal = oldValue - 1;
				}
				spinner.find("input").val(newVal);
				spinner.find("input").trigger("change");
			});
		});

		// Go to Top
		$(function(){
			// Scroll Event
			$(window).on('scroll', function(){
				var scrolled = $(window).scrollTop();
				if (scrolled > 600) $('.go-top').addClass('active');
				if (scrolled < 600) $('.go-top').removeClass('active');
			});
			// Click Event
			$('.go-top').on('click', function() {
				$("html, body").animate({ scrollTop: "0" },  500);
			});
		});
	});

	// Preloader
	$(window).on('load', function() {
		$('.preloader-area').fadeOut();
	});

	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {

			// AOS
			AOS.init();

			// Trusted By Slides
			$('.trusted-by-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 2
					},
					576: {
						items: 3
					},
					768: {
						items: 4
					},
					992: {
						items: 4
					},
					1200: {
						items: 4
					}
				}
			});

			// Screenshots Slides
			$('.screenshots-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 25,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 2
					},
					768: {
						items: 3
					},
					992: {
						items: 4
					},
					1200: {
						items: 5
					}
				}
			});

			// Feedback Slides
			$('.feedback-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: true,
				center: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 3
					},
					1200: {
						items: 3
					}
				}
			});
			$('.feedback-slides-two').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 2
					},
					1200: {
						items: 2
					}
				}
			});

			// Testimonials Slides
			$('.testimonials-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 25,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 1
					},
					1200: {
						items: 1
					}
				}
			});

			// Partner Slides
			$('.partner-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 2
					},
					576: {
						items: 3
					},
					768: {
						items: 4
					},
					992: {
						items: 6
					}
				}
			});

			// Feedback Swiper Slides
			var swiper = new Swiper('.feedback-swiper-slides', {
				loop: true,
				effect: 'cube',
				grabCursor: true,
				cubeEffect: {
					shadow: true,
					slideShadows: true,
					shadowOffset: 20,
					shadowScale: 0.94,
				},
				navigation: {
					nextEl: '.swiper-button-next',
					prevEl: '.swiper-button-prev',
				}
			});

			// Swiper Screenshots Slides
			var swiper = new Swiper('.screenshots-swiper-slides', {
				loop: true,
				effect: 'coverflow',
				grabCursor: true,
				centeredSlides: true,
				parallax: true,
				slidesPerView: 'auto',
				coverflowEffect: {
					rotate: 50,
					stretch: 0,
					depth: 100,
					modifier: 1,
					slideShadows: true,
				},
				navigation: {
					nextEl: '.swiper-button-next',
					prevEl: '.swiper-button-prev',
				}
			});

			// Screen Swiper Slides
			var swiper = new Swiper('.screen-swiper-slides', {
				loop: true,
				effect: 'cube',
				grabCursor: true,
				cubeEffect: {
					shadow: true,
					slideShadows: true,
					shadowOffset: 20,
					shadowScale: 0.94,
				},
				navigation: {
					nextEl: '.swiper-button-next',
					prevEl: '.swiper-button-prev',
				}
			});



			/*
			New Demo JS
			======================================================*/

			// New App Trusted By Slides
			$('.new-app-trusted-by-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: false,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 2
					},
					576: {
						items: 3
					},
					768: {
						items: 3
					},
					992: {
						items: 2
					},
					1200: {
						items: 3
					}
				}
			});

			// App Screenshots Slides
			$('.app-screenshots-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 2
					},
					768: {
						items: 3
					},
					992: {
						items: 4
					},
					1200: {
						items: 5
					}
				}
			});

			// On Hover
			$('.new-software-list ul li').hover(
				function(){ $(".new-software-list ul li").addClass('hover') },
				function(){ $(".new-software-list ul li").removeClass('hover') }
			);

			// New Feedback Slides
			$('.new-feedback-slides').owlCarousel({
				nav: false,
				loop: true,
				margin: 25,
				dots: true,
				center: true,
				autoplay: true,
				autoplayHoverPause: true,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						items: 1
					},
					576: {
						items: 1
					},
					768: {
						items: 2
					},
					992: {
						items: 3
					},
					1200: {
						items: 3
					}
				}
			});
			$('.new-feedback-wrap-slides').owlCarousel({
				nav: true,
				loop: true,
				margin: 25,
				dots: false,
				center: true,
				autoplay: true,
				autoplayHoverPause: true,
				stagePadding: 100,
				navText: [
					"<i class='ri-arrow-left-s-line'></i>",
					"<i class='ri-arrow-right-s-line'></i>",
				],
				responsive: {
					0: {
						stagePadding: 0,
						items: 1
					},
					576: {
						stagePadding: 0,
						items: 1
					},
					768: {
						stagePadding: 0,
						items: 2
					},
					992: {
						stagePadding: 0,
						items: 3
					},
					1200: {
						items: 2
					}
				}
			});

			// Feedback Swiper Wrap Slides
			var swiper = new Swiper('.feedback-swiper-wrap-slides', {
				loop: true,
				effect: 'cube',
				grabCursor: true,
				cubeEffect: {
					shadow: true,
					slideShadows: true,
					shadowOffset: 20,
					shadowScale: 0.94,
				},
				navigation: {
					nextEl: '.swiper-button-next',
					prevEl: '.swiper-button-prev',
				}
			});

			// Swiper Screenshots Wrap Slides
			var swiper = new Swiper('.screenshots-swiper-wrap-slides', {
				loop: true,
				effect: 'coverflow',
				grabCursor: true,
				centeredSlides: true,
				parallax: true,
				slidesPerView: 'auto',
				coverflowEffect: {
					rotate: 50,
					stretch: 0,
					depth: 100,
					modifier: 1,
					slideShadows: true,
				},
				pagination: {
                    el: ".swiper-pagination",
                    clickable: true
                }
				
			});

		});
    });

}(jQuery));