<?php
$html       = null;
$linkTarget = ( $link_target ? " target='{$link_target}'" : null );
?>
<div class='<?php echo esc_attr( $grid . ' ' . $class ) ?>' data-id='<?php echo esc_attr( $iID ); ?>'>
    <div class="tlp-portfolio-item">
        <div class="tlp-portfolio-thumb tlp-item">
			<?php if ( $link && ! $external_url ): ?>
                <a class="tlp-item-details <?php echo esc_attr( $anchorClass ) ?>" <?php echo $linkTarget; ?>
                   data-id="<?php echo esc_attr( $iID ) ?>" title="<?php echo esc_attr( $title ) ?>"
                   href="<?php echo esc_url( $pLink ); ?>">
					<?php echo wp_kses_post( $img ); ?>
                </a>
			<?php else: ?>
				<?php echo wp_kses_post( $img ); ?>
			<?php endif; ?>
            <div class="tlp-overlay">
                <p class="link-icon">
					<?php if ( $link && ! $external_url ): ?>
                        <a class="tlp-item-details <?php echo esc_attr( $anchorClass ) ?>" <?php echo $linkTarget; ?>
                           data-id="<?php echo esc_attr( $iID ) ?>" title="<?php echo esc_attr( $title ) ?>"
                           href="<?php echo esc_url( $pLink ); ?>">
                            <i class="icon-info"></i></a>
					<?php endif; ?>
					<?php if ( in_array( 'project_url', $items ) && $project_url ): ?>
                        <a target="_blank" href="<?php echo esc_url( $project_url ) ?>"><i
                                    class="icon-link-ext"></i></a>
					<?php endif; ?>
					<?php if ( in_array( 'zoom', $items ) ): ?>
                        <a class="pfp-zoom" data-lightbox="<?php echo esc_attr( $zoomId ); ?>"
                           title="<?php echo esc_html( $title ) ?>"
                           href="<?php echo esc_url( $img_full_url ) ?>"><i class="icon-move"
                                                                            aria-hidden="true"></i></a>
					<?php endif; ?>
                </p>
            </div>
        </div>
		<?php
		$htmlC = null;
		if ( in_array( 'name', $items ) ) {
			if ( $link ) {
				$htmlC .= '<h3 class="title"><a class="tlp-item-details' . $anchorClass . '"  ' . $linkTarget . ' data-id="' . absint( $iID ) . '" title="' . esc_html( $title ) . '" href="' . esc_url( $pLink ) . '">' . esc_html( $title ) . '</a></h3>';
			} else {
				$htmlC .= '<h3 class="title">' . esc_html( $title ) . '</h3>';
			}
		}
		if ( in_array( 'short_description', $items ) && $short_desc ) {
			$htmlC .= '<div class="short-desc">' . wp_kses_post( $short_desc ) . '</div>';
		}
		?>
		<?php if ( $htmlC ) : ?>
            <div class="tlp-content">
                <div class="tlp-content-holder"><?php echo wp_kses_post( $htmlC ); ?></div>
            </div>
		<?php endif; ?>
    </div>
</div>