<?php

if (!class_exists('PFProLoadMoreResponse')):

    class PFProLoadMoreResponse {

        public function __construct()
        {
            add_action('wp_ajax_pfpLoadMore', array($this, 'pfpLoadMore'));
            add_action('wp_ajax_nopriv_pfpLoadMore', array($this, 'pfpLoadMore'));
        }

        function pfpLoadMore()
        {
            $error = true;
            $msg = $data = null;
            if (TLPpPro()->verifyNonce()) {
                $scID = intval($_REQUEST['scID']);
                $foundPosts = isset( $_REQUEST['foundPosts'] ) ? intval( $_REQUEST['foundPosts'] ) : null ;
                if ($scID && !is_null(get_post($scID))) {
                    $scMeta = get_post_meta($scID);
                    $layout = (!empty($scMeta['pfp_layout'][0]) ? sanitize_text_field( $scMeta['pfp_layout'][0] ) : 'layout1');
                    if (!in_array($layout, array_keys(TLPpPro()->scLayout()))) {
                        $layout = 'layout1';
                    }
                    
                    $dCol = (isset($scMeta['pfp_desktop_column'][0]) ? absint($scMeta['pfp_desktop_column'][0]) : 3);
                    $tCol = (isset($scMeta['pfp_tab_column'][0]) ? absint($scMeta['pfp_tab_column'][0]) : 2);
                    $mCol = (isset($scMeta['pfp_mobile_column'][0]) ? absint($scMeta['pfp_mobile_column'][0]) : 1);
                    if (!in_array($dCol, array_keys(TLPpPro()->scColumns()))) {
                        $dCol = 3;
                    }
                    if (!in_array($tCol, array_keys(TLPpPro()->scColumns()))) {
                        $tCol = 2;
                    }
                    if (!in_array($dCol, array_keys(TLPpPro()->scColumns()))) {
                        $mCol = 1;
                    }

                    $customImgSize = get_post_meta($scID, 'pfp_custom_image_size', true);
                    $imgSize = (!empty($scMeta['pfp_image_size'][0]) ? sanitize_text_field( $scMeta['pfp_image_size'][0] ) : "medium");

                    $excerpt_limit = (!empty($scMeta['pfp_excerpt_limit'][0]) ? absint($scMeta['pfp_excerpt_limit'][0]) : 0);

                    if ( $layout == 'layout2' || $layout == 'isotope20' ) {
                        $arg['image_area']   = "pfp-col-md-5 pfp-col-sm-12";
                        $arg['content_area'] = "pfp-col-md-7 pfp-col-sm-12";
                    }else{
                        $arg['image_area']   = "";
                        $arg['content_area'] = "";
                    }

                    $isIsotope = preg_match('/isotope/', $layout);
                    $isCarousel = preg_match('/carousel/', $layout);

                    /* Argument create */
                    $containerDataAttr = false;
                    $args = array();
                    $args['post_type'] = TLPpPro()->post_type;
                    // Common filter
                    /* post__in */
                    $post__in = (isset($scMeta['pfp_post__in'][0]) ? sanitize_text_field( $scMeta['pfp_post__in'][0] ) : null);

                    if ($post__in) {
                        $post__in = explode(',', $post__in);
                        $args['post__in'] = $post__in;
                    }
                    
                    // loaded_post_ids
                    /* post__not_in */
                    $post__not_in = (isset($scMeta['pfp_post__not_in'][0]) ? sanitize_text_field( $scMeta['pfp_post__not_in'][0] ) : null);
                    if ($post__not_in) {
                        $post__not_in = explode(',', $post__not_in);
                        $args['post__not_in'] = $post__not_in;
                    }
                    $loaded_posts = isset( $_REQUEST['loaded_post_ids'] ) ? sanitize_text_field( $_REQUEST['loaded_post_ids'] ) : '' ;
                    $loaded_posts = !empty( $loaded_posts ) ? explode(',', $loaded_posts ) : array();
                    if (!empty($loaded_posts)) {
                        $args['post__not_in'] = is_array($post__not_in) && !empty($post__not_in) ? array_merge($post__not_in,
                            $loaded_posts) : $loaded_posts;
                    }
                    
                    /* LIMIT */
                    $limit = ((empty($scMeta['pfp_limit'][0]) || $scMeta['pfp_limit'][0] === '-1') ? 10000000 : absint( $scMeta['pfp_limit'][0] ) );
                    $args['posts_per_page'] = $limit;

                    // Pagination
                    $pagination = (!empty($scMeta['pfp_pagination'][0]) ? true : false);
                    
                    if ($pagination) {
                        $posts_per_page = (isset($scMeta['pfp_posts_per_page'][0]) ? intval($scMeta['pfp_posts_per_page'][0]) : $limit);
                        if ($posts_per_page > $limit) {
                            $posts_per_page = $limit;
                        }
                        // Set 'posts_per_page' parameter
                        $args['posts_per_page'] = $posts_per_page;
                        $paged = (!empty($_REQUEST['paged'])) ? absint($_REQUEST['paged']) : 2;
                        $offset = $posts_per_page * ((int) $paged - 1);
                        
                        $args['paged'] = $paged;

                        // Update posts_per_page
                        if( isset( $args['post__not_in'] ) && !empty( $args['post__not_in'] ) ){
                            $remaining_post = $limit - count( $args['post__not_in'] ) ;
                            $foundPostsRemaining = $foundPosts - count( $args['post__not_in'] ) ;
                            if( 0 < $remaining_post ){
                                if ( intval( $args['posts_per_page'] ) > $remaining_post ) {
                                    $args['posts_per_page'] = $remaining_post;
                                }
                                elseif ( intval( $args['posts_per_page'] ) > $foundPostsRemaining ){
                                    $args['posts_per_page'] = $foundPostsRemaining;
                                }
                            }
                        }
                        
                    }

                    $e = array('page' => $paged);

                    $cats = (isset($scMeta['pfp_categories']) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_categories']) : array());
                    $tags = (isset($scMeta['pfp_tags']) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tags']) : array());
                    $tools = (isset($scMeta['pfp_tools']) ? TLPpPro()->array_int_sanitization( $scMeta['pfp_tools']) : array());

                    $taxQ = array();
                    if (is_array($cats) && !empty($cats)) {
                        $taxQ[] = array(
                            'taxonomy' => TLPpPro()->taxonomies['category'],
                            'field'    => 'term_id',
                            'terms'    => $cats,
                        );
                    }
                    if (is_array($tags) && !empty($tags)) {
                        $taxQ[] = array(
                            'taxonomy' => TLPpPro()->taxonomies['tag'],
                            'field'    => 'term_id',
                            'terms'    => $tags,
                        );
                    }
                    if (is_array($tools) && !empty($tools)) {
                        $taxQ[] = array(
                            'taxonomy' => TLPpPro()->taxonomies['tool'],
                            'field'    => 'term_id',
                            'terms'    => $tools,
                        );
                    }
                    if (!empty($taxQ)) {
                        $args['tax_query'] = $itemIdsArgs['tax_query'] = $taxQ;
                        if (count($taxQ) > 1) {
                            $taxQ['relation'] = $itemIdsArgs['relation'] = !empty($scMeta['pfp_taxonomy_relation'][0]) ? sanitize_text_field( $scMeta['pfp_taxonomy_relation'][0] ) : "AND";
                        }
                    }
                    // Order
                    $order_by = (isset($scMeta['pfp_order_by'][0]) ? sanitize_text_field( $scMeta['pfp_order_by'][0] ) : null);
                    $order = (isset($scMeta['pfp_order'][0]) ? sanitize_text_field( $scMeta['pfp_order'][0] ) : null);
                    if ($order) {
                        $args['order'] = $order;
                    }
                    if ($order_by) {
                        $args['orderby'] = $order_by;
                    }
                    // Validation
                    $dCol = round(12 / $dCol);
                    $tCol = round(12 / $tCol);
                    $mCol = round(12 / $mCol);
                    if ($isCarousel) {
                        $dCol = $tCol = $mCol = 12;
                    }

                    $arg['grid'] = "pfp-col-md-{$dCol} pfp-col-sm-{$tCol} pfp-col-xs-{$mCol}";
                    $gridType = !empty($scMeta['pfp_grid_style'][0]) ? sanitize_text_field( $scMeta['pfp_grid_style'][0] ) : 'even';
                    $arg['class'] = $gridType . "-grid-item";
                    $arg['class'] .= " pfp-grid-item";
                    if ($isIsotope) {
                        $arg['class'] .= ' isotope-item';
                    }
                    if ($isCarousel) {
                        $arg['class'] .= ' pfp-carousel-item';
                    }
                    if ($gridType == "even") {
                        $arg['class'] .= ' even-grid-item';
                    } else if ($gridType == "masonry" && !$isIsotope && !$isCarousel) {
                        $arg['class'] .= ' masonry-grid-item';
                    }
                    $margin = !empty($scMeta['pfp_margin'][0]) ? sanitize_text_field( $scMeta['pfp_margin'][0] ) : 'default';
                    if ($margin == 'no') {
                        $arg['class'] .= ' no-margin';
                    }
                    // image shape will remove in future 
                    $image_shape = !empty($scMeta['pfp_image_shape'][0]) ? sanitize_text_field( $scMeta['pfp_image_shape'][0] ) : null;
                    if ($image_shape == 'circle') {
                        $arg['class'] .= ' pfp-img-circle';
                    }

                    $margin = !empty($scMeta['pfp_margin'][0]) ? sanitize_text_field( $scMeta['pfp_margin'][0] ) : 'default';
                    if ($margin == 'no') {
                        $arg['class'] .= ' no-margin';
                    } else {
                        $arg['class'] .= ' default-margin';
                    }

                    $arg['items'] = !empty($scMeta['pfp_item_fields']) ? TLPpPro()->array_text_sanitization( $scMeta['pfp_item_fields'] ) : array();
                    
                    $arg['anchorClass'] = null;
                    $link = !empty($scMeta['pfp_detail_page_link'][0]) ? true : false;
                    $arg['link'] = $arg['link_type'] = $arg['link_target'] = false;
                    if ($link) {
                        $link_type = $arg['link_type'] = !empty($scMeta['pfp_detail_page_link_type'][0]) ? sanitize_text_field( $scMeta['pfp_detail_page_link_type'][0] ) : 'popup';
                        if ($link_type == "popup") {
                            $arg['anchorClass'] .= ' pfp-popup tlp-single-item-popup';
                        } else if ($link_type == "external_link") {
                            $arg['link_target'] = !empty($scMeta['pfp_link_target'][0]) ? sanitize_text_field( $scMeta['pfp_link_target'][0] ) : '_blank';
                        }
                        $arg['link'] = true;
                    } else {
                        $arg['anchorClass'] .= ' pfp-disable';
                    }
                    $arg['zoomId'] = $layout;
                    $e['q'] = $args;

                    $args['post_status']      = 'publish';
                    if ( is_user_logged_in() && is_super_admin() ) {
                        $args['post_status'] = array( 'publish', 'private' );
                    }

                    
                    $portQuery = new WP_Query( $args );
                    // Start layout
                    if ($portQuery->have_posts()) {

                        while ($portQuery->have_posts()) {
                            $portQuery->the_post();

                            $iID = get_the_ID();
                            $arg['iID'] = $iID;
                            $arg['title'] = get_the_title();
                            $arg['client_name'] = get_post_meta($iID, 'client_name', true);
                            $arg['completed_date'] = get_post_meta($iID, 'completed_date', true);
                            $arg['short_desc'] = get_post_meta($iID, 'short_description', true);
                            $arg['short_desc'] = TLPpPro()->strip_tags_content($arg['short_desc'], $excerpt_limit);
                            $arg['project_url'] = get_post_meta($iID, 'project_url', true);
                            $arg['external_url'] = get_post_meta($iID, 'external_url', true);
                            $arg['tools'] = strip_tags(get_the_term_list($iID, TLPpPro()->taxonomies['tool'], null, ' | '));
                            $arg['categories'] = strip_tags(get_the_term_list($iID, TLPpPro()->taxonomies['category'], null, ','));
                            $arg['tags'] = strip_tags(get_the_term_list($iID, TLPpPro()->taxonomies['tag'], null, ','));
                            $arg['pLink'] = get_permalink();
                            if ($arg['link_type'] == "external_link" && $arg['external_url']) {
                                $arg['pLink'] = $arg['external_url'];
                            }
                            $imgUrl = wp_get_attachment_image_src(get_post_thumbnail_id($iID), 'full');;
                            $arg['img_full_url'] = (!empty($imgUrl) ? $imgUrl[0] : null);
                            $excerpt = get_the_excerpt();
                            $arg['excerpt'] = TLPpPro()->strip_tags_content($excerpt, $excerpt_limit);
                            if ($isIsotope) {
                                $termAs = wp_get_post_terms($iID, TLPpPro()->taxonomies['category'],
                                    array("fields" => "all"));
                                $isoFilter = null;
                                if (!empty($termAs)) {
                                    foreach ($termAs as $term) {
                                        $isoFilter .= " " . "iso_" . $term->term_id;
                                        $isoFilter .= " " . $term->slug;
                                    }
                                }
                                $arg['isoFilter'] = $isoFilter;
                            }
                            $arg['img'] = TLPpPro()->getFeatureImage($iID, $imgSize, $customImgSize);
                            $data .= TLPpPro()->render('layouts/' . $layout, $arg);

                        }
                        if (!empty($data)) {
                            $error = false;
                        }

                    } else {
                        $msg = esc_html__('No More Post to load', 'tlp-portfolio-pro');
                    }
                    wp_reset_postdata();

                } else {
                    $msg = esc_html__('No More Post to load', 'tlp-portfolio-pro');
                }
            } else {
                $msg = esc_html__('Something went wrong !!', 'tlp-portfolio-pro');
            }

            wp_send_json(array(
                'error' => $error,
                'msg'   => $msg,
                'data'  => $data,
                'e'     => $e
            ));
        }


    }

endif;