<?php
if (!class_exists('PFProInit')):
    /**
     *
     */
    class PFProInit {

        function __construct()
        {
            add_action('init', array(__CLASS__, 'init'), 999);
            add_action('admin_menu', array($this, 'pfp_menu_register'));
            add_action('wp_ajax_pfpSettingsUpdate', array($this, 'pfpSettingsUpdate'));
            add_action('wp_ajax_tlp_portfolio_img_remove', array($this, 'tlp_portfolio_img_remove'));
            add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'));
            register_activation_hook(TLP_PORTFOLIO_PRO_PLUGIN_ACTIVE_FILE_NAME, array($this, 'activate'));
            register_deactivation_hook(TLP_PORTFOLIO_PRO_PLUGIN_ACTIVE_FILE_NAME, array($this, 'deactivate'));
            add_action('plugins_loaded', array($this, 'plugin_loaded'));
            add_action( 'admin_init', array( $this, 'my_plugin_redirect' ) );
        }

        public function activate()
        {
            $this->flush_rewrite();
            $this->reGenerateCss();
            TLPpPro()->update_taxonomy_order();
            add_option( 'rtport_activation_redirect', true );
        }

		function my_plugin_redirect() {
			if ( get_option( 'rtport_activation_redirect', false ) ) {
				delete_option( 'rtport_activation_redirect' );
				wp_redirect( admin_url( 'edit.php?post_type=portfolio&page=tlp_portfolio_get_help' ) );
			}
		}

        function reGenerateCss() {
			$scPostIds = get_posts( array(
				'post_type'      => TLPpPro()->shortCodePT,
				'posts_per_page' => -1,
				'post_status'    => 'publish',
				'fields'         => 'ids'
			) );

			if ( is_array($scPostIds) && !empty($scPostIds) ) {
				foreach ($scPostIds as $scPostId) {
					TLPpPro()->generatorShortCodeCss( $scPostId );
				}
			}
			wp_reset_query();
		}

        public function flush_rewrite()
        {
            flush_rewrite_rules();
        }

        public function deactivate()
        {
            $this->flush_rewrite();
        }

        function tlp_portfolio_img_remove()
        {
            $success = false;
            $error = true;
            $post_ID = intval( $_REQUEST['post_ID'] ) ;
            $id = intval( $_REQUEST['id'] ) ;
            $pfp_nonce = sanitize_text_field( $_REQUEST['pfp_nonce'] ) ;
            if ($id && $post_ID && wp_verify_nonce( $pfp_nonce, TLPpPro()->nonceText() )
            ) {
                if (delete_post_meta($post_ID, 'tlp_portfolio_gallery', $id )) {
                    $success = true;
                    $error = false;
                }
            }
            wp_send_json(array('success' => $success, 'error' => $error));
        }

        public static function init()
        {
            $portfolio_args = array(
                'label'               => esc_html__('Portfolio Pro', 'tlp-portfolio-pro'),
                'labels'              => array(
                    'name'               => esc_html__('Portfolios', 'tlp-portfolio-pro'),
                    'all_items'          => esc_html__('All Portfolios', 'tlp-portfolio-pro'),
                    'singular_name'      => esc_html__('Portfolio', 'tlp-portfolio-pro'),
                    'menu_name'          => esc_html__('Portfolio Pro', 'tlp-portfolio-pro'),
                    'name_admin_bar'     => esc_html__('Portfolio Pro', 'tlp-portfolio-pro'),
                    'add_new'            => esc_html__('Add Portfolio', 'tlp-portfolio-pro'),
                    'add_new_item'       => esc_html__('Add Portfolio', 'tlp-portfolio-pro'),
                    'edit_item'          => esc_html__('Edit Portfolio', 'tlp-portfolio-pro'),
                    'new_item'           => esc_html__('New Portfolio', 'tlp-portfolio-pro'),
                    'view_item'          => esc_html__('View Portfolio', 'tlp-portfolio-pro'),
                    'search_items'       => esc_html__('Search Portfolio', 'tlp-portfolio-pro'),
                    'not_found'          => esc_html__('No Portfolios found', 'tlp-portfolio-pro'),
                    'not_found_in_trash' => esc_html__('No Portfolios in the trash', 'tlp-portfolio-pro'),
                ),
                'supports'            => array('title', 'editor', 'thumbnail', 'revisions', 'page-attributes'),
                'hierarchical'        => false,
                'public'              => true,
                'rewrite'             => array('slug' => TLPpPro()->post_type_slug),
                'show_ui'             => true,
                'show_in_menu'        => true,
				'menu_position'       => 20, // Keep it similer tike free version
                'menu_icon'           => TLPpPro()->assetsUrl . 'images/portfolio.png',
                'show_in_admin_bar'   => true,
                'show_in_nav_menus'   => false,
                'can_export'          => true,
                'has_archive'         => false,
                'exclude_from_search' => false,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                'show_in_rest'        => true
            );
            register_post_type(TLPpPro()->post_type, $portfolio_args);
            TLPpPro()->doFlush();

            $sc_args = array(
                'label'               => esc_html__('ShortCode', 'tlp-portfolio-pro'),
                'description'         => esc_html__('TLP Portfolio ShortCode generator', 'tlp-portfolio-pro'),
                'labels'              => array(
                    'all_items'          => esc_html__('ShortCode Generator', 'tlp-portfolio-pro'),
                    'menu_name'          => esc_html__('ShortCode', 'tlp-portfolio-pro'),
                    'singular_name'      => esc_html__('ShortCode', 'tlp-portfolio-pro'),
                    'edit_item'          => esc_html__('Edit ShortCode', 'tlp-portfolio-pro'),
                    'new_item'           => esc_html__('New ShortCode', 'tlp-portfolio-pro'),
                    'view_item'          => esc_html__('View ShortCode', 'tlp-portfolio-pro'),
                    'search_items'       => esc_html__('ShortCode Locations', 'tlp-portfolio-pro'),
                    'not_found'          => esc_html__('No ShortCode found.', 'tlp-portfolio-pro'),
                    'not_found_in_trash' => esc_html__('No ShortCode found in trash.', 'tlp-portfolio-pro')
                ),
                'supports'            => array('title'),
                'public'              => false,
                'rewrite'             => false,
                'show_ui'             => true,
                'show_in_menu'        => 'edit.php?post_type=' . TLPpPro()->post_type,
                'show_in_admin_bar'   => true,
                'show_in_nav_menus'   => false,
                'can_export'          => true,
                'has_archive'         => false,
                'exclude_from_search' => false,
                'publicly_queryable'  => false,
                'capability_type'     => 'page',
            );
            register_post_type(TLPpPro()->shortCodePT, $sc_args);


            $categoryArgs = array(
                'labels'            => array(
                    'name'                       => esc_html__('Categories', 'tlp-portfolio-pro'),
                    'singular_name'              => esc_html__('Category', 'tlp-portfolio-pro'),
                    'menu_name'                  => esc_html__('Categories', 'tlp-portfolio-pro'),
                    'edit_item'                  => esc_html__('Edit Category', 'tlp-portfolio-pro'),
                    'update_item'                => esc_html__('Update Category', 'tlp-portfolio-pro'),
                    'add_new_item'               => esc_html__('Add New Category', 'tlp-portfolio-pro'),
                    'new_item_name'              => esc_html__('New Category Name', 'tlp-portfolio-pro'),
                    'parent_item'                => esc_html__('Parent Category', 'tlp-portfolio-pro'),
                    'parent_item_colon'          => esc_html__('Parent Category:', 'tlp-portfolio-pro'),
                    'all_items'                  => esc_html__('All Categories', 'tlp-portfolio-pro'),
                    'search_items'               => esc_html__('Search Categories', 'tlp-portfolio-pro'),
                    'popular_items'              => esc_html__('Popular Categories', 'tlp-portfolio-pro'),
                    'separate_items_with_commas' => esc_html__('Separate categories with commas', 'tlp-portfolio-pro'),
                    'add_or_remove_items'        => esc_html__('Add or remove categories', 'tlp-portfolio-pro'),
                    'choose_from_most_used'      => esc_html__('Choose from the most used  categories', 'tlp-portfolio-pro'),
                    'not_found'                  => esc_html__('No categories found.', 'tlp-portfolio-pro'),
                ),
                'public'            => true,
                'show_in_nav_menus' => false,
                'show_ui'           => true,
                'show_tagcloud'     => true,
                'hierarchical'      => true,
                'show_admin_column' => true,
                'query_var'         => true,
                'show_in_rest'        => true
            );
            register_taxonomy(TLPpPro()->taxonomies['category'], TLPpPro()->post_type, $categoryArgs);

            $TagArgs = array(
                'labels'            => array(
                    'name'                       => esc_html__('Tags', 'tlp-portfolio-pro'),
                    'singular_name'              => esc_html__('Tag', 'tlp-portfolio-pro'),
                    'menu_name'                  => esc_html__('Tags', 'tlp-portfolio-pro'),
                    'edit_item'                  => esc_html__('Edit Tag', 'tlp-portfolio-pro'),
                    'update_item'                => esc_html__('Update Tag', 'tlp-portfolio-pro'),
                    'add_new_item'               => esc_html__('Add New Tag', 'tlp-portfolio-pro'),
                    'new_item_name'              => esc_html__('New Tag Name', 'tlp-portfolio-pro'),
                    'parent_item'                => esc_html__('Parent Tag', 'tlp-portfolio-pro'),
                    'parent_item_colon'          => esc_html__('Parent Tag', 'tlp-portfolio-pro'),
                    'all_items'                  => esc_html__('All Tags', 'tlp-portfolio-pro'),
                    'search_items'               => esc_html__('Search Tags', 'tlp-portfolio-pro'),
                    'popular_items'              => esc_html__('Popular Tags', 'tlp-portfolio-pro'),
                    'separate_items_with_commas' => esc_html__('Separate Tags with commas', 'tlp-portfolio-pro'),
                    'add_or_remove_items'        => esc_html__('Add or remove Tags', 'tlp-portfolio-pro'),
                    'choose_from_most_used'      => esc_html__('Choose from the most used Tags', 'tlp-portfolio-pro'),
                    'not_found'                  => esc_html__('No Tags found.', 'tlp-portfolio-pro'),
                ),
                'public'            => true,
                'show_in_nav_menus' => false,
                'show_ui'           => true,
                'show_tagcloud'     => true,
                'hierarchical'      => false,
                'show_admin_column' => true,
                'query_var'         => true,
                'show_in_rest'        => true
            );
            register_taxonomy(TLPpPro()->taxonomies['tag'], TLPpPro()->post_type, $TagArgs);


            $toolsArgs = array(
                'labels'            => array(
                    'name'                       => esc_html__('Tools', 'tlp-portfolio-pro'),
                    'singular_name'              => esc_html__('Tool', 'tlp-portfolio-pro'),
                    'menu_name'                  => esc_html__('Tools', 'tlp-portfolio-pro'),
                    'edit_item'                  => esc_html__('Edit Tool', 'tlp-portfolio-pro'),
                    'update_item'                => esc_html__('Update Tool', 'tlp-portfolio-pro'),
                    'add_new_item'               => esc_html__('Add New Tool', 'tlp-portfolio-pro'),
                    'new_item_name'              => esc_html__('New Tool Name', 'tlp-portfolio-pro'),
                    'parent_item'                => esc_html__('Parent Tool', 'tlp-portfolio-pro'),
                    'parent_item_colon'          => esc_html__('Parent Tool', 'tlp-portfolio-pro'),
                    'all_items'                  => esc_html__('All Tools', 'tlp-portfolio-pro'),
                    'search_items'               => esc_html__('Search Tools', 'tlp-portfolio-pro'),
                    'popular_items'              => esc_html__('Popular Tools', 'tlp-portfolio-pro'),
                    'separate_items_with_commas' => esc_html__('Separate Tools with commas', 'tlp-portfolio-pro'),
                    'add_or_remove_items'        => esc_html__('Add or remove Tools', 'tlp-portfolio-pro'),
                    'choose_from_most_used'      => esc_html__('Choose from the most used Tools', 'tlp-portfolio-pro'),
                    'not_found'                  => esc_html__('No Tools found.', 'tlp-portfolio-pro'),
                ),
                'public'            => true,
                'show_in_nav_menus' => false,
                'show_ui'           => true,
                'show_tagcloud'     => true,
                'hierarchical'      => false,
                'show_admin_column' => true,
                'query_var'         => true,
            );
            register_taxonomy(TLPpPro()->taxonomies['tool'], TLPpPro()->post_type, $toolsArgs);


            // register scripts
            $scripts = array();
            $styles = array();
            $scripts['pfp-owl-carousel'] = array(
                'src'    => TLPpPro()->assetsUrl . 'vendor/owl-carousel/owl.carousel.min.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp-flex-slider'] = array(
                'src'    => TLPpPro()->assetsUrl . 'vendor/FlexSlider/jquery.flexslider-min.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp-image-load'] = array(
                'src'    => TLPpPro()->assetsUrl . 'vendor/isotope/imagesloaded.pkgd.min.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp-isotope'] = array(
                'src'    => TLPpPro()->assetsUrl . 'vendor/isotope/isotope.pkgd.min.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp-lightbox'] = array(
                'src'    => TLPpPro()->assetsUrl . 'vendor/lightbox2/js/lightbox.min.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp-single'] = array(
                'src'    => TLPpPro()->assetsUrl . 'js/single-portfolio.js',
                'deps'   => array('jquery'),
                'footer' => true
            );
            $scripts['pfp'] = array(
                'src'    => TLPpPro()->assetsUrl . 'js/tlpportfolio.js',
                'deps'   => array('jquery'),
                'footer' => true
            );

            // register acf styles
            $styles['pfp-lightbox'] = TLPpPro()->assetsUrl . 'vendor/lightbox2/css/lightbox.min.css';
            $styles['pfp-owl-carousel'] = TLPpPro()->assetsUrl . 'vendor/owl-carousel/owl.carousel.min.css';
            $styles['pfp-owl-carousel-theme'] = TLPpPro()->assetsUrl . 'vendor/owl-carousel/owl.theme.default.min.css';
            $styles['pfp-flex-slider'] = TLPpPro()->assetsUrl . 'vendor/FlexSlider/flexslider.css';
            $styles['pfp-single'] = TLPpPro()->assetsUrl . 'css/single-portfolio.css';
            $styles['pfp'] = TLPpPro()->assetsUrl . 'css/tlpportfolio.css';

            if (is_admin()) {

                $scripts['ace-code-highlighter-js'] = array(
                    'src'    => TLPpPro()->assetsUrl . "vendor/ace/ace.js",
                    'deps'   => null,
                    'footer' => true
                );
                $scripts['ace-mode-js'] = array(
                    'src'    => TLPpPro()->assetsUrl . "vendor/ace/mode-css.js",
                    'deps'   => array('ace-code-highlighter-js'),
                    'footer' => true
                );

                $scripts['pfp-datepicker'] = array(
                    'src'    => TLPpPro()->assetsUrl . 'vendor/bootstrap-datepicker/bootstrap-datepicker.min.js',
                    'deps'   => array('jquery'),
                    'footer' => false
                );
                $scripts['pfp-select2'] = array(
                    'src'    => TLPpPro()->assetsUrl . 'vendor/select2/select2.min.js',
                    'deps'   => array('jquery'),
                    'footer' => false
                );
                $scripts['pfp-admin-preview'] = array(
                    'src'    => TLPpPro()->assetsUrl . 'js/admin-preview.js',
                    'deps'   => array('jquery'),
                    'footer' => false
                );
                $scripts['pfp-admin-taxonomy'] = array(
                    'src'    => TLPpPro()->assetsUrl . "js/admin-taxonomy.js",
                    'deps'   => array('jquery'),
                    'footer' => true
                );
                $scripts['pfp-admin'] = array(
                    'src'    => TLPpPro()->assetsUrl . "js/settings.js",
                    'deps'   => array('jquery'),
                    'footer' => true
                );
                $scripts['pfp-admin-sc'] = array(
                    'src'    => TLPpPro()->assetsUrl . "js/admin-sc.js",
                    'deps'   => array('jquery'),
                    'footer' => true
                );
                $styles['pfp-datepicker'] = TLPpPro()->assetsUrl . 'vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css';
                $styles['pfp-select2'] = TLPpPro()->assetsUrl . 'vendor/select2/select2.min.css';
                $styles['pfp-admin'] = TLPpPro()->assetsUrl . 'css/settings.css';
            }
            $version = (defined('WP_DEBUG') && WP_DEBUG) ? time() : TLP_PORTFOLIO_PRO_VERSION;
            foreach ($scripts as $handel => $script) {
                wp_register_script($handel, $script['src'], $script['deps'], $version, $script['footer']);
            }

            foreach ($styles as $k => $v) {
                wp_register_style($k, $v, false, $version);
            }

        }


        function pfpSettingsUpdate()
        {
            $error = true;
            if (TLPpPro()->verifyNonce()) {
                unset($_REQUEST['action']);
                unset($_REQUEST['_wp_http_referer']);
                unset($_REQUEST['pfp_nonce']);
                $mates = TLPpPro()->pfpAllSettingsFields();
                foreach ($mates as $key => $field) {
                    $rValue = !empty($_REQUEST[$key]) ? $_REQUEST[$key] : null;
                    $value = TLPpPro()->sanitize($field, $rValue);
                    $data[$key] = $value;
                }
                $settings = get_option(TLPpPro()->options['settings']);
                $request_slug = sanitize_text_field( $_REQUEST['slug'] );

                if (!empty($settings['slug']) && $request_slug && $settings['slug'] !== $request_slug ) {
                    update_option(TLPpPro()->options['flash'], true);
                }
                update_option(TLPpPro()->options['settings'], $data);
                $error = false;
                $response = array(
                    'error' => $error,
                    'msg'   => esc_html__('Settings successfully updated', 'tlp-portfolio-pro')
                );
            } else {
                $response = array(
                    'error' => true,
                    'msg'   => esc_html__('Something went wrong !!', 'tlp-portfolio-pro')
                );
            }
            wp_send_json($response);
            die();

        }


        function pfp_menu_register()
        {
            add_submenu_page('edit.php?post_type=portfolio', esc_html__('Taxonomy Order', 'tlp-portfolio-pro'),
                __('Taxonomy Order', 'tlp-portfolio-pro'), 'administrator', 'pfp_taxonomy_order',
                array($this, 'pfp_menu_page_taxonomy_order'));
            add_submenu_page('edit.php?post_type=portfolio', esc_html__('TLP Portfolio Settings', 'tlp-portfolio-pro'),
                __('Settings', 'tlp-portfolio-pro'), 'administrator', 'pfp_settings',
                array($this, 'pfp_menu_page_settings'));
            add_submenu_page('edit.php?post_type=portfolio', esc_html__('Get Help', 'tlp-portfolio-pro'),
                __('Get Help', 'tlp-portfolio-pro'), 'administrator', 'tlp_portfolio_get_help',
                array($this, 'tlp_port_get_help'));
        }

        function admin_enqueue_scripts()
        {
            global $pagenow, $typenow;
            // validate page

            if (!in_array($pagenow, array('post.php', 'post-new.php', 'edit.php'))) {
                return;
            }

            if ($typenow != TLPpPro()->post_type) {
                return;
            }
            $select2Id = 'pfp-select2';
//            if (class_exists('WPSEO_Admin_Asset_Manager') && class_exists('Avada')) {
//                $select2Id = 'yoast-seo-select2';
//            } elseif (class_exists('WPSEO_Admin_Asset_Manager')) {
//                $select2Id = 'yoast-seo-select2';
//            } elseif (class_exists('Avada')) {
//                $select2Id = 'select2-avada-js';
//            }
            // scripts
            wp_enqueue_script(array(
                'jquery',
                'wp-color-picker',
                'ace-code-highlighter-js',
                'ace-mode-js',
                'pfp-datepicker',
                $select2Id,
                'pfp-admin',
            ));

            // styles
            wp_enqueue_style(array(
                'wp-color-picker',
                'pfp-datepicker',
                'pfp-select2',
                'pfp-admin',
            ));


            wp_localize_script('pfp-admin', 'pfp', array(
                'nonce'           => wp_create_nonce(TLPpPro()->nonceText()),
                'nonceId'         => TLPpPro()->nonceId(),
                'tlp_date_format' => TLPpPro()->date_format_php_to_js()
            ));
        }


        function pfp_menu_page_settings()
        {
            TLPpPro()->render_view('settings');
        }

        function pfp_menu_page_taxonomy_order()
        {
            TLPpPro()->render_view('taxonomy-order');
        }

        function tlp_port_get_help()
        {
            TLPpPro()->render_view('help');
        }

        /**
         * Load the plugin text domain for translation.
         *
         * @since 0.1.0
         */
        public function plugin_loaded()
        {
            load_plugin_textdomain('tlp-portfolio-pro', false, TLP_PORTFOLIO_PRO_LANGUAGE_PATH);
            if (!get_option(TLPpPro()->options['settings'])) {
                update_option(TLPpPro()->options['settings'], TLPpPro()->preSettings);
            }
            TLPpPro()->update_taxonomy_order();
        }

    }
endif;
