<?php
if (!class_exists('PFProHelper')) :
    class PFProHelper
    {

        function verifyNonce() {

            $nonce = isset($_REQUEST[$this->nonceId()]) ? $_REQUEST[$this->nonceId()] : null;
            $nonceText = $this->nonceText();
            if (!wp_verify_nonce($nonce, $nonceText)) {
                return false;
            }

            return true;
        }

        function nonceText() {
            return "pfp_nonce_text";
        }

        /**
         * Nonce Id generation
         *
         * @return string
         */
        function nonceId() {
            return "pfp_nonce";
        }

        function pfpScMetaFields() {
            return array_merge(
                TLPpPro()->scLayoutMetaFields(),
                TLPpPro()->scFilterMetaFields(),
                TLPpPro()->scItemMetaFields(),
                TLPpPro()->scStyleFields());
        }

        function getAllPfpTaxonomyObject() {
            $taxonomy_objects = get_object_taxonomies(TLPpPro()->post_type, 'objects');
            $taxonomy_list = array();
            if (!empty($taxonomy_objects)) {
                foreach ($taxonomy_objects as $taxonomy) {
                    if (!in_array($taxonomy->name, array('language', 'post_translations'))) {
                        $taxonomy_list[] = $taxonomy;
                    }
                }
            }

            return $taxonomy_list;
        }

        function rtFieldGenerator($fields = array()) {
            $html = null;
            if (is_array($fields) && !empty($fields)) {
                $PFProField = new PFProField();
                foreach ($fields as $fieldKey => $field) {
                    $html .= $PFProField->Field($fieldKey, $field);
                }
            }

            return $html;
        }

        function pfpAllSettingsFields() {
            return array_merge(
                TLPpPro()->generalSettings(),
                TLPpPro()->detailFieldControl(),
                TLPpPro()->othersSettings(),
                TLPpPro()->rtPfpLicenceField()
            );
        }

        /**
         * Sanitize field value
         *
         * @param array $field
         * @param null  $value
         *
         * @return array|null
         * @internal param $value
         */
        function sanitize($field = array(), $value = null) {
            $newValue = null;
            if (is_array($field)) {
                $type = (!empty($field['type']) ? $field['type'] : 'text');
                if (empty($field['multiple'])) {
                    if ($type == 'text' || $type == 'number' || $type == 'select' || $type == 'checkbox' || $type == 'radio') {
                        $newValue = sanitize_text_field($value);
                    } else if ($type == 'price') {
                        $newValue = ('' === $value) ? '' : $value ;
                    } else if ($type == 'url') {
                        $newValue = esc_url($value);
                    } else if ($type == 'slug') {
                        $newValue = sanitize_title_with_dashes($value);
                    } else if ($type == 'textarea') {
                        $newValue = wp_kses_post($value);
                    } else if ($type == 'custom_css') {
                        $newValue = htmlentities(stripslashes($value));
                    } else if ($type == 'colorpicker') {
                        $newValue = $this->sanitize_hex_color($value);
                    } else if ($type == 'image_size') {
                        $newValue = array();
                        foreach ($value as $k => $v) {
                            $newValue[$k] = esc_attr($v);
                        }
                    } else if ($type == 'style') {
                        $newValue = array();
                        foreach ($value as $k => $v) {
                            if ($k == 'color') {
                                $newValue[$k] = $this->sanitize_hex_color($v);
                            } else {
                                $newValue[$k] = $this->sanitize(array('type' => 'text'), $v);
                            }
                        }
                    } else {
                        $newValue = sanitize_text_field($value);
                    }

                } else {
                    $newValue = array();
                    if (!empty($value)) {
                        if (is_array($value)) {
                            foreach ($value as $key => $val) {
                                if ($type == 'style' && $key == 0) {
                                    if (function_exists('sanitize_hex_color')) {
                                        $newValue = sanitize_hex_color($val);
                                    } else {
                                        $newValue[] = $this->sanitize_hex_color($val);
                                    }
                                } else {
                                    $newValue[] = sanitize_text_field($val);
                                }
                            }
                        } else {
                            $newValue[] = sanitize_text_field($value);
                        }
                    }
                }
            }

            return $newValue;
        }

        function sanitize_hex_color($color) {
            if (function_exists('sanitize_hex_color')) {
                return sanitize_hex_color($color);
            } else {
                if ('' === $color) {
                    return '';
                }

                // 3 or 6 hex digits, or the empty string.
                if (preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color)) {
                    return $color;
                }
            }
        }


        function getFeatureImage(
            $post_id = null,
            $fImgSize = 'medium',
            $customImgSize = array()
        ) {
            global $post;
            $img_class = "pfp-feature-img";
            $imgSrc = $image = null;
            $cSize = false;
            $post_id = ($post_id ? absint($post_id) : $post->ID);
            $alt = esc_attr(get_the_title($post_id));
            $thumb_id = get_post_thumbnail_id($post_id);
            if ($fImgSize == 'pfp_custom') {
                $fImgSize = 'full';
                $cSize = true;
            }
            if ($thumb_id) {
                $image = wp_get_attachment_image($thumb_id, $fImgSize, '', array("class" => $img_class));
                $imageS = wp_get_attachment_image_src($thumb_id, $fImgSize);
                $imgSrc = isset( $imageS[0] ) ? $imageS[0] : '';
            } else {
                $imgSrc = esc_url(TLPpPro()->placeholder_img_src());
                $image = "<img alt='{$alt}' class='{$img_class}' src='{$imgSrc}' />";
            }

            if ($imgSrc && $cSize) {
                $w = (!empty($customImgSize['width']) ? absint($customImgSize['width']) : null);
                $h = (!empty($customImgSize['height']) ? absint($customImgSize['height']) : null);
                $c = (!empty($customImgSize['crop']) && $customImgSize['crop'] == 'soft' ? false : true);
                if ($w && $h) {
                    $imgSrc = esc_url(TLPpPro()->rtImageReSize($imgSrc, $w, $h, $c));
                    if( $imgSrc ){
                        $image = "<img width='{$w}' height='{$h}' alt='{$alt}' class='{$img_class}' src='{$imgSrc}' />";
                    }
                }
            }

            return $image;
        }

        function rtImageReSize($url, $width = null, $height = null, $crop = null, $single = true, $upscale = false) {
            $rtResize = new PFProReSizer();

            return $rtResize->process($url, $width, $height, $crop, $single, $upscale);
        }

        function strip_tags_content($text, $limit = 0, $tags = '', $invert = false) {
            if ($limit) {
                preg_match_all('/<(.+?)[\s]*\/?[\s]*>/si', trim($tags), $tags);
                $tags = array_unique($tags[1]);

                if (is_array($tags) AND count($tags) > 0) {
                    if ($invert == false) {
                        $text = preg_replace('@<(?!(?:' . implode('|', $tags) . ')\b)(\w+)\b.*?>.*?</\1>@si', '',
                            $text);
                    } else {
                        $text = preg_replace('@<(' . implode('|', $tags) . ')\b.*?>.*?</\1>@si', '', $text);
                    }
                } else if ($invert == false) {
                    $text = preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $text);
                }
                if ($limit > 0 && strlen($text) > $limit) {
                    $text = substr($text, 0, $limit);
                }
            }

            return $text;
        }

        function getAllPortFolioCategoryList() {
            $terms = array();
            $termList = get_terms(array(TLPpPro()->taxonomies['category']), array('hide_empty' => 0));
            if (is_array($termList) && !empty($termList) && empty($termList['errors'])) {
                foreach ($termList as $term) {
                    $terms[$term->term_id] = $term->name;
                }
            }

            return $terms;
        }

        function getAllPortFolioTagList() {
            $terms = array();
            $termList = get_terms(array(TLPpPro()->taxonomies['tag']), array('hide_empty' => 0));
            if (is_array($termList) && !empty($termList) && empty($termList['errors'])) {
                foreach ($termList as $term) {
                    $terms[$term->term_id] = $term->name;
                }
            }

            return $terms;
        }

        function getAllPortFolioToolList() {
            $terms = array();
            $termList = get_terms(array(TLPpPro()->taxonomies['tool']), array('hide_empty' => 0));
            if (is_array($termList) && !empty($termList) && empty($termList['errors'])) {
                foreach ($termList as $term) {
                    $terms[$term->term_id] = $term->name;
                }
            }

            return $terms;
        }


        function getPortfolioList() {
            $portfolios = array();
            $portQ = new WP_Query(array(
                'post_type'      => TLPpPro()->post_type,
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC'
            ));
            if ($portQ->have_posts()) {
                while ($portQ->have_posts()) {
                    $portQ->the_post();
                    $portfolios[get_the_ID()] = get_the_title();
                }
            }
            wp_reset_postdata();

            return $portfolios;
        }

        function getPortfolioListExceptId($id = null) {
            $id = ($id ? intval($id) : get_the_ID());
            $portfolios = array();

            if ($id) {
                $portQ = get_posts(array(
                    'post_type'      => TLPpPro()->post_type,
                    'post_status'    => 'publish',
                    'posts_per_page' => -1,
                    'orderby'        => 'title',
                    'post__not_in'   => array($id),
                    'order'          => 'ASC'
                ));
                if (!empty($portQ)) {
                    foreach ($portQ as $port) {
                        $portfolios[$port->ID] = $port->post_title;
                    }
                }
            }

            return $portfolios;
        }

        function date_format_php_to_js() {
            $sFormat = get_option('date_format');
            switch ($sFormat) {
                //Predefined WP date formats
                case 'F j, Y':
                    return ('MM dd, yyyy');
                    break;
                case 'Y/m/d':
                    return ('yyyy/mm/dd');
                    break;
                case 'm/d/Y':
                    return ('mm/dd/yyyy');
                    break;
                case 'd/m/Y':
                    return ('dd/mm/yyyy');
                    break;
                default:
                    return ('dd-mm-yyyy');
                    break;
            }
        }

        function TLPhex2rgba($color, $opacity = false) {
            $default = 'rgb(0,0,0)';

            //Return default if no color provided
            if (empty($color)) {
                return $default;
            }

            //Sanitize $color if "#" is provided
            if ($color[0] == '#') {
                $color = substr($color, 1);
            }

            //Check if color has 6 or 3 characters and get values
            if (strlen($color) == 6) {
                $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
            } elseif (strlen($color) == 3) {
                $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
            } else {
                return $default;
            }

            //Convert hexadec to rgb
            $rgb = array_map('hexdec', $hex);

            //Check if opacity is set(rgba or rgb)
            if ($opacity) {
                if (abs($opacity) > 1) {
                    $opacity = 1.0;
                }
                $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
            } else {
                $output = 'rgb(' . implode(",", $rgb) . ')';
            }

            //Return rgb(a) color string
            return $output;
        }

        function tlp_custom_pagination($numpages = '', $pagerange = '', $paged = '') {

            if (empty($pagerange)) {
                $pagerange = 2;
            }
            global $paged;
            if (empty($paged)) {
                $paged = 1;
            }
            if ($numpages == '') {
                global $wp_query;
                $numpages = $wp_query->max_num_pages;
                if (!$numpages) {
                    $numpages = 1;
                }
            }

            /**
             * We construct the pagination arguments to enter into our paginate_links
             * function.
             */
            $pagination_args = array(
                'base'               => get_pagenum_link(1) . '%_%',
                'format'             => 'page/%#%',
                'total'              => $numpages,
                'current'            => $paged,
                'show_all'           => false,
                'end_size'           => 1,
                'mid_size'           => $pagerange,
                'prev_next'          => true,
                'prev_text'          => __('&laquo;'),
                'next_text'          => __('&raquo;'),
                'type'               => 'list',
                'add_args'           => false,
                'add_fragment'       => '',
                'before_page_number' => '',
                'after_page_number'  => ''
            );

            $paginate_links = paginate_links($pagination_args);
            $html = null;
            if ($paginate_links) {
                $html .= "<nav class='tlp-pagination'>";
                $html .= $paginate_links;
                $html .= "</nav>";
            }

            return $html;

        }

        function pagination($pages = '', $range = 4, $ajax = false, $scID = '') {

            $html = null;
            $showitems = $ajax ? $pages : ($range * 2) + 1;
            global $paged;
            if ( is_front_page() ) {
                $paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
            } else {
                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
            }
            if (empty($paged)) {
                $paged = 1;
            }
            if ($pages == '') {
                global $wp_query;
                $pages = $wp_query->max_num_pages;
                if (!$pages) {
                    $pages = 1;
                }
            }
            $ajaxClass = null;
            $dataAttr = null;

            if ($ajax) {
                $ajaxClass = ' pfp-ajax';
                $dataAttr = "data-sc-id='{$scID}' data-paged='1'";
            }

            if (1 != $pages) {

                $html .= '<div class="pfp-pagination' . $ajaxClass . '" ' . $dataAttr . '>';
                $html .= '<ul class="pagination-list">';
                if ($paged > 2 && $paged > $range + 1 && $showitems < $pages) {
                    $html .= "<li><a data-paged='1' href='" . get_pagenum_link(1) . "' aria-label='First'>&laquo;</a></li>";
                }

                if ($paged > 1 && $showitems < $pages) {
                    $p = $paged - 1;
                    $html .= "<li><a data-paged='{$p}' href='" . get_pagenum_link($p) . "' aria-label='Previous'>&lsaquo;</a></li>";
                }


                for ($i = 1; $i <= $pages; $i++) {
                    if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems)) {
                        $html .= ($paged == $i) ? "<li class=\"active\"><span>" . $i . "</span>

                        </li>" : "<li><a data-paged='{$i}' href='" . get_pagenum_link($i) . "'>" . $i . "</a></li>";

                    }

                }

                if ($paged < $pages && $showitems < $pages) {
                    $p = $paged + 1;
                    $html .= "<li><a data-paged='{$p}' href=\"" . get_pagenum_link($paged + 1) . "\"  aria-label='Next'>&rsaquo;</a></li>";
                }

                if ($paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages) {
                    $html .= "<li><a data-paged='{$pages}' href='" . get_pagenum_link($pages) . "' aria-label='Last'>&raquo;</a></li>";
                }

                $html .= "</ul>";
                $html .= "</div>";
            }

            return $html;

        }

        function rt_pagination($pages = '', $range = 4) {

            $html = null;
            $showitems = ($range * 2) + 1;
            global $paged;
            if (empty($paged)) {
                $paged = 1;
            }
            if ($pages == '') {
                global $wp_query;
                $pages = $wp_query->max_num_pages;
                if (!$pages) {
                    $pages = 1;
                }
            }

            if (1 != $pages) {

                $html .= '<div class="rt-pagination">';
                $html .= '<ul class="pagination"><li class="disabled hidden-xs"><span><span aria-hidden="true">Page ' . $paged . ' of ' . $pages . '</span></span></li>';

                if ($paged > 2 && $paged > $range + 1 && $showitems < $pages) {
                    $html .= "<li><a href='" . get_pagenum_link(1) . "' aria-label='First'>&laquo;<span class='hidden-xs'> First</span></a></li>";
                }

                if ($paged > 1 && $showitems < $pages) {
                    $html .= "<li><a href='" . get_pagenum_link($paged - 1) . "' aria-label='Previous'>&lsaquo;<span class='hidden-xs'> Previous</span></a></li>";
                }


                for ($i = 1; $i <= $pages; $i++) {
                    if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems)) {
                        $html .= ($paged == $i) ? "<li class=\"active\"><span>" . $i . "</span>

                        </li>" : "<li><a href='" . get_pagenum_link($i) . "'>" . $i . "</a></li>";

                    }

                }

                if ($paged < $pages && $showitems < $pages) {
                    $html .= "<li><a href=\"" . get_pagenum_link($paged + 1) . "\"  aria-label='Next'><span class='hidden-xs'>Next </span>&rsaquo;</a></li>";
                }

                if ($paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages) {
                    $html .= "<li><a href='" . get_pagenum_link($pages) . "' aria-label='Last'><span class='hidden-xs'>Last </span>&raquo;</a></li>";
                }

                $html .= "</ul>";
                $html .= "</div>";
            }

            return $html;

        }

        function placeholder_img_src() {
            return TLPpPro()->assetsUrl . 'images/placeholder.png';
        }

        function get_image_sizes() {
            global $_wp_additional_image_sizes;

            $sizes = array();
            foreach (get_intermediate_image_sizes() as $_size) {
                if (in_array($_size, array('thumbnail', 'medium', 'large'))) {
                    $sizes[$_size]['width'] = get_option("{$_size}_size_w");
                    $sizes[$_size]['height'] = get_option("{$_size}_size_h");
                    $sizes[$_size]['crop'] = (bool)get_option("{$_size}_crop");
                } elseif (isset($_wp_additional_image_sizes[$_size])) {
                    $sizes[$_size] = array(
                        'width'  => $_wp_additional_image_sizes[$_size]['width'],
                        'height' => $_wp_additional_image_sizes[$_size]['height'],
                        'crop'   => $_wp_additional_image_sizes[$_size]['crop'],
                    );
                }
            }

            $imgSize = array(
				'' => __( 'Select One', 'tlp-portfolio-pro' )
			);
            foreach ($sizes as $key => $img) {
                $imgSize[$key] = ucfirst($key) . " ({$img['width']}*{$img['height']})";
            }
            $imgSize['pfp_custom'] = __("Custom image size", "tlp-portfolio-pro");

            return $imgSize;
        }

        function singleMeta($id = null) {
            $id = (!$id ? get_the_ID() : $id);
            if (!$id) {
                return;
            }

            $client_name = get_post_meta($id, 'client_name', true);
            $completed_date = get_post_meta($id, 'completed_date', true);
            $project_url = get_post_meta($id, 'project_url', true);
            $tools = strip_tags(get_the_term_list($id, 'portfolio-tool', '' , ' | '));
            $categories = strip_tags(get_the_term_list($id, 'portfolio-category', '', ', '));
            $tags = strip_tags(get_the_term_list($id, 'portfolio-tag', '', ', '));
            $html = null;
            $settings = get_option(TLPpPro()->options['settings']);
            $field = (isset($settings['field']) ? $settings['field'] : array());
            $project_url_text = (isset($settings['project_url_text']) ? $settings['project_url_text'] : __("Click to View", 'tlp-portfolio-pro'));
            $project_url_target = (isset($settings['project_url_target']) && !empty($settings['project_url_target']) ? "_blank" : "_self");
            $html .= '<ul class="single-item-meta">';
            if (in_array('client_name', $field) && $client_name) {
                $html .= '<li><label>' . __('Client: ', "tlp-portfolio-pro") . '</label><span>' .esc_html($client_name) . '</span></li>';
            }
            if (in_array('completed_date', $field) && $completed_date) {
                $html .= '<li><label>' . __('Completed Date: ', "tlp-portfolio-pro") . '</label><span>' . esc_html($completed_date) . '</span></li>';
            }
            if (in_array('project_url', $field) && $project_url) {
                $html .= '<li><label>' . __('Project URL: ',
                        "tlp-portfolio-pro") . '</label>' . '<a  href="' . esc_url($project_url) . '" target="' . esc_attr($project_url_target) . '" >' . esc_html($project_url_text) . '</a></li>';
            }
            if (in_array('tools', $field) && $tools) {
                $html .= '<li class="tools"><label>' . __('Tools: ', "tlp-portfolio-pro") .'</label><span>'. esc_html($tools) . '</span></li>';
            }
            if (in_array('categories', $field) && $categories) {
                $html .= '<li class="categories"><label>'. __('Categories: ', "tlp-portfolio-pro") . '</label><span>' . esc_html( $categories ) . '</span></li>';
            }
            if (in_array('tags', $field) && $tags) {
                $html .= '<li class="tags"><label>' . __('Tags: ', "tlp-portfolio-pro").'</label><span>'. esc_html( $tags ) . '</span></li>';
            }
            $html .= "</ul>";

            return wp_kses_post( $html );
        }

        function pfpGallery($id = null) {
            $settings = get_option(TLPpPro()->options['settings']);
            $field = (!empty($settings['field']) ? $settings['field'] : array());
            $id = (!$id ? get_the_ID() : absint($id));
            if (!$id) {
                return;
            }
            $image_ids = get_post_meta($id, 'tlp_portfolio_gallery');
            if (!in_array('exclude_feature_image', $field) && $fID = get_post_thumbnail_id($id)) {
                array_unshift($image_ids, $fID);
            }
            $html = $thumbnails = $slides = null;
            if (!empty($image_ids) && is_array($image_ids)) {
                $slide = $thumbnail = null;
                foreach ($image_ids as $id) {
                    $has_image_url = wp_get_attachment_url($id, 'full');
                    if( $has_image_url ){ // Checking for flexslider unexpected behavior
                        $slide .= "<li class='pfp-slide'><a class='pfp-zoom' data-lightbox='image_id_".$id."' data-title='' href='".$has_image_url."'> " . wp_get_attachment_image($id,
                                'full') . "</a></li>";
                        $thumbnail .= "<li class='pfp-slide-thumb'>" . wp_get_attachment_image($id,
                                'thumbnail') . "</li>";
                    }
                }
                if (in_array('thumbnail_slider', $field)) {
                    $thumbnails = "<div id='carousel' class='flexslider'><ul class='slides'>{$thumbnail}</ul></div>";
                }

                if (in_array('slider', $field)) {
                    $slides = "<div id='slider' class='flexslider'><ul class='slides'>{$slide}</ul></div>";
                }
            }
            if ($slides) {
                $html = '<div id="pfp-gallery-wrapper" data-title="' . __("Loading ...",
                        "tlp-portfolio-pro") . '" class="pfp-pre-loader">' . $slides . $thumbnails . '</div>';
            }

            return $html;
        }

        function relatedProject($id = null) {
            $id = (!$id ? get_the_ID() : $id);
            if (!$id) {
                return;
            }

            $html = null;
            $relatedIds = get_post_meta($id, 'related_project');
            if (!empty($relatedIds)) {
                $posts = get_posts(
                    array(
                        'post_type'      => TLPpPro()->post_type,
                        'post_status'    => 'publish',
                        'posts_per_page' => -1,
                        'orderby'        => 'title',
                        'order'          => 'ASC',
                        'post__in'       => $relatedIds
                    )
                );

                if (is_array($posts) && !empty($posts)) {
                    $html .= "<div class='pfp-related-holder pfp-col-lg-12 pfp-col-md-12 pfp-col-sm-12 pfp-col-xs-12'>";
                    $html .= '<h2>'. __("Related Project(s)",
                        "tlp-portfolio-pro") . '</h2>';
                    $html .= "<div class='pfp-row align-items-start'>";
                    foreach ($posts as $post) {
                        $html .= "<div class='pfp-related-item pfp-col-md-4 pfp-col-sm-6 pfp-col-xs-12'>";
                        $html .= get_the_post_thumbnail($post->ID, 'medium');
                        $html .= "<h3><a href='" . get_the_permalink($post->ID) . "'>{$post->post_title}</a></h3>";
                        $html .= "</div>";
                    }
                    $html .= "</div>";
                    $html .= "</div>";
                }
            }

            return $html;

        }

        function get_shortCode_list() {
	        $scList = array();
	        $scQ    = get_posts( array(
		        'post_type'      => TLPpPro()->shortCodePT,
		        'order_by'       => 'title',
		        'order'          => 'ASC',
		        'post_status'    => 'publish',
		        'posts_per_page' => - 1
	        ) );
	        if ( ! empty( $scQ ) ) {
		        $scList = wp_list_pluck( $scQ, 'post_title', 'ID' );
	        }

	        return $scList;
        }

        function socialShare($pLink) {
            $html = null;
            $html .= "<div class='single-portfolio-share'>
                        <div class='fb-share'>
                            <div class='fb-share-button' data-href='{$pLink}' data-layout='button_count'></div>
                        </div>
                        <div class='twitter-share'>
                            <a href='{$pLink}' class='twitter-share-button'{count} data-url='https://about.twitter.com/resources/buttons#tweet'>Tweet</a>
                        </div>
                        <div class='googleplus-share'>
                            <div class='g-plusone'></div>
                        </div>
                        <div class='linkedin-share'>
                            <script type='IN/Share' data-counter='right'></script>
                        </div>
                        <div class='linkedin-share'>
                            <a data-pin-do='buttonPin' data-pin-count='beside' href='https://www.pinterest.com/pin/create/button/?url=https%3A%2F%2Fwww.flickr.com%2Fphotos%2Fkentbrew%2F6851755809%2F&media=https%3A%2F%2Ffarm8.staticflickr.com%2F7027%2F6851755809_df5b2051c9_z.jpg&description=Next%20stop%3A%20Pinterest'><img src='//assets.pinterest.com/images/pidgets/pinit_fg_en_rect_gray_20.png' /></a>
                        </div>
                   </div>";
            $html .= '<div id="fb-root"></div>
            <script>(function(d, s, id) {
                var js, fjs = d.getElementsByTagName(s)[0];
                    if (d.getElementById(id)) return;
                    js = d.createElement(s); js.id = id;
                    js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5";
                    fjs.parentNode.insertBefore(js, fjs);
                }(document, "script", "facebook-jssdk"));</script>';
            $html .= "<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
            <script>window.___gcfg = { lang: 'en-US', parsetags: 'onload', };</script>";
            $html .= "<script src='https://apis.google.com/js/platform.js' async defer></script>";
            $html .= '<script src="//platform.linkedin.com/in.js" type="text/javascript"> lang: en_US</script>';
            $html .= '<script async defer src="//assets.pinterest.com/js/pinit.js"></script>';

            return $html;
        }

        function doFlush() {
            if (get_option(TLPpPro()->options['flash'])) {
                TLPpPro()->flush_rewrite();
                update_option(TLPpPro()->options['flash'], false);
            }
        }

        function meta_exist($post_id, $meta_key, $type = "post") {
            if (!$post_id) {
                return false;
            }

            return metadata_exists($type, $post_id, $meta_key);
        }


        /**
         * A custom sanitization function that will take the incoming input, and sanitize
         * the input before handing it back to WordPress to save to the database and The output of frontend.
         *
         * @since    1.0.0
         *
         * @param    array    $input  Array value string .
         * @return   array.
         */
        function array_text_sanitization( $input ) {
            $input = maybe_unserialize( $input ) ;
            return !empty( $input ) ? array_map( 'sanitize_text_field', array_filter( $input ) ) : array();
        }

        /**
         * A custom sanitization function that will take the incoming input, and sanitize
         * the input before handing it back to WordPress to save to the database and The output of frontend.
         *
         * @since    1.0.0
         *
         * @param    array    $input  Array with integer value  .
         * @return   array.
         */
        function array_int_sanitization( $input ) {
            $input = maybe_unserialize( $input ) ;
            return !empty( $input ) ? array_map( 'absint', array_filter( $input ) ) : array();
        }


    }
endif;
