<?php

if ( ! class_exists( 'PFPortSCMeta' ) ):
	/**
	 *
	 */
	class PFPortSCMeta {

		function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'pfp_sc_meta_boxes' ) );
			add_action( 'save_post', array( $this, 'save_port_sc_meta_data' ), 10, 2 );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts_sc' ) );
			add_action( 'edit_form_after_title', array( $this, 'portfolio_sc_after_title' ) );

			add_action( 'admin_init', array( $this, 'remove_all_meta_box' ) );
		}

		function remove_all_meta_box() {
			if ( is_admin() ) {
				add_filter( "get_user_option_meta-box-order_{TLPpPro()->shortCodePT}",
					array( $this, 'remove_all_meta_boxes_portfolio_sc' ) );
			}
		}

		function remove_all_meta_boxes_portfolio_sc() {
			global $wp_meta_boxes;
			$publishBox                              = $wp_meta_boxes[ TLPpPro()->shortCodePT ]['side']['core']['submitdiv'];
			$scBox                                   = $wp_meta_boxes[ TLPpPro()->shortCodePT ]['normal']['high']['pfp_sc_settings_meta'];
			$scPreviewBox                            = $wp_meta_boxes[ TLPpPro()->shortCodePT ]['normal']['high']['pfp_sc_preview_meta'];
			$wp_meta_boxes[ TLPpPro()->shortCodePT ] = array(
				'side'   => array( 'core' => array( 'submitdiv' => $publishBox ) ),
				'normal' => array(
					'high' => array(
						'pfp_sc_settings_meta' => $scBox,
						'pfp_sc_preview_meta'  => $scPreviewBox
					)
				)
			);

			return array();
		}

		function portfolio_sc_after_title( $post ) {
			if ( TLPpPro()->shortCodePT !== $post->post_type ) {
				return;
			}
			?>
			<div class="postbox" style="margin-bottom: 0;">
				<div class="inside">
					<p><input type="text" onfocus="this.select();" readonly="readonly" value="[tlpportfolio id=&quot;<?php echo absint( $post->ID);?>&quot; title=&quot;<?php echo esc_html( $post->post_title ); ?>&quot;]" class="large-text code tlp-code-sc">
					<input type="text" onfocus="this.select();" readonly="readonly" value="&#60;&#63;php echo do_shortcode( &#39;[tlpportfolio id=&quot;<?php echo absint( $post->ID);?>&quot; title=&quot;<?php echo esc_html( $post->post_title ); ?>&quot;]&#39; ) &#63;&#62;" class="large-text code tlp-code-sc">
					</p>
				</div>
			</div>
			<?php

		}

		function pfp_sc_meta_boxes() {
			add_meta_box(
				'pfp_sc_settings_meta',
				__( 'Short Code Generator', 'tlp-portfolio-pro' ),
				array( $this, 'tlp_port_sc_settings_selection' ),
				TLPpPro()->shortCodePT,
				'normal',
				'high' );

			add_meta_box(
				'pfp_sc_preview_meta',
				__( 'Layout Preview', 'tlp-portfolio-pro' ),
				array( $this, 'pfp_sc_preview_selection' ),
				TLPpPro()->shortCodePT,
				'normal',
				'high' );
			add_meta_box(

				'rt_plugin_portfolio_sc_pro_information',
				__( 'Pro Documentation', 'tlp-portfolio' ),
				array( $this, 'rt_plugin_portfolio_sc_pro_information' ),
				TLPpPro()->shortCodePT,
				'side' );
		}

		function rt_plugin_portfolio_sc_pro_information() {
			?>
			<div class="rt-document-box">
				<div class="rt-box-icon"><i class="dashicons dashicons-media-document"></i></div>
				<div class="rt-box-content">
					<h3 class="rt-box-title">Documentation</h3>
						<p>Get started by spending some time with the documentation we included step by step process with screenshots with video.</p>
						<a href="https://www.radiustheme.com/how-to-setup-and-configure-tlp-portfolio-pro-for-wordpress/" target="_blank" class="rt-admin-btn">Documentation</a>
				</div>
			</div>

			<div class="rt-document-box">
				<div class="rt-box-icon"><i class="dashicons dashicons-sos"></i></div>
				<div class="rt-box-content">
					<h3 class="rt-box-title">Need Help?</h3>
					<p>Stuck with something? Please create a 
					<a href="https://www.radiustheme.com/contact/">ticket here</a> or post on <a href="https://www.facebook.com/groups/234799147426640/">facebook group</a>. For emergency case join our <a href="https://www.radiustheme.com/">live chat</a>.</p>
					<a href="https://www.radiustheme.com/contact/" target="_blank" class="rt-admin-btn">Get Support</a>
				</div>
			</div>

			<?php
		}

		function tlp_port_sc_settings_selection() {
			wp_nonce_field( TLPpPro()->nonceText(), TLPpPro()->nonceId() );
			// $html = null;
			?>
			<div id="sc-tabs" class="rt-tabs rt-tab-container">
				<ul class="tab-nav rt-tab-nav">
					<li>
						<a href="#sc-layout-settings"><i class="dashicons dashicons-layout"></i>
							<?php esc_html_e( 'Layout', 'tlp-portfolio-pro' ) ; ?>
						</a>
					</li>
					<li>
						<a href="#sc-filtering"><i class="dashicons dashicons-filter"></i>
							<?php esc_html_e( 'Filtering', 'tlp-portfolio-pro' ); ?>
						</a>
					</li>
					<li>
						<a href="#sc-field-selection"><i class="dashicons dashicons-editor-table"></i>
							<?php esc_html_e( 'Field Selection', 'tlp-portfolio-pro' ) ;?>
						</a>
					</li>
					<li>
						<a href="#sc-style"><i class="dashicons dashicons-admin-customizer"></i>
							<?php esc_html_e( 'Styling', 'tlp-portfolio-pro' ); ?>
						</a>
					</li>
				</ul>
				<div id="sc-layout-settings" class="rt-tab-content">
					<div class="tab-content">
						<?php echo TLPpPro()->rtFieldGenerator( TLPpPro()->scLayoutMetaFields() ); ?>
					</div>
				</div>
				<div id="sc-filtering" class="rt-tab-content">
					<div class="tab-content">
						<?php echo TLPpPro()->rtFieldGenerator( TLPpPro()->scFilterMetaFields() ); ?>
					</div>
				</div>
				<div id="sc-field-selection" class="rt-tab-content">
					<div class="tab-content">
						<?php echo TLPpPro()->rtFieldGenerator( TLPpPro()->scItemMetaFields() ); ?>
					</div>
				</div>
				<div id="sc-style" class="rt-tab-content">
					<div class="tab-content">
						<?php echo TLPpPro()->rtFieldGenerator( TLPpPro()->scStyleFields() ); ?>
					</div>
				</div>
			</div>
			<!-- echo $html; -->
			<?php
		}

		function pfp_sc_preview_selection() {
			?>
				<div class='pfp-response'><span class='spinner'></span></div>
				<div id='pfp-preview-container'></div>
			<?php
		}

		function save_port_sc_meta_data( $post_id, $post ) {

			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			if ( ! TLPpPro()->verifyNonce() ) {
				return $post_id;
			}

			if ( TLPpPro()->shortCodePT != $post->post_type ) {
				return $post_id;
			}

			$mates = TLPpPro()->pfpScMetaFields();
			delete_post_meta( $post_id, 'pfp_carousel_items_per_slider' ); // old version unuse meta field.
			foreach ( $mates as $metaKey => $field ) {
				$rValue = ! empty( $_REQUEST[ $metaKey ] ) ? $_REQUEST[ $metaKey ] : null;
				$value  = TLPpPro()->sanitize( $field, $rValue );
				if ( empty( $field['multiple'] ) ) {
					update_post_meta( $post_id, $metaKey, $value );
				} else {
					delete_post_meta( $post_id, $metaKey );
					if ( is_array( $value ) && ! empty( $value ) ) {
						foreach ( $value as $item ) {
							add_post_meta( $post_id, $metaKey, $item );
						}
					} else {
						update_post_meta( $post_id, $metaKey, "" );
					}
				}
			}

			$this->generatorShortCodeCss( $post_id );

		}

		function admin_enqueue_scripts_sc() {
			global $pagenow, $typenow;
			// validate page
			if ( ! in_array( $pagenow, array( 'post.php', 'post-new.php', 'edit.php' ) ) ) {
				return;
			}

			if ( $typenow != TLPpPro()->shortCodePT ) {
				return;
			}
			$select2Id = 'pfp-select2';
//			if ( class_exists( 'WPSEO_Admin_Asset_Manager' ) && class_exists( 'Avada' ) ) {
//				$select2Id = 'yoast-seo-select2';
//			} elseif ( class_exists( 'WPSEO_Admin_Asset_Manager' ) ) {
//				$select2Id = 'yoast-seo-select2';
//			} elseif ( class_exists( 'Avada' ) ) {
//				$select2Id = 'select2-avada-js';
//			}

			wp_enqueue_media();
			// scripts
			wp_enqueue_script( array(
				'jquery',
				'wp-color-picker',
				$select2Id,
				'pfp-owl-carousel',
				'pfp-image-load',
				'pfp-isotope',
				'pfp-admin-preview',
				'pfp-admin-sc',
				'pfp-admin',
			) );

			// styles
			wp_enqueue_style( array(
				'wp-color-picker',
				'pfp-select2',
				'pfp-owl-carousel',
				'pfp-owl-carousel-theme',
				'pfp-admin',
				'pfp',
			) );

			wp_localize_script( 'pfp-admin', 'pfp', array(
				'ajaxurl'         => admin_url( 'admin-ajax.php ' ),
				'nonce'           => wp_create_nonce( TLPpPro()->nonceText() ),
				'nonceId'         => TLPpPro()->nonceId(),
				'tlp_date_format' => TLPpPro()->date_format_php_to_js()
			) );
		}
		
		function generatorShortCodeCss($scID) {
					
            global $wp_filesystem;
            // Initialize the WP filesystem, no more using 'file-put-contents' function
            if ( empty($wp_filesystem) ) {
                require_once (ABSPATH . '/wp-admin/includes/file.php');
                WP_Filesystem();
            }
			$upload_dir = wp_upload_dir(); 
			$upload_basedir = $upload_dir['basedir'] ;
            $cssFile = $upload_basedir . '/tlp-portfolio/portfolio-sc.css'; 
            if ( $css = TLPpPro()->render('portfolio-sc-css', compact('scID'), true) ) { 
                $css = sprintf('/*sc-%2$d-start*/%1$s/*sc-%2$d-end*/', $css, $scID);
                if ( file_exists($cssFile) && ($oldCss = $wp_filesystem->get_contents($cssFile)) ) {
                    if ( strpos($oldCss, '/*sc-' . $scID . '-start') !== false ) {
                        $oldCss = preg_replace('/\/\*sc-' . $scID . '-start[\s\S]+?sc-' . $scID . '-end\*\//', '', $oldCss);
                        $oldCss = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "", $oldCss);
                    }
                    $css = $oldCss . $css;				
                } else if ( ! file_exists( $cssFile ) ) {
					$upload_basedir_trailingslashit = trailingslashit( $upload_basedir ); 
					$wp_filesystem->mkdir( $upload_basedir_trailingslashit. 'tlp-portfolio' );
				}
				if( ! $wp_filesystem->put_contents( $cssFile, $css  ) ){
					error_log( print_r( 'Portfolio faild to generated css file ',true ) );
				}
                
            }
        }


	}
endif;