<?php

if ( ! class_exists( 'PFPTaxMeta' ) ):

	class PFPTaxMeta {
		function __construct() {
			// Add cat columns
			add_filter( 'manage_edit-portfolio-category_columns', array( $this, 'pfp_cat_columns' ) );
			add_filter( 'manage_portfolio-category_custom_column', array( $this, 'pfp_cat_column' ), 10, 3 );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
			add_action( 'wp_ajax_pfp-get-term-list', array( $this, 'pfp_get_term_list' ) );
			add_action( 'wp_ajax_pfp-update-temp-order', array( $this, 'pfp_update_temp_order' ) );
			add_action( 'created_term', array( $this, 'save_taxonomy_fields' ), 10, 3 );
			add_action( 'edit_term', array( $this, 'save_taxonomy_fields' ), 10, 3 );

		}
		public function save_taxonomy_fields( $term_id, $tt_id = '', $taxonomy = '' ) {
			if ( in_array($taxonomy, TLPpPro()->taxonomies) ) {
				if(!TLPpPro()->meta_exist($term_id, '_order', 'term')){
					update_term_meta( $term_id, '_order', 0 );
				}
			}
		}

		function pfp_update_temp_order(){
			$html  = $msg = null;
			$error = true;
			if ( TLPpPro()->verifyNonce() ) {
				$terms = (!empty($_REQUEST['terms']) ? explode(',',$_REQUEST['terms']) : array());
				if($terms && !empty($terms)){
					$error = false;
					foreach ($terms as $key => $term_id){
						update_term_meta($term_id, '_order', $key + 1);
					}
				}else {
					$msg .= "<p>" . esc_html__( 'No term in list', 'tlp-portfolio-pro' ) . "</p>";
				}
			} else {
				$msg .= "<p>" . esc_html__( 'Something went wrong !!', 'tlp-portfolio-pro' ) . "</p>";
			}

			wp_send_json(
				array(
					'data'  => $html,
					'error' => $error,
					'msg'   => $msg
				)
			);
			die();
		}

		function pfp_get_term_list() {
			$html  = $msg = null;
			$error = true;
			if ( TLPpPro()->verifyNonce() ) {
				$tax = (!empty($_REQUEST['tax']) ? $_REQUEST['tax'] : null);
				if($tax){
					$error = false;
					$terms = get_terms( $tax, array(
						'orderby'    => 'meta_value_num',
						'meta_key'   => '_order',
						'order'      => 'ASC',
						'hide_empty' => false,
					) );
					if ( ! empty( $terms ) ) {
						$html .= "<ul id='order-target' data-taxonomy='{$tax}'>";
						foreach ( $terms as $term ) {
							$html .=  "<li data-id='{$term->term_id}'><span>{$term->name}</span></li>";
						}
						$html .=  "</ul>";
					}else{
						$html .= "<p>" . esc_html__( 'No term found', 'tlp-portfolio-pro' ) . "</p>";
					}
				}else {
					$html .= "<p>" . esc_html__( 'Select a taxonomy', 'tlp-portfolio-pro' ) . "</p>";
				}
			} else {
				$html .= "<p>" . esc_html__( 'Something went wrong !!', 'tlp-portfolio-pro' ) . "</p>";
			}

			wp_send_json(
				array(
					'data'  => $html,
					'error' => $error,
					'msg'   => $msg
				)
			);
			die();
		}

		function admin_enqueue_scripts() {
			global $pagenow, $typenow;
			// validate page
			if ( ! in_array( $pagenow, array( 'edit.php' ) ) && !empty($_REQUEST['page']) && $_REQUEST['page'] != 'pfp_taxonomy_order' ) {
				return;
			}
			if ( $typenow != TLPpPro()->post_type ) {
				return;
			}

			$select2Id = 'pfp-select2';
//			if ( class_exists( 'WPSEO_Admin_Asset_Manager' ) && class_exists( 'Avada' ) ) {
//				$select2Id = 'yoast-seo-select2';
//			} elseif ( class_exists( 'WPSEO_Admin_Asset_Manager' ) ) {
//				$select2Id = 'yoast-seo-select2';
//			} elseif ( class_exists( 'Avada' ) ) {
//				$select2Id = 'select2-avada-js';
//			}

			wp_enqueue_script( array(
				'jquery',
				'jquery-ui-core',
				'jquery-ui-sortable',
				$select2Id,
				'pfp-admin-taxonomy'
			) );
			wp_enqueue_style( array(
				'pfp-select2',
				'pfp-admin'
			) );

			wp_localize_script( 'pfp-admin-taxonomy', 'pfp',
				array(
					'nonceId' => TLPpPro()->nonceId(),
					'nonce'   => wp_create_nonce( TLPpPro()->nonceText() ),
					'ajaxurl' => admin_url( 'admin-ajax.php' )
				) );
		}


		public function pfp_cat_columns( $columns ) {
			$new_columns = array();
			if ( isset( $columns['cb'] ) ) {
				$new_columns['cb'] = $columns['cb'];
				unset( $columns['cb'] );
			}
			$new_columns_order['order'] = esc_html__( 'Order', 'tlp-portfolio-pro' );
			return array_merge( $new_columns, $columns, $new_columns_order );
		}


		public function pfp_cat_column( $columns, $column, $id ) {

			if ( 'order' == $column ) {
				$columns .= get_term_meta( $id, '_order', true );
			}

			return $columns;
		}

	}

endif;