<?php
if (!class_exists('PFPOpenGraphTag')) :

    class PFPOpenGraphTag
    {
        function __construct() {
            add_filter('language_attributes', array($this, 'tlp_doctype_opengraph'));
            add_action('wp_head', array($this, 'tlp_opengraph'), 5);
        }

        function tlp_doctype_opengraph($output) {
            if (is_single() && is_singular(TLPpPro()->post_type)) {
                return $output . '
                    xmlns:og="http://ogp.me/ns#"
                    xmlns:fb="http://www.facebook.com/2008/fbml"';
            }
            return $output;
        }

        function tlp_opengraph() {
            global $post;

            $html = null;
            if (is_single() && is_singular(TLPpPro()->post_type)) {
                $img = $imgs = array(
                    'src'    => null,
                    "type"   => null,
                    "width"  => null,
                    "height" => null
                );
                $uO = get_userdata($post->post_author);
                if (has_post_thumbnail($post->ID)) {
                    $imgSrc = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'thumbnail');
                    $imgSrcS = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'medium');
                    $attachInfo = wp_get_attachment_metadata(get_post_thumbnail_id($post->ID));
	                $img['src'] = isset( $imgSrc[0] ) ? $imgSrc[0] : '';
	                $imgs['src'] = isset( $imgSrcS[0] ) ? $imgSrcS[0] : '';
	                if(isset($attachInfo['sizes']['thumbnail'])) {
		                $imgInfo       = $attachInfo['sizes']['thumbnail'];
		                $img['type']   = $imgInfo['mime-type'];
		                $img['width']  = $imgInfo['width'];
		                $img['height'] = $imgInfo['height'];
	                }
					if(isset($attachInfo['sizes']['medium'])) {
						$imgInfoS       = $attachInfo['sizes']['medium'];
						$imgs['type']   = $imgInfoS['mime-type'];
						$imgs['width']  = $imgInfoS['width'];
						$imgs['height'] = $imgInfoS['height'];
					}
                }
                if ($excerpt = $post->post_excerpt) {
                    $excerpt = strip_tags($post->post_excerpt);
                    $excerpt = str_replace("", "'", $excerpt);
                } else {
                    $excerpt = get_bloginfo('description');
                }

                $html .= '<meta property="description" content="' . $excerpt . '"/>';
                $html .= '<meta property="google-site-verification" content="' . $excerpt . '"/>';
                $html .= '<meta property="og:title" content="' . get_the_title() . '"/>';
                $html .= '<meta property="og:site_name" content="' . get_bloginfo() . '"/>';
                $html .= '<meta property="og:url" content="' . get_the_permalink() . '"/>';
                $html .= '<meta property="og:description" content="' . $excerpt . '"/>';
                $html .= '<meta property="og:type" content="article"/>';
                if (!empty($img)) {
                    foreach ($img as $key => $attr) {
                        if ($key == 'src') {
                            $html .= '<link rel="image_src" href="' . esc_url( $attr ) . '" / >';
                            $html .= '<meta property="og:image" content="' . esc_url( $attr ) . '"/>';
                        } else {
                            $html .= '<meta property="og:image:' . $key . '" content="' . $attr . '"/>';
                        }
                    }
                }

                // Twitter

                $html .= '<meta name="twitter:card" content="summary">';
                $html .= '<meta name="twitter:url" content="' . get_the_permalink() . '">';
                $html .= '<meta name="twitter:title" content="' . get_the_title() . '">';
                $html .= '<meta name="twitter:description" content="' . $excerpt . '">';
                $html .= '<meta name="twitter:image" content="' . $excerpt . '">';
                $html .= isset($img['src']) ? '<meta name="twitter:image" content="' . $img['src'] . '">' : null;

                // Schema
                $article = array();
                $article["@context"] = "http://schema.org";
                $article["@type"] = "Article";
                $article["headline"] = get_the_title();
                $article["mainEntityOfPage"] = array(
                    "@type" => "WebPage",
                    "@id"   => get_the_permalink()
                );
                $article["author"] = array(
                    "@type" => "Person",
                    "name"  => $uO
                );
                $plA = array(
                    "@type"  => "ImageObject",
                    "url"    => $imgs['src'],
                    "height" => intval($imgs['height']),
                    "width"  => intval($imgs['width']),
                );
                $article["publisher"] = array(
                    "@type" => "Organization",
                    "name"  => get_bloginfo(),
                    "logo"  => $plA
                );
                $article["image"] = array(
                    "@type"  => "ImageObject",
                    "url"    => $img['src'],
                    "height" => intval($img['height']),
                    "width"  => intval($img['width']),
                );
                $article["datePublished"] = get_the_date('Y-m-d');
                $article["dateModified"] = get_the_modified_date('Y-m-d');
                $article["description"] = $excerpt;
                $article["articleBody"] = get_the_content();
                $html .= $this->get_jsonEncode($article);


            }

            echo $html;
        }

        function get_jsonEncode($data = array()) {
            $html = null;
            /** @var TYPE_NAME $data */
            if (!empty($data) && is_array($data)) {
                $html .= '<script type="application/ld+json">' . json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) . '</script>';
            }
            return $html;
        }

    }

endif;