jQuery.browser = {};
(function () {
    jQuery.browser.msie = false;
    jQuery.browser.version = 0;
    if (navigator.userAgent.match(/MSIE ([0-9]+)\./)) {
        jQuery.browser.msie = true;
        jQuery.browser.version = RegExp.$1;
    }
})();



(function ($) {
    'use strict';

    $(function () {
        $("#add-new-port-img").on('click', function (evt) {
            evt.preventDefault();
            renderMediaUploader();
        });
       
        $(".rt-tab-nav li:first-child a").trigger('click');
    });

    /* rt tab active navigation */
    $(".rt-tab-nav li").on('click', 'a', function (e) {
        e.preventDefault();
        var container = $(this).parents('.rt-tab-container');
        var nav = container.children('.rt-tab-nav');
        var content = container.children(".rt-tab-content");
        var $this, $id;
        $this = $(this);
        $id = $this.attr('href');
        content.hide();
        nav.find('li').removeClass('active');
        $this.parent().addClass('active');
        container.find($id).show();
    });
    if ($(".tlp-date").length) {
        $('.tlp-date').datepicker({
            'format': pfp.tlp_date_format,
            'autoclose': true
        });
    }
    if ($("#sc-item-select").length) {
        $("#sc-item-select").select2({
            placeholder: "Select multiple item",
            allowClear: true
        });
    }
    if ($("select#sc-item-select").length) {
        $("select#sc-item-select").select2({
            placeholder: "Select multiple member",
            allowClear: true,
            width: '100%'
        });
    }
    if ($("select.rt-select2").length) {
        $("select.rt-select2").select2({width: '100px'});
    }
    if ($("select#img-size").length) {
        $("select#img-size").select2({width: '200px'});
    }
    if ($("select#related-project").length) {
        $("select#related-project").select2({
            placeholder: "Select related project",
            allowClear: true,
            width: '250px'
        });
    }
    specificMshowHide();
    layoutOptShowHide();
    $("#specific-items-action, #layout").on('change', function () {
        specificMshowHide();
        layoutOptShowHide();
    });

    //   console.log(' Something' );


    $("#license_key_holder input").on('input', function () {
        $(".rt-licensing-btn").hide();
    });


    $('ul#tlp-gallery').sortable({
        items: 'li',
        opacity: 0.5,
        cursor: 'pointer'
    });

    $("ul#tlp-gallery li span.dashicons-dismiss").on("click", function (e) {
        e.preventDefault();
        if (confirm("Are you sure?")) {
            var li = $(this).parent('li'),
                id = li.find('input').val(),
                post_ID = $("#post_ID").val(),
                pfp_nonce = $("#pfp_nonce").val();
            if (id && post_ID && pfp_nonce) {
                var arg = "id=" + id + "&post_ID=" + post_ID + "&pfp_nonce=" + pfp_nonce;
                li.find('img').css('opacity', .3);
                AjaxCall($(this), 'tlp_portfolio_img_remove', arg, function (data) {
                    if (data.success) {
                        li.slideUp('slow').remove();
                    }
                });
            } else {
                alert("Image or Post ID Not found");
            }
        }
    });
    SHTarget();
    $('#detail_popup input[name=detail_popup]').on('change', function () {
        SHTarget();
    });

    $("#pfp-settings").on('click', '#rt-pfp-saveButton', function (e) {
        e.preventDefault();
        pfpSyncCss();
        var self = $(this),
            arg = self.parents('form').serialize();
        AjaxCall('', 'pfpSettingsUpdate', arg, function (data) {
            if (!data.error) {
                $('#response').removeClass('error');
                $('#response').show('slow').text(data.msg);
                var holder = $("#license_key_holder"),
                    target = $(".description", holder);
                if (!$(".license-status", holder).length && $("#license_key", holder).val()) {
                    target.find(".rt-licence-msg").remove();
                    AjaxCall('', 'rtPfp_active_Licence', '', function (data) {
                        if (!data.error) {
                            target.append("<span class='license-status'>" + data.html + "</span>");
                        }
                        if (data.msg) {
                            if (target.find(".rt-licence-msg").length) {
                                target.find(".rt-licence-msg").html(data.msg);
                            } else {
                                target.append("<span class='rt-licence-msg'>" + data.msg + "</span>");
                            }
                            if (!data.error) {
                                target.find(".rt-licence-msg").addClass('success');
                            }
                        }
                    });
                }
                if (!$("#license_key", holder).val()) {
                    $('.license-status', holder).remove();
                }
            } else {
                $('#response').addClass('error');
                $('#response').show('slow').text(data.msg);
            }
        });
        return false;
    });

    $("#pfp-settings").on('click', '.rt-licensing-btn', function (e) {
        e.preventDefault();
        var self = $(this),
            type = self.attr('name'),
            data = 'type=' + type;
        $("#license_key_holder").find(".rt-licence-msg").remove();
        AjaxCall(self, 'rtPfpManageLicencing', data, function (data) {
            if (!data.error) {
                self.val(data.value);
                self.attr('name', data.name);
                self.addClass(data.class);
                if (data.name == 'license_deactivate') {
                    self.removeClass('button-primary');
                    self.addClass('danger');
                } else if (data.name == 'license_activate') {
                    self.removeClass('danger');
                    self.addClass('button-primary');
                }
            }
            if (data.msg) {
                $("<div class='rt-licence-msg'>" + data.msg + "</div>").insertAfter(self);
            }
            self.blur();
        });

        return false;
    });

    function AjaxCall(element, action, arg, handle) {
        'use strict';
        var data;
        if (action) data = "action=" + action;
        if (arg) data = arg + "&action=" + action;
        if (arg && !action) data = arg;
        data = data;
        var n = data.search("pfp_nonce");
        if (n < 0) {
            data = data + "&" + pfp.nonceId + "=" + pfp.nonce;
        }
        $.ajax({
            type: "post",
            url: ajaxurl,
            data: data,
            beforeSend: function () {
                $('body').append($("<div id='pfp-loading'><span class='pfp-loading'>Updating ...</span></div>"));
            },
            success: function (data) {
                $("#pfp-loading").remove();
                handle(data);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $("#pfp-loading").remove();
                alert(textStatus + ' (' + errorThrown + ')');
            }
        });
    }
})(jQuery);

function SHTarget() {
    var id = jQuery('input[name=detail_popup]:checked', '#detail_popup').val();
    if (id == 'external_page') {
        jQuery('.rt-field-wrapper.target').show();
    } else {
        jQuery('.rt-field-wrapper.target').hide();
    }

}

function renderMediaUploader() {
    'use strict';
    var file_frame, image_data;
    if (undefined !== file_frame) {
        file_frame.open();
        return;
    }
    file_frame = wp.media.frames.file_frame = wp.media({
        title: 'Select or Upload Media For your profile gallery',
        button: {
            text: 'Use this media'
        },
        multiple: false
    });
    file_frame.on('select', function () {
        var attachment = file_frame.state().get('selection').first().toJSON();
        var imgId = attachment.id;
        var imgUrl = (typeof attachment.sizes.thumbnail === "undefined") ? attachment.url : attachment.sizes.thumbnail.url;
        jQuery("ul#tlp-gallery").append("<li><span class='dashicons dashicons-dismiss'></span><img src='" + imgUrl + "' /><input type='hidden' name='tlp_portfolio_gallery[]' value='" + imgId + "' /></li>");
        jQuery("ul#tlp-gallery li.no-img").hide();
    });
    // Now display the actual file_frame
    file_frame.open();
}

function specificMshowHide() {
    if (jQuery('#specific-items-action').is(':checked')) {
        jQuery(".sc-meta-field.titem").hide();
        jQuery(".sc-meta-field.sitem").show();
    } else {
        jQuery(".sc-meta-field.titem").show();
        jQuery(".sc-meta-field.sitem").hide();
    }
}

function layoutOptShowHide() {
    var id = jQuery("#layout").val();
    if (id && id == "carousel") {
        jQuery(".sc-meta-field-full.carousel").show();
    } else {
        jQuery(".sc-meta-field-full.carousel").hide();
    }
}


(function (global, $) {
    var editor,
        syncCSS = function () {
            pfpSyncCss();
        },
        loadAce = function () {
            $('.rt-custom-css').each(function () {
                var id = $(this).find('.custom-css').attr('id');
                editor = ace.edit(id);
                global.safecss_editor = editor;
                editor.getSession().setUseWrapMode(true);
                editor.setShowPrintMargin(false);
                editor.getSession().setValue($(this).find('.custom_css_textarea').val());
                editor.getSession().setMode("ace/mode/css");
            });

            jQuery.fn.spin && $('.custom_css_container').spin(false);
            $('#post').submit(syncCSS);
        };
    if ($.browser.msie && parseInt($.browser.version, 10) <= 7) {
        $('.custom_css_container').hide();
        $('.custom_css_textarea').show();
        return false;
    } else {
        $(global).load(loadAce);
    }
    global.aceSyncCSS = syncCSS;
})(this, jQuery);

function pfpSyncCss() {
    jQuery('.rt-custom-css').each(function () {
        var e = ace.edit(jQuery(this).find('.custom-css').attr('id'));
        jQuery(this).find('.custom_css_textarea').val(e.getSession().getValue());
    });
}