(function ($) {

    $(function () {
        if($("select.rt-select2").length){
            $("select.rt-select2").select2({width: '100px'});
        }

        $('#pfp-taxonomy').on('change', function () {
            var self = $(this),
                tax = self.val(),
                target = $('#term-wrapper');
            if(tax){
                var data ="tax="+ tax;
                AjaxCall('pfp-get-term-list', data, function (data) {
                    if(!data.error) {
                        target.html(data.data);
                        var fixHelper = function (e, ui) {
                            ui.children().children().each(function () {
                                $(this).width($(this).width());
                            });
                            return ui;
                        };
                        $('#order-target').sortable({
                            items: 'li',
                            axis: 'y',
                            helper: fixHelper,
                            placeholder: 'placeholder',
                            opacity: 0.65,
                            update: function (e, ui) {
                                var target = $('#order-target');
                                var taxonomy = target.data('taxonomy'),
                                    terms = target.find('li').map(function () {
                                        return $(this).data('id');
                                    }).get(),
                                    data = "taxonomy="+taxonomy+"&terms="+terms;
                                AjaxCall('pfp-update-temp-order', data, function (data) {
                                    if(data.error){
                                        alert('Error !!!');
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });

    });

    function AjaxCall(action, arg, handle) {
        var data;
        if (action) data = "action=" + action;
        if (arg) data = arg + "&action=" + action;
        if (arg && !action) data = arg;
        data = data + "&"+pfp.nonceId+"=" + pfp.nonce;
        $.ajax({
            type: "post",
            url: ajaxurl,
            data: data,
            beforeSend: function() {
                $('body').append($("<div id='pfp-loading'><span class='pfp-loading'>Updating ...</span></div>"));
            },
            success: function(data) {
                $("#pfp-loading").remove();
                handle(data);
            },
            error: function( jqXHR, textStatus, errorThrown ) {
                $("#pfp-loading").remove();
                alert( textStatus + ' (' + errorThrown + ')' );
            }
        });
    }
})(jQuery);
