<?php
/**
 * Section Widget
 */

namespace Elementor;
class Kiedo_Section extends Widget_Base {

	public function get_name() {
        return 'Section';
    }

	public function get_title() {
        return __( 'Section', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-handle';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Section',
			[
				'label' => __( 'Kiedo Section', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'bg_title',
                [
                    'label' => __( 'Background Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('App Screen', 'kiedo-toolkit'),
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'label' => __( 'Top Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('KEY FEATURES', 'kiedo-toolkit'),
                ]
            );
            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Our Featured Services', 'kiedo-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'label' => esc_html__( 'Background', 'kiedo-toolkit' ),
                    'types' => ['gradient'],
                    'selector' => '{{WRAPPER}} .section-title.title-with-bg-text .big-title',
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'bg_title_typography',
                    'label' => __( 'Background Text Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title.title-with-bg-text .big-title',
                    'condition' => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h5, .section-title h6',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title p',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');
        ?>
            <div class="container">
                <?php if( $settings['style'] == '1' ) : ?>
                <div class="section-title">
                    <?php if( $settings['top_title'] != '' ): ?>
                        <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?>
                    <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                    <?php if( $settings['content'] != '' ): ?>
                        <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                </div>
                <?php elseif( $settings['style'] == '2' ) : ?>
                    <div class="section-title title-with-bg-text">
                        <?php if( $settings['bg_title'] != '' ): ?>
                            <div class="big-title"><?php echo esc_html( $settings['bg_title'] ); ?></div>
                        <?php endif; ?>

                        <?php if( $settings['top_title'] != '' ): ?>
                            <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                        <?php endif; ?>
                        <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                    </div>
                <?php endif; ?>
            </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Section );