<?php
/**
 * Partner Logo Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Partner_Logo extends Widget_Base {

	public function get_name() {
        return 'Partner_Logo';
    }

	public function get_title() {
        return __( 'Partner Logo', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-logo';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'partner_section',
			[
				'label' => __( 'Partner Logo Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => esc_html__( 'Section Style', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'kiedo-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'kiedo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'bg_color',
                [
                    'label' => __( 'Background Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .partner-box' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );
            $this->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Partner Title', 'kiedo-toolkit' ),
                    'default' => 'Trusted by world famous companies:',
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );
			$repeater = new Repeater();
            $repeater->add_control(
                'logo', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Logo', 'kiedo-toolkit' ),
                ]
            );
            $repeater->add_control(
                'logo_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Logo Link', 'kiedo-toolkit' ),
                    'default' => '#'
                ]
            );
            $this->add_control(
                'logos',
                [
                    'label'   => esc_html__( 'Add Partner Logo', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <?php if($settings['style'] == '1'): ?>
            <div class="partner-area  ptb-100">
                <div class="container">
                    <div class="partner-title">
                        <?php echo esc_html($settings['title']); ?>
                    </div>
                    <div class="partner-box">
                        <div class="partner-slides owl-carousel owl-theme">
                            <?php foreach( $settings['logos'] as $item ): ?>
                                <div class="partner-item">
                                    <a href="<?php echo esc_url( $item['logo_link'] ); ?>"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'kiedo-toolkit' ); ?>"></a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '2'): ?>
            <div class="partner-area ptb-100">
                <div class="container">
                    <div class="partner-slides owl-carousel owl-theme">
                        <?php foreach( $settings['logos'] as $item ): ?>
                            <div class="partner-item">
                                <a href="<?php echo esc_url( $item['logo_link'] ); ?>" class="d-block"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'kiedo-toolkit' ); ?>"></a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Partner_Logo );