<?php
/**
 * Image Tab Logo Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_I_Tab extends Widget_Base {

	public function get_name() {
        return 'ImageTab';
    }

	public function get_title() {
        return __( 'Image Tab', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'i_tab_section',
			[
				'label' => __( 'Image Tab Control', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$repeater = new Repeater();

            $repeater->add_control(
                'icon', [
					'type'    => Controls_Manager::ICON,
					'label'   => esc_html__( 'Icon', 'kiedo-toolkit' ),
                    'label_block' => true,
                    'options' => kiedo_icons(),
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Tab Title', 'kiedo-toolkit' ),
                    'default' => '#'
                ]
            );
            $repeater->add_control(
                'image', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Image', 'kiedo-toolkit' ),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Tab', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings_for_display();


        $items = $settings['items'];
        ?>
        <div class="container">
            <div class="screenshots-tabs">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php $count = 1; foreach ( $items as $key => $value ) { ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if($count == 1): echo "active"; endif; ?>" id="screen<?php echo $count; ?>-tab" data-bs-toggle="tab" data-bs-target="#screen<?php echo $count; ?>" type="button" role="tab" aria-controls="screen<?php echo $count; ?>" aria-selected="true"><i class="<?php echo esc_attr( $value['icon'] ); ?>"></i> <?php echo esc_html( $value['title'] ); ?></button>
                        </li>
                    <?php $count++; } ?>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <?php $count = 1; foreach ( $items as $key => $value ) { ?>
                        <div class="tab-pane fade <?php if($count == 1): echo "show active"; endif; ?>" id="screen<?php echo $count; ?>" role="tabpanel">
                            <?php if( $value['image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['title'] ) ?>">
                            <?php endif; ?>
                        </div>
                    <?php $count++; } ?>
                </div>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_I_Tab );