<?php
/**
 * Feedback Two Widget
 */

namespace Elementor;
class Kiedo_Feedback_Two extends Widget_Base {

	public function get_name() {
        return 'FeedbackTwo';
    }

	public function get_title() {
        return __( 'Feedback Two', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-testimonial';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'top_title',
            [
                'label' => __( 'Top Title', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('KEY FEATURES', 'kiedo-toolkit'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'kiedo-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                    'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                    'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                    'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                    'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                    'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                ],
                'default' => 'h2',
            ]
        );

        $this->add_control(
            'img',
            [
                'label' => __( 'Section Image', 'kiedo-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Olivar Lucy', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'designation',
            [
                'label' => esc_html__('Designation', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('CEO at ThemeForest', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'feedback',
            [
                'label' => esc_html__('Feedback Content', 'kiedo-toolkit'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Kiedo is the best digital agency in our area As a midsize software developent company we combine the best of both worlds. We have the focus and speed of the small it outsurcing companies.', 'kiedo-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'icon',
            [
                'label' => esc_html__('Feedback Icon', 'kiedo-toolkit'),
                'type' => Controls_Manager::ICON,
                'options' => kiedo_icons(),
            ]
        );
        $this->add_control(
            'kiedo_feedback_items',
            [
                'label' => esc_html__('Feedback Item', 'kiedo-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'name' => esc_html__(' Item #1', 'kiedo-toolkit') ],

                ],
                'fields' => $list_items->get_controls(),
            ]
        );
    $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $items = $settings['kiedo_feedback_items'];

        $this-> add_inline_editing_attributes('title','none'); ?>

        <?php $count = 0;
        foreach ( $items as $key => $value ) {
            $count++;
        } ?>

        <div class="testimonials-area ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-12">
                        <div class="testimonials-image">
                            <?php if( $settings['img']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $settings['img']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ) ?>">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-12">
                        <div class="testimonials-content">
                            <?php if( $settings['top_title'] != '' ): ?>
                                <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>
                            <h2 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h2>
                        </div>
                        <?php if( $count == 1 ): ?>
                        <div class="col-lg-12 col-sm-12">
                        <?php else: ?>
                        <div class="testimonials-slides owl-carousel owl-theme">
                        <?php endif; ?>
                            <?php foreach ( $items as $key => $value ) { ?>
                                <div class="content">
                                    <h3><?php echo esc_html( $value['name'] ); ?></h3>
                                    <span><?php echo esc_html( $value['designation'] ); ?></span>
                                    <p><?php echo wp_kses_post( $value['feedback'] ); ?></p>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Feedback_Two );