<?php
/**
 * Posts Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Kiedo_Posts extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Posts';
    }

	public function get_title() {
        return esc_html__( 'Posts', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-post-slider';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
	}
	protected function register_controls() {

        $this->start_controls_section(
			'kiedo_Posts',
			[
				'label' => esc_html__( 'kiedo Posts', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
        );        
            $this->add_control(
                'cat', [
                    'label'       => esc_html__( 'Category', 'kiedo-toolkit' ),
                    'description' => esc_html__( 'Enter the category slugs separated by commas (Eg. cat1, cat2)', 'kiedo-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => esc_html__( 'Posts Order By', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => esc_html__( 'DESC', 'kiedo-toolkit' ),
                        'ASC'       => esc_html__( 'ASC', 'kiedo-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => esc_html__( 'Choose Columns', 'kiedo-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => esc_html__( '1', 'kiedo-toolkit' ),
                        '2'   => esc_html__( '2', 'kiedo-toolkit' ),
                        '3'   => esc_html__( '3', 'kiedo-toolkit' ),
                        '4'   => esc_html__( '4', 'kiedo-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label'   => esc_html__( 'Posts', 'kiedo-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'blog_style',
			[
				'label' => esc_html__( 'Style Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog .blog-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color_hover',
                [
                    'label' => esc_html__( 'Title Color Hover', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog .blog-content h3 a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog .blog-content h3',
                ]
            );
            $this->add_control(
                'meta_color',
                [
                    'label' => esc_html__( 'Meta Color', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog .blog-content ul li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_typography',
                    'label' => esc_html__( 'Meta Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog .blog-content ul li',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        global $kiedo_opt;

        // Card Columns
        $columns = $settings['columns'];
        if ($columns == '1') {
            $column = 'col-lg-12 col-md-6';
        }elseif ($columns == '2') {
            $column = 'col-lg-6 col-md-6';
        }elseif ($columns == '3') {
            $column = 'col-lg-4 col-md-6';
        }elseif ($columns == '4') {
            $column = 'col-lg-3 col-md-6';
        }
        
        // Post Query
        if( $settings['cat'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'ignore_sticky_posts' => 1,
                'meta_key' => '_thumbnail_id',
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'post',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'ignore_sticky_posts' => 1,
                'meta_key' => '_thumbnail_id'
            );
        }
        $post_array = new \WP_Query( $args );
        
		?>
        <div class="container">
            <div class="row justify-content-center">
                <?php while($post_array->have_posts()): $post_array->the_post(); 
                $categories = get_the_category();
                ?>
                <div class="<?php echo esc_attr( $column );?>">
                    <div class="single-blog">
                        <?php if(has_post_thumbnail()) { ?>
                            <div class="image">
                                <a href="<?php the_permalink() ?>" class="d-block">
                                    <img src="<?php the_post_thumbnail_url('kiedo_post_thumb') ?>" alt="<?php the_title_attribute(); ?>">
                                </a>
                                <?php if ( ! empty( $categories ) ) { ?>
                                    <a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) ); ?>" class="tag"><?php echo  esc_html( $categories[0]->name )  ?></a>
                                <?php } ?>
                            </div>
                        <?php } ?>

                        <div class="blog-content">
                            <?php if( isset( $kiedo_opt['is_post_meta'] ) && $kiedo_opt['is_post_meta'] == true ) { ?>
                                <ul class="meta">
                                    <li>
                                        <i class="ri-time-line"></i>
                                        <?php echo esc_html(get_the_date()); ?>
                                    </li>
                                    <li>
                                        <i class="ri-user-line"></i>
                                        <?php echo esc_html(get_the_author()); ?>
                                    </li>
                                </ul>
                            <?php } ?>

                            <?php if( get_the_title() != '' ): ?>
                                <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Kiedo_Posts );