<?php
/**
 * Banner Two Widget
 */

namespace Elementor;
class Kiedo_Banner_Seven extends Widget_Base {

	public function get_name() {
        return 'Kiedo_BannerSeven';
    }

	public function get_title() {
        return __( 'Banner Seven', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'sec_bg_text',
				[
					'label' => __( 'Section Background Text', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Kiedo', 'kiedo-toolkit'),
					'label_block' => true,
				]
			);
			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('#Get your 14 days free trail', 'kiedo-toolkit'),
				]
			);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('The Revolutionary App That Makes Your Life Easier Than Others Apps', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
				'desc',
				[
					'label'   => __( 'Description', 'kiedo-toolkit' ),
					'type'    => Controls_Manager::TEXTAREA,
					'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Id tincidunt eifend odio viverra diam aliquet donec again.', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
				'app_image',
				[
					'label' => __( 'App Store Image', 'kiedo-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'app_store_text',
				[
					'label'       => __( 'App Store Text', 'kiedo-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Start Free Trial', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

			$this->add_control(
				'div1',
				[
					'type' => Controls_Manager::DIVIDER,
				]
			);

			// Play Store 2
			$this->add_control(
				'play_image',
				[
					'label' => __( 'Play Store Image', 'kiedo-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'play_store_text',
				[
					'label'       => __( 'Play Store Text', 'kiedo-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Start Free Trial', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
                'link_type2',
                [
                    'label' 		=> esc_html__( 'Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page2',
                [
                    'label' 		=> esc_html__( ' Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type2' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_link2',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type2' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

		$this->start_controls_section(
			'Kiedo_Banner_Images',
			[
				'label' => __( 'Images Controls', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'bg_image',
				[
					'label' => __( 'Background Image', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'con_shape',
				[
					'label' => __( 'Content Shape Image', 'kiedo-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'image',
				[
					'label' => __( 'Image', 'kiedo-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape1',
				[
					'label' => __( 'Shape Image 1', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape2',
				[
					'label' => __( 'Shape Image 2', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape3',
				[
					'label' => __( 'Shape Image 3', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape4',
				[
					'label' => __( 'Shape Image 4', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
        $this->end_controls_section();

		$this->start_controls_section(
			'Kiedo_Banner_logos',
			[
				'label' => __( 'Banner Logos Controls', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'partner_title',
				[
					'label'       => __( 'Logo Title', 'kiedo-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Trusted by:', 'kiedo-toolkit'),
					'label_block' => true,
				]
			);
			$logos = new Repeater();
			$logos->add_control(
				'logos',
				[
					'label' => __( 'Partner Logo', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'logo_item',
				[
					'label'  => esc_html__('Add Partner Logo', 'kiedo-toolkit'),
					'type'   => Controls_Manager::REPEATER,
					'fields' => $logos->get_controls(),
				]
			);
        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'bg_title_color',
				[
					'label'     => __( 'Background Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .name-big-text' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'bg_text_typography',
                    'label'    => __( 'Background Text Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .content .name-big-text',
                ]
            );
			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .sub-title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .content .sub-title',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content h1, .new-app-main-banner-content .content h2, .new-app-main-banner-content .content h3, .new-app-main-banner-content .content h4, .new-app-main-banner-content .content h5, .new-app-main-banner-content .content h6' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .content h1, .new-app-main-banner-content .content h2, .new-app-main-banner-content .content h3, .new-app-main-banner-content .content h4, .new-app-main-banner-content .content h5, .new-app-main-banner-content .content h6',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .content p',
                ]
            );
			$this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Top Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn, .new-app-main-banner-content .content .app-btn-box .playstore-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_btcolor',
				[
					'label'     => __( 'Button Bottom Text Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn span, .new-app-main-banner-content .content .app-btn-box .playstore-btn span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn, .new-app-main-banner-content .content .app-btn-box .playstore-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_hbg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn::before, .new-app-main-banner-content .content .app-btn-box .playstore-btn::before' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_h_color',
				[
					'label'     => __( 'Button Hover Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn:hover span, .new-app-main-banner-content .content .app-btn-box .playstore-btn:hover span' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .content .app-btn-box .applestore-btn, .new-app-main-banner-content .content .app-btn-box .playstore-btn, .new-app-main-banner-content .content .app-btn-box .applestore-btn span, .new-app-main-banner-content .content .app-btn-box .playstore-btn span',
                ]
            );
			$this->add_control(
				'partner_title_color',
				[
					'label'     => __( 'Partner Title Color', 'kiedo-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .new-app-main-banner-content .new-app-trusted-by .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'partner_title_typography',
                    'label'    => __( 'Partner Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .new-app-main-banner-content .new-app-trusted-by .title',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		// Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        if($settings['link_type2'] == 1){
            $link2 = get_page_link( $settings['link_to_page2'] );
        } else {
            $link2 = $settings['ex_link2'];
        }

		$logo_item = $settings['logo_item'];

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>

		<div class="new-app-main-banner-area" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <div class="new-app-main-banner-content">
                            <div class="content">
								<?php if($settings['sec_bg_text']): ?>
                                	<div class="name-big-text"><?php echo esc_html($settings['sec_bg_text']); ?></div>
								<?php endif; ?>

								<?php if($settings['top_title']): ?>
									<span class="sub-title"><?php echo esc_html($settings['top_title']); ?></span>
								<?php endif; ?>

								<<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
									<?php echo esc_html( $settings['title'] ); ?>
								</<?php echo esc_attr( $settings['title_tag'] ); ?>>

								<p><?php echo wp_kses_post( $settings['desc'] ); ?></p>

                                <div class="app-btn-box">
									<?php if( $settings['app_store_text'] ): ?>
										<a href="<?php echo esc_url( $link ); ?>" class="applestore-btn" target="_blank">
											<?php if($settings['app_image']['url'] != ''): ?>
												<img src="<?php echo esc_url( $settings['app_image']['url'] ); ?>" alt="<?php echo esc_attr__("App Image", "kiedo-toolkit"); ?>">
											<?php endif; ?>

											<?php echo wp_kses_post( $settings['app_store_text'] ); ?>
										</a>
									<?php endif; ?>

									<?php if( $settings['play_store_text'] ): ?>
										<a href="<?php echo esc_url( $link2 ); ?>" class="playstore-btn" target="_blank">
											<?php if($settings['play_image']['url'] != ''): ?>
												<img src="<?php echo esc_url( $settings['play_image']['url'] ); ?>" alt="<?php echo esc_attr__("Play Store Image", "kiedo-toolkit"); ?>">
											<?php endif; ?>

											<?php echo wp_kses_post( $settings['play_store_text'] ); ?>
										</a>
									<?php endif; ?>
                                </div>

								<?php if($settings['con_shape']['url'] != ''): ?>
                                <div class="content-shape">
									<img src="<?php echo esc_url( $settings['con_shape']['url'] ); ?>" alt="<?php echo esc_attr__("Content Shape", "kiedo-toolkit"); ?>">
                                </div>
								<?php endif; ?>

                            </div>

                            <div class="new-app-trusted-by">
                                <div class="row align-items-center">
									<?php if($settings['partner_title']): ?>
										<div class="col-lg-2 col-md-12">
											<span class="title"><?php echo esc_html($settings['partner_title']); ?></span>
										</div>
									<?php endif; ?>

                                    <div class="col-lg-10 col-md-12">
                                        <div class="new-app-trusted-by-slides owl-carousel owl-theme">
											<?php foreach( $logo_item as $item ): ?>
												<div class="item">
													<img src="<?php echo esc_url( $item['logos']['url'] ); ?>" alt="<?php echo esc_attr__("Partner Logo", "kiedo-toolkit"); ?>">
												</div>
											<?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="new-app-main-banner-image" data-aos="fade-up" data-aos-duration="2000">

							<?php if($settings['image']['url'] != ''): ?>
								<img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "kiedo-toolkit"); ?>">
							<?php endif; ?>

							<?php if($settings['shape1']['url'] != ''): ?>
							    <div class="wrap-shape-1">
									<img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
								</div>
							<?php endif; ?>
							<?php if($settings['shape2']['url'] != ''): ?>
								<div class="wrap-shape-2">
									<img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
								</div>
							<?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>

			<?php if($settings['shape3']['url'] != ''): ?>
				<div class="new-app-banner-bg-shape">
					<img src="<?php echo esc_url( $settings['shape3']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape4']['url'] != ''): ?>
				<div class="new-app-banner-strock-shape">
					<img src="<?php echo esc_url( $settings['shape4']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
        </div>

        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Kiedo_Banner_Seven );