<?php
/**
 * Banner Widget
 */

namespace Elementor;
class Kiedo_Banner extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Banner_One';
    }

	public function get_title() {
        return __( 'Banner One', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('#Get your 14 days free trail', 'kiedo-toolkit'),
				]
			);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('The Revolutionary App That Makes Your Life Easier Than Others Apps', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
				'button_text',
				[
					'label' => __( 'Button Text', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Start Free Trial', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'kiedo-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'kiedo-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'kiedo-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> kiedo_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );


			$this->add_control(
				'image',
				[
					'label' => __( 'Section Image', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);

			$this->add_control(
                'partner_title',
                [
                    'label'		=> esc_html__('Partner Title', 'kiedo-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
					'default' => __('Trusted by:', 'kiedo-toolkit'),
                ]
            );
			$repeater = new Repeater();
            $repeater->add_control(
                'logo', [
					'type'    => Controls_Manager::MEDIA,
					'label'   => esc_html__( 'Logo', 'kiedo-toolkit' ),
                ]
            );
            $repeater->add_control(
                'logo_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Logo Link', 'kiedo-toolkit' ),
                    'default' => '#'
                ]
            );
            $this->add_control(
                'logos',
                [
                    'label'   => esc_html__( 'Add Partner Logo', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

			$this->add_control(
				'shape1',
				[
					'label' => __( 'Shape Image 1', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape2',
				[
					'label' => __( 'Shape Image 2', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape3',
				[
					'label' => __( 'Shape Image 3', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape4',
				[
					'label' => __( 'Shape Image 4', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape5',
				[
					'label' => __( 'Shape Image 5', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'label' => __( 'Background', 'plugin-domain' ),
					'types' => ['gradient' ],
					'selector' => '{{WRAPPER}} .main-banner-area::before',
				]
			);

			$this->add_control(
				'top_title_color',
				[
					'label' => __( 'Top Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}.main-banner-content .sub-title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}}.main-banner-content .sub-title',
                ]
            );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6',
                ]
            );

			$this->add_control(
				'btn_color',
				[
					'label' => __( 'Button Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-banner-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_hover_bg_color',
				[
					'label' => __( 'Button Hover Background Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-banner-content .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'kiedo-toolkit' ),
                    'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content .default-btn',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		// Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>

		<div class="main-banner-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8 col-md-12">
                        <div class="main-banner-content">
                            <div class="content">
								<?php if($settings['top_title']): ?>
									<span class="sub-title"><?php echo esc_html($settings['top_title']); ?></span>
								<?php endif; ?>

								<<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
									<?php echo esc_html( $settings['title'] ); ?>
								</<?php echo esc_attr( $settings['title_tag'] ); ?>>

								<?php if( $settings['button_text'] ): ?>
                                	<a href="<?php echo esc_url( $link ); ?>" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
								<?php endif; ?>
                            </div>

							<?php if($settings['partner_title'] != ''): ?>
								<div class="trusted-by">
									<div class="row align-items-center">
										<?php if($settings['partner_title'] != ''): ?>
											<div class="col-lg-2 col-md-12">
												<span class="title"><?php echo esc_html($settings
												['partner_title']) ?></span>
											</div>
										<?php endif; ?>
										<div class="col-lg-10 col-md-12">
											<div class="trusted-by-slides owl-carousel owl-theme">
												<?php foreach( $settings['logos'] as $item ): ?>
													<div class="item">
														<a href="<?php echo esc_url( $item['logo_link'] ); ?>"><img src="<?php echo esc_url( $item['logo']['url'] ); ?>" alt="<?php echo esc_attr__( 'Partner Logo', 'kiedo-toolkit' ); ?>"></a>
													</div>
												<?php endforeach; ?>
											</div>
										</div>
									</div>
								</div>
							<?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12">
						<?php if($settings['image']['url']): ?>
							<div class="main-banner-image" data-aos="fade-up" data-aos-duration="2000">
								<img src="<?php echo esc_url( $settings['image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
							</div>
						<?php endif; ?>
					</div>
                </div>
            </div>
            <div class="shape-overlay"></div>

			<?php if($settings['shape1']['url'] != ''): ?>
				<div class="banner-shape1">
					<img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape2']['url'] != ''): ?>
				<div class="banner-shape2">
					<img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape3']['url'] != ''): ?>
				<div class="banner-shape3">
					<img src="<?php echo esc_url( $settings['shape3']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape4']['url'] != ''): ?>
				<div class="banner-shape4">
					<img src="<?php echo esc_url( $settings['shape4']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape5']['url'] != ''): ?>
				<div class="banner-shape5">
					<img src="<?php echo esc_url( $settings['shape5']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Banner );