<?php
/**
 * Banner Five Widget
 */

namespace Elementor;
class Kiedo_Banner_Five extends Widget_Base {

	public function get_name() {
        return 'Kiedo_Banner_Five';
    }

	public function get_title() {
        return __( 'Banner Five', 'kiedo-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'kiedo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Kiedo_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'kiedo-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'kiedo-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'kiedo-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'kiedo-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'kiedo-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'kiedo-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'kiedo-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('The Revolutionary App That Makes Your Life Easier Than Others Apps', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
				'desc',
				[
					'label' => __( 'Description', 'kiedo-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Id tincidunt eifend odio viverra diam aliquet donec again.', 'kiedo-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
                'action_url', [
                    'label' => esc_html__( 'Action URL', 'kiedo-toolkit' ),
                    'description' => __( 'Enter here your MailChimp action URL. <a href="https://www.docs.hibootstrap.com/docs/kiedo-theme-documentation/tips-guides-troubleshoots/get-mailchimp-newsletter-form-action-url/" target="_blank"> How to </a>', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Placeholder Text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter Your Email Address' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'kiedo-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Get Started' , 'kiedo-toolkit' ),
                    'label_block' => true,
                ]
            );

			$this->add_control(
				'image',
				[
					'label' => __( 'Section Image', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape1',
				[
					'label' => __( 'Shape Image 1', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape2',
				[
					'label' => __( 'Shape Image 2', 'kiedo-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'kiedo-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'label' => __( 'Background', 'plugin-domain' ),
					'types' => ['gradient' ],
					'selector' => '{{WRAPPER}} .gradient-banner-area',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .gradient-banner-content h1, .gradient-banner-content h2, .gradient-banner-content h3, .gradient-banner-content h4, .gradient-banner-content h5, .gradient-banner-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .gradient-banner-content h1, .gradient-banner-content h2, .gradient-banner-content h3, .gradient-banner-content h4, .gradient-banner-content h5, .gradient-banner-content h6',
                ]
            );

			$this->add_control(
				'desc_color',
				[
					'label' => __( 'Description Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .gradient-banner-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'label' => __( 'Description Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}} .gradient-banner-content p',
                ]
            );

			$this->add_control(
				'btn_color',
				[
					'label' => __( 'Button Color', 'kiedo-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}  .gradient-banner-content form .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'label' => __( 'Button Typography', 'kiedo-toolkit' ),
                    'selector' => '{{WRAPPER}}  .gradient-banner-content form .default-btn',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>

		<div class="gradient-banner-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="gradient-banner-content">
							<<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
								<?php echo esc_html( $settings['title'] ); ?>
							</<?php echo esc_attr( $settings['title_tag'] ); ?>>

							<p><?php echo wp_kses_post( $settings['desc'] ); ?></p>

							<form class="mailchimp free-trial-form" method="post">
								<input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" name="EMAIL" required>
								<?php if( $settings['button_text'] != '' ): ?>
									<button type="submit" class="default-btn"><?php echo esc_html( $settings['button_text'] ); ?></button>
								<?php endif; ?>
								<p class="mchimp-errmessage alert alert-danger mt-1" style="display: none;"></p>
								<p class="mchimp-sucmessage alert alert-primary mt-1" style="display: none;"></p>
							</form>

							<script>
								;(function($){
									"use strict";
									$(document).ready(function () {
										// MAILCHIMP
										if ($(".mailchimp").length > 0) {
											$(".mailchimp").ajaxChimp({
												callback: mailchimpCallback,
												url: "<?php echo esc_js($settings['action_url']) ?>"
											});
										}

										$(".memail").on("focus", function () {
											$(".mchimp-errmessage").fadeOut();
											$(".mchimp-sucmessage").fadeOut();
										});
										$(".memail").on("keydown", function () {
											$(".mchimp-errmessage").fadeOut();
											$(".mchimp-sucmessage").fadeOut();
										});
										$(".memail").on("click", function () {
											$(".memail").val("");
										});

										function mailchimpCallback(resp) {
											if (resp.result === "success") {
												$(".mchimp-sucmessage").html(resp.msg).fadeIn(1000);
												$(".mchimp-sucmessage").fadeOut(500);
											} else if (resp.result === "error") {
												$(".mchimp-errmessage").html(resp.msg).fadeIn(1000);
											}
										}
									});
								})(jQuery)
							</script>

                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
						<?php if($settings['image']['url']): ?>
							<div class="gradient-banner-image" data-aos="fade-up">
								<img src="<?php echo esc_url( $settings['image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
							</div>
						<?php endif; ?>
                    </div>
                </div>
            </div>

			<?php if($settings['shape1']['url'] != ''): ?>
				<div class="banner-shape1">
					<img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>
			<?php if($settings['shape2']['url'] != ''): ?>
				<div class="banner-shape2">
					<img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "kiedo-toolkit"); ?>">
				</div>
			<?php endif; ?>

        </div>

        <?php
	}


}

Plugin::instance()->widgets_manager->register( new Kiedo_Banner_Five );