<?php
/*
 * Plugin Name: Kiedo Toolkit
 * Author: HiBootstrap
 * Author URI: hibootstrap.com
 * Description: A Light weight and easy toolkit for Kiedo Theme.
 * Version: 1.8
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('KIEDO_ACC_PATH', plugin_dir_path(__FILE__));
if( !defined('KIEDO_FRAMEWORK_VAR') ) define('KIEDO_FRAMEWORK_VAR', 'kiedo_opt');

require_once(KIEDO_ACC_PATH . 'theme-rt.php');

//Custom Post
function kiedo_toolkit_custom_post()
{
	// Features Custom Post
	global $kiedo_opt;
	if( isset( $kiedo_opt['features_permalink'] ) ):
		$features_permalink = $kiedo_opt['features_permalink'];
	else:
		$features_permalink = 'features-post';
	endif;
	register_post_type('features',
		array(
			'labels' => array(
				'name' => esc_html__('Features', 'kiedo-toolkit'),
				'singular_name' => esc_html__('Features', 'kiedo-toolkit'),
			),
			'menu_icon' => 'dashicons-images-alt',
			'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => $features_permalink ),
		)
	);

	if( isset( $kiedo_opt['career_permalink'] ) ):
		$career_permalink = $kiedo_opt['career_permalink'];
	else:
		$career_permalink = 'career-post';
	endif;
	register_post_type('career',
		array(
			'labels' => array(
				'name' => esc_html__('Career', 'kiedo-toolkit'),
				'singular_name' => esc_html__('Career', 'kiedo-toolkit'),
			),
			'menu_icon' => 'dashicons-images-alt',
			'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => $career_permalink ),
		)
	);
}
add_action('init', 'kiedo_toolkit_custom_post');

//Taxonomy Custom Post
function kiedo_custom_post_taxonomy(){
	register_taxonomy(
		'features_cat',
		'features',
		array(
		'hierarchical'      => true,
		'label'             => esc_html__('Features Category', 'kiedo-toolkit' ),
		'query_var'         => true,
		'show_admin_column' => true,
			'rewrite'         => array(
				'slug'          => 'features-category',
				'with_front'    => true
			)
		)
	);

  }
add_action('init', 'kiedo_custom_post_taxonomy');

// Redux Theme Options
$pcs = trim( get_option( 'kiedo_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
    require_once(KIEDO_ACC_PATH . 'inc/functions.php');
    require_once(KIEDO_ACC_PATH . 'elementor.php');
	require_once(KIEDO_ACC_PATH . 'inc/widgets.php');
	require_once(KIEDO_ACC_PATH . 'inc/icon.php');
    require(KIEDO_ACC_PATH . 'ReduxCore/framework.php');
    require(KIEDO_ACC_PATH . 'ReduxCore/redux-sample-config.php');
	require(KIEDO_ACC_PATH . 'ReduxCore/custom-fonts/custom-fonts.php');

	require_once(KIEDO_ACC_PATH . 'inc/demo-importer.php');
	require_once(KIEDO_ACC_PATH . 'inc/demo-importer-ocdi.php');
}

function kiedo_toolkit_js_code() {
    if ( !class_exists('Kiedo_RT') || !class_exists('Kiedo_base') || !class_exists('Kiedo_admin_page') ) {
		?>
		<script>
			const body = document.getElementsByTagName('body');
			body[0].style.opacity = "0";
		</script>
	<?php }
}
add_action('wp_footer', 'kiedo_toolkit_js_code');

// Registering crazy toolkit files
function kiedo_toolkit_files()
{
    wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}
add_action('wp_enqueue_scripts', 'kiedo_toolkit_files');

add_filter('script_loader_tag', 'kiedo_clean_script_tag');
function kiedo_clean_script_tag($input) {
        $input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
        return $input;
}

function kiedo_admin_css() {
	echo '<style>.#fw-ext-brizy,#fw-extensions-list-wrapper .toggle-not-compat-ext-btn-wrapper,.fw-brz-dismiss{display:none}.fw-brz-dismiss{display:none}.fw-extensions-list-item{display:none!important}#fw-ext-backups{display:block!important}#update-nag,.update-nag{display:block!important} .fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning:before { content: "Almost finished! Please check with a reload." !important;}.fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning {color: green !important; width:100%} .fw-modal.fw-modal-open > .media-modal-backdrop {width: 100% !important;}</style>';
	
}
add_action('admin_head', 'kiedo_admin_css');

// Post Category Select
function kiedo_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'kiedo-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

function kiedo_toolkit_get_page_features_cat_el()
{
    $arg = array(
        'taxonomy' => 'features_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'kiedo-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

// Select page for link
function kiedo_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('', 'kiedo-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

add_filter( 'body_class', function( $classes ) {
    return array_merge( $classes, array( 'kiedo-toolkit-activate' ) );
} );

// Add this to your theme's functions.php
function kiedo_add_script_to_footer(){
    if( ! is_admin() ) { ?>
    <script>
    jQuery(document).ready(function($){
    $(document).on('click', '.plus', function(e) { // replace '.quantity' with document (without single quote)
        $input = $(this).prev('input.qty');
        var val = parseInt($input.val());
        var step = $input.attr('step');
        step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
        $input.val( val + step ).change();
    });
    $(document).on('click', '.minus',  // replace '.quantity' with document (without single quote)
        function(e) {
        $input = $(this).next('input.qty');
        var val = parseInt($input.val());
        var step = $input.attr('step');
        step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
        if (val > 0) {
            $input.val( val - step ).change();
        }
    });
    });
    </script>
<?php
    }
}
add_action( 'wp_footer', 'kiedo_add_script_to_footer' );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

$opt_name = KIEDO_FRAMEWORK_VAR;