<?php

use \FW_Ext_Backups_Demo as HB_FW_Ext_Backups_Demo;

if (! defined('ABSPATH')) {
    exit;
}

class Demo_Importer
{

    protected static $instance;

    public function __construct()
    {
        add_filter('plugin_action_links_hibo-demo-importer/hibo-demo-importer.php', array( $this, 'add_action_links' )); // Link from plugins page
        add_filter('rt_demo_installer_warning', array( $this, 'data_loss_warning' ));
        add_filter('fw:ext:backups-demo:demos', array( $this, 'demo_config' ));
        add_action('fw:ext:backups:tasks:success:id:demo-content-install', array( $this, 'after_demo_install' ));
    }

    public static function instance()
    {
        if (null == self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function add_action_links($links)
    {
        $mylinks = array(
            '<a href="' . esc_url(admin_url('tools.php?page=fw-backups-demo-content')) . '">'.__('Install Demo Contents', 'kiedo-toolkit').'</a>',
        );
        return array_merge($links, $mylinks);
    }

    public function data_loss_warning($links)
    {
        $html  = '<div style="margin-top:20px;color:#856404;font-size:18px;line-height:1.3;font-weight:600;margin-bottom:40px;background-color: #ffeeba;padding:10px 10px;border-radius: 10px;">';
        $html .= __('All of your existing data will be erased if you install/import One Click demo data from here, so we recommend importing demo data only for a new website.', 'kiedo-toolkit');
        $html .= '</div>';
        return $html;
    }

    public function demo_config($demos)
    {
        $demos_array = array(
            'demo1' => array(
                'title' => __('App Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home1.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/',
            ),
            'demo2' => array(
                'title' => __('App Statistical Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home5.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-two',
            ),
            'demo3' => array(
                'title' => __('Single Product Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home3.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-three',
            ),
            'demo4' => array(
                'title' => __('Statistical Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home4.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-four',
            ),
            'demo5' => array(
                'title' => __('Graphical Data Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home5.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-five',
            ),
            'demo6' => array(
                'title' => __('Line Graph Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home6.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-six',
            ),
            'demo7' => array(
                'title' => __('Product Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home7.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-seven/',
            ),
            'demo8' => array(
                'title' => __('Digital Product Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home8.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-eight',
            ),
            'demo9' => array(
                'title' => __('Data Landing Page', 'kiedo-toolkit'),
                'screenshot' => 'https://preview.hibootstrap.com/kiedo-wp/assets/img/demos/home9.jpg',
                'preview_link' => 'https://themes.hibootstrap.com/kiedo/home-nine/',
            ),
        );

        $download_url	 = 'https://themes.hibootstrap.com/tools/kiedo/';

        foreach ($demos_array as $id => $data) {
            $demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
                'url' => $download_url,
                'file_id' => $id,
            ));
            $demo->set_title($data['title']);
            $demo->set_screenshot($data['screenshot']);
            $demo->set_preview_link($data['preview_link']);

            $demos[ $demo->get_id() ] = $demo;

            unset($demo);
        }

        return $demos;
    }

    public function after_demo_install($collection)
    {
        // Update front page id
        $demos = array(
            'demo1'  => 11,
            'demo2'  => 905,
            'demo3'  => 1087,
            'demo4'  => 1175,
            'demo5'  => 1273,
            'demo6'  => 1341,
            'demo7'  => 1554,
            'demo8'  => 1843,
            'demo9'  => 2008,
        );

        $data = $collection->to_array();
        foreach ($data['tasks'] as $task) {
            if ($task['id'] == 'demo:demo-download') {
                $demo_id = $task['args']['demo_id'];
                $page_id = $demos[$demo_id];
                update_option('page_on_front', $page_id);
                flush_rewrite_rules();
                break;
            }
        }

        // Update WooCommerce email options //todo
        $email = get_option('admin_email');
        $name  = get_bloginfo('name', 'display');

        update_option('woocommerce_stock_email_recipient', $admin_email);
        update_option('woocommerce_email_from_address', $admin_email);
        update_option('woocommerce_email_from_name', $name);

        // Update post author id
        global $wpdb;
        $id = get_current_user_id();
        $query = "UPDATE $wpdb->posts SET post_author = $id";
        $wpdb->query($query);

        kiedo_function_pcs();
    }
}

Demo_Importer::instance();