<?php

namespace Botble\Ecommerce\Forms;

use Botble\Base\Forms\FormAbstract;
use Botble\Ecommerce\Facades\EcommerceHelper;
use Botble\Ecommerce\Http\Requests\AddShippingRegionRequest;
use Botble\Ecommerce\Models\Shipping;

class AddShippingRegionForm extends FormAbstract
{
    public function buildForm(): void
    {
        $existedCountries = Shipping::query()->pluck('country')->all();

        foreach ($existedCountries as &$existedCountry) {
            if (empty($existedCountry)) {
                $existedCountry = '';
            }
        }

        $countries = ['' => trans('plugins/ecommerce::shipping.all')] + EcommerceHelper::getAvailableCountries();

        $countries = array_diff_key($countries, array_flip($existedCountries));

        $this
            ->setupModel(new Shipping())
            ->contentOnly()
            ->setFormOptions([
                'url' => route('shipping_methods.region.create'),
            ])
            ->setTitle(trans('plugins/ecommerce::shipping.add_shipping_region'))
            ->setValidatorClass(AddShippingRegionRequest::class)
            ->withCustomFields()
            ->add('region', 'customSelect', [
                'label' => trans('plugins/ecommerce::shipping.country'),
                'label_attr' => [
                    'class' => 'control-label required',
                ],
                'attr' => [
                    'class' => 'select-country-search',
                ],
                'choices' => $countries,
            ]);
    }
}
