<x-core::layouts.base>
    <div style="display: none;">
        <svg xmlns="http://www.w3.org/2000/svg">
            <symbol
                class="icon-symbol--loaded"
                id="select-chevron"
            ><svg
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 20 20"
                >
                    <path d="M10 16l-4-4h8l-4 4zm0-12L6 8h8l-4-4z"></path>
                </svg></symbol>
        </svg>
    </div>

    <div class="page-wrapper">
        @include('core/base::layouts.partials.top-header')
        <div class="clearfix"></div>
        <div class="page-container">
            <div class="page-sidebar-wrapper">
                <div class="page-sidebar navbar-collapse collapse">
                    <div class="sidebar">
                        <div class="sidebar-content">
                            <ul
                                class="page-sidebar-menu page-header-fixed {{ session()->get('sidebar-menu-toggle') ? 'page-sidebar-menu-closed' : '' }}"
                                data-keep-expanded="false"
                                data-auto-scroll="false"
                                data-slide-speed="200"
                            >
                                @include('core/base::layouts.partials.sidebar')
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="page-content-wrapper">
                <div
                    class="page-content @if (Route::currentRouteName() == 'media.index') rv-media-integrate-wrapper @endif"
                    style="min-height: 100vh"
                >
                    {!! Breadcrumbs::render('main', PageTitle::getTitle(false)) !!}
                    <div class="clearfix"></div>
                    <div id="main">
                        {!! apply_filters('core_layout_before_content', null) !!}
                        @yield('content')
                        {!! apply_filters('core_layout_after_content', null) !!}
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
        </div>
        @include('core/base::layouts.partials.footer')
    </div>

    <x-slot:footer>
        @include('core/media::partials.media')
        @routes
    </x-slot:footer>
</x-core::layouts.base>
